/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.license.controller;

import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.license.controller.LicenseTicketRequester;
import com.hello2morrow.sonargraph.license.foundation.LicenseUtilities;
import com.hello2morrow.sonargraph.license.model.LicenseMessageCause;
import com.hello2morrow.sonargraph.license.model.LicenseServerHost;
import com.hello2morrow.sonargraph.license.model.ProductDescriptor;
import de.schlichtherle.truezip.file.TFile;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LicenseProvider {
    public static final String LINE_SEPARATOR = "\n";
    private static final String EQUALS = "=";
    private static final String ALGORITHM = "DSA";
    private static final String ENCODING = "ISO-8859-1";
    private static final String PUBLIC_KEY = "308201B83082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A0381850002818100A9C50F744F98DFFD639CB15E427AF645AF20565A8EBB6B4502A74873B076A6CC62B9AB796BB3BF49732DB186DDCD0D4AB0C8535668F2C9C998B3BE39A447D18270D166FD25EDF4A55C6588F03D9E5BE57E9E612B4B9410C95D64AED25D585842BA260B3D223DF1572BB8542F9270ECADD89C48FC096E7651CA0049F97F762746";
    private static final byte[] PUBLIC_KEY_BYTES = LicenseUtilities.convert("308201B83082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A0381850002818100A9C50F744F98DFFD639CB15E427AF645AF20565A8EBB6B4502A74873B076A6CC62B9AB796BB3BF49732DB186DDCD0D4AB0C8535668F2C9C998B3BE39A447D18270D166FD25EDF4A55C6588F03D9E5BE57E9E612B4B9410C95D64AED25D585842BA260B3D223DF1572BB8542F9270ECADD89C48FC096E7651CA0049F97F762746");
    private static final String LICENSE_SERVER_PUBLIC_KEY = "308201B83082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A0381850002818100CBCBF2574FED4E3B5D371EAFEFDD94372A7D964FE4CCA8AB84982B2B56A1E110DC5856654EB4C42107F4359C2EC53A7EDF61BCCE63777EB07D85E63E620D4471FC278EFB4942E5EB0FEC2EFDC0A64DAB14EB7FF2A63EEB7198D6D1E815E83DDF56420E5F25F6DBE9A27689F48232ADD27242120A1C6F621C734DC4ADB513E737";
    private static final byte[] LICENSE_SERVER_PUBLIC_KEY_BYTES = LicenseUtilities.convert("308201B83082012C06072A8648CE3804013082011F02818100FD7F53811D75122952DF4A9C2EECE4E7F611B7523CEF4400C31E3F80B6512669455D402251FB593D8D58FABFC5F5BA30F6CB9B556CD7813B801D346FF26660B76B9950A5A49F9FE8047B1022C24FBBA9D7FEB7C61BF83B57E7C6A8A6150F04FB83F6D3C51EC3023554135A169132F675F3AE2B61D72AEFF22203199DD14801C70215009760508F15230BCCB292B982A2EB840BF0581CF502818100F7E1A085D69B3DDECBBCAB5C36B857B97994AFBBFA3AEA82F9574C0B3D0782675159578EBAD4594FE67107108180B449167123E84C281613B7CF09328CC8A6E13C167A8B547C8D28E0A3AE1E2BB3A675916EA37F0BFA213562F1FB627A01243BCCA4F1BEA8519089A883DFE15AE59F06928B665E807B552564014C3BFECF492A0381850002818100CBCBF2574FED4E3B5D371EAFEFDD94372A7D964FE4CCA8AB84982B2B56A1E110DC5856654EB4C42107F4359C2EC53A7EDF61BCCE63777EB07D85E63E620D4471FC278EFB4942E5EB0FEC2EFDC0A64DAB14EB7FF2A63EEB7198D6D1E815E83DDF56420E5F25F6DBE9A27689F48232ADD27242120A1C6F621C734DC4ADB513E737");
    private static final String SYSTEM_DATE_CHECK_DIRECTORY;
    private static final int MS_A_DAY = 86400000;
    private static final String SIGNATURE_KEY = "Signature";
    private LicenseTicketRequester m_ticketRequester;

    static {
        switch (Platform.getOperatingSystem()) {
            case WINDOWS_32: 
            case WINDOWS_64: 
            case WINDOWS_ARM_64: {
                SYSTEM_DATE_CHECK_DIRECTORY = System.getenv("SystemRoot") + "/System32/config";
                break;
            }
            case LINUX_32: 
            case LINUX_64: 
            case LINUX_ARM_64: 
            case MAC_32: 
            case MAC_64: 
            case MAC_ARM_64: {
                SYSTEM_DATE_CHECK_DIRECTORY = "/var/log";
                break;
            }
            default: {
                SYSTEM_DATE_CHECK_DIRECTORY = null;
            }
        }
    }

    private String filterMacAddress(String address) {
        assert (address != null) : "Parameter 'address' of method 'filterMacAddress' must not be null";
        StringBuilder result = new StringBuilder();
        address = address.toUpperCase();
        int i = 0;
        while (i < address.length()) {
            char c = address.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private boolean macAddressesAreEqual(String a1, String a2) {
        assert (a1 != null) : "Parameter 'a1' of method 'macAddressesAreEqual' must not be null";
        assert (a2 != null) : "Parameter 'a2' of method 'macAddressesAreEqual' must not be null";
        return this.filterMacAddress(a1).equals(this.filterMacAddress(a2));
    }

    public OperationResult.IMessageCause checkMacAddresses(Set<String> macAddresses) {
        assert (macAddresses != null && !macAddresses.isEmpty()) : "Parameter 'macAddresses' of method 'checkMacAddresses' must not be empty";
        Map<String, String> detectedAddresses = LicenseUtilities.getMacAdresses();
        if (detectedAddresses.size() == 0) {
            return LicenseMessageCause.NO_MAC_ADDRESSES_FOUND;
        }
        boolean foundMatch = false;
        block0: for (String macAddress : macAddresses) {
            for (Map.Entry<String, String> nextEntry : detectedAddresses.entrySet()) {
                String detectedMacAddress = nextEntry.getKey();
                if (!this.macAddressesAreEqual(macAddress, detectedMacAddress)) continue;
                foundMatch = true;
                continue block0;
            }
        }
        if (foundMatch) {
            return null;
        }
        return LicenseMessageCause.NO_MATCHING_MAC_ADDRESS;
    }

    public Map<String, String> getLicenseContentFromActivationCode(List<String> hosts, LicenseServerHost licenseServer, ProxySettings proxySettings, ProductDescriptor productDescriptor, String activationCode, String ticketId, String ticketMagic, Consumer<String> lostLicenseEventConsumer, OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'getLicenseContentFromActivationCode' must not be null";
        this.m_ticketRequester = new LicenseTicketRequester(hosts, proxySettings, lostLicenseEventConsumer, licenseServer);
        Map<String, String> properties = this.m_ticketRequester.request(productDescriptor, activationCode, ticketId, ticketMagic, result);
        if (!this.m_ticketRequester.isFloatingLicense()) {
            this.m_ticketRequester = null;
        }
        return properties;
    }

    public void releaseLicenseTicket() {
        if (this.m_ticketRequester != null) {
            this.m_ticketRequester.releaseTicket();
            this.m_ticketRequester = null;
        }
    }

    public boolean refetchLicense() {
        if (this.m_ticketRequester != null) {
            return this.m_ticketRequester.refetchLicense();
        }
        return false;
    }

    private boolean verify(String data, byte[] signature, boolean fromLicenseServer) throws GeneralSecurityException {
        assert (data != null) : "Parameter 'data' of method 'verify' must not be null";
        Signature sig = Signature.getInstance(ALGORITHM);
        byte[] publicKey = PUBLIC_KEY_BYTES;
        if (fromLicenseServer) {
            publicKey = LICENSE_SERVER_PUBLIC_KEY_BYTES;
        }
        PublicKey key = LicenseUtilities.getPublic(publicKey);
        sig.initVerify(key);
        try {
            sig.update(data.getBytes(ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        return sig.verify(signature);
    }

    public String validate(OperationResult result, Map<String, String> licenseContent) {
        String signature;
        StringBuilder licenseContentBuffer;
        block8: {
            assert (result != null) : "Parameter 'result' of method 'parseAndValidate' must not be null";
            assert (licenseContent != null) : "Parameter 'licenseContent' of method 'parseAndValidate' must not be null";
            licenseContentBuffer = new StringBuilder(1024);
            signature = null;
            for (String currentKey : licenseContent.keySet()) {
                String value = licenseContent.get(currentKey);
                if (!currentKey.equals(SIGNATURE_KEY)) {
                    licenseContentBuffer.append(currentKey).append(EQUALS).append(value).append(LINE_SEPARATOR);
                    continue;
                }
                signature = value;
            }
            if (signature != null && !signature.isEmpty()) break block8;
            result.addError((OperationResult.IMessageCause)LicenseMessageCause.LICENSE_CORRUPTED_NO_SIGNATURE);
            return null;
        }
        try {
            boolean isValid = this.verify(licenseContentBuffer.toString(), LicenseUtilities.convert(signature), licenseContent.get("LicenseServerGenerated") != null);
            if (!isValid) {
                result.addError((OperationResult.IMessageCause)LicenseMessageCause.LICENSE_CORRUPTED_SIGNATURE_NOT_VALID);
                return null;
            }
        }
        catch (IllegalArgumentException | GeneralSecurityException e) {
            result.addError((OperationResult.IMessageCause)LicenseMessageCause.LICENSE_CORRUPTED_SIGNATURE_NOT_VALID, (Throwable)e);
            return null;
        }
        licenseContentBuffer.append('\n').append(SIGNATURE_KEY).append(EQUALS).append(signature).append(LINE_SEPARATOR);
        return licenseContentBuffer.toString();
    }

    public void hasSystemDateBeenManipulatedTooMuch(OperationResult result, Date currentSystemDate, Date expirationDate) {
        if (SYSTEM_DATE_CHECK_DIRECTORY != null) {
            int daysLeft;
            long systemMillis;
            long differenceMillis;
            long differenceDaysWithTwoHourSlack;
            long platformMillis = System.currentTimeMillis();
            TFile platformCheckDir = new TFile(SYSTEM_DATE_CHECK_DIRECTORY);
            TFile[] filesToCheck = platformCheckDir.listFiles();
            if (filesToCheck != null) {
                TFile[] tFileArray = filesToCheck;
                int n = filesToCheck.length;
                int n2 = 0;
                while (n2 < n) {
                    TFile child = tFileArray[n2];
                    long lastModified = child.lastModified();
                    if (lastModified > platformMillis) {
                        platformMillis = lastModified;
                    }
                    ++n2;
                }
            }
            if ((differenceDaysWithTwoHourSlack = ((differenceMillis = platformMillis - (systemMillis = currentSystemDate.getTime())) - 0x6DDD00L) / 86400000L) > 0L && differenceDaysWithTwoHourSlack > (long)(daysLeft = this.getDaysLeft(expirationDate))) {
                String msg = "Current date is " + new Date(systemMillis).toString() + ", but platform date is " + new Date(platformMillis).toString() + ". Please check your system time.";
                result.addError((OperationResult.IMessageCause)LicenseMessageCause.SYSTEM_DATE_MANIPULATED, msg, new Object[0]);
            }
        }
    }

    public boolean validateActivationCodeFormat(String validationCode) {
        assert (validationCode != null) : "Parameter 'validationCode' of method 'validateActivationCodeFormat' must not be null";
        String validationPattern = "^([\\d[A-Z]]{4}-){3}[\\d[A-Z]]{4}$";
        Pattern p = Pattern.compile("^([\\d[A-Z]]{4}-){3}[\\d[A-Z]]{4}$");
        Matcher m = p.matcher(validationCode);
        return m.matches();
    }

    public int getDaysLeft(Date dateToCheck) {
        long currentTime;
        assert (dateToCheck != null) : "Parameter 'dateToCheck' of method 'checkDaysleft' must not be null";
        long l = dateToCheck.getTime() + 86400000L - 1L;
        long time = l - (currentTime = System.currentTimeMillis());
        if (time <= 0L) {
            return (int)(time / 86400000L) - 1;
        }
        return (int)(time / 86400000L) + 1;
    }

    public static String getConnectionTestURL(String url) {
        return url + "/license_contracts/test_connection";
    }
}

