/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency;

import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.AnnotationEnumerationValueDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.AnnotationValueDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.CastDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.CatchDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.ClassAccessInlineDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.ClassBoundDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.ConstructorCallDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.DynamicMethodCallDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.DynamicMethodCallDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.ExtendsDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.FieldDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.HasAnnotationDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.HasTypeAnnotationDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.ImplementsDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.InstanceOfDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.InterfaceBoundDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.InterfaceMethodCallDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.InterfaceMethodCallDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.LocalVariableDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.MemberDefinitionProvidedByDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.NestedAnnotationValueDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.NewArrayDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.NewDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.OverridesDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.ParameterDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.PermitDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.PrivateMethodCallDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.ReadFieldDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.ReadFieldDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.ReadFieldInlineDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.ReadFieldInlineDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.ReturnDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.StaticMethodCallDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.StaticMethodCallDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.SuperMethodCallDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.SuperMethodCallDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.ThrowsDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.TypeArgumentDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.TypeArgumentExtendsDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.TypeArgumentSuperDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.UsesDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.UsesDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.VirtualMethodCallDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.VirtualMethodCallDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.WriteFieldDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.WriteFieldDependencyWithContext;

public final class DependencyCreator {
    private DependencyCreator() {
    }

    public static JavaDependency create(JavaDependencyContext context, JavaDependencyType type, ProgrammingElement from, ProgrammingElement to, int line) {
        assert (type != null) : "Parameter 'type' of method 'create' must not be null";
        assert (from != null) : "Parameter 'from' of method 'create' must not be null";
        assert (to != null) : "Parameter 'to' of method 'create' must not be null";
        JavaDependency dependency = null;
        switch (type) {
            case CLASS_ACCESS_INLINE: {
                dependency = new ClassAccessInlineDependency(from, to, line);
                break;
            }
            case CAST: {
                dependency = new CastDependency(from, to, line);
                break;
            }
            case CATCH: {
                dependency = new CatchDependency(from, to, line);
                break;
            }
            case INSTANCE_OF: {
                dependency = new InstanceOfDependency(from, to, line);
                break;
            }
            case OVERRIDES: {
                dependency = new OverridesDependency(from, to, line);
                break;
            }
            case MEMBER_DEFINITION_PROVIDED_BY: {
                dependency = new MemberDefinitionProvidedByDependency(from, to, line);
                break;
            }
            case NEW: {
                dependency = new NewDependency(from, to, line);
                break;
            }
            case NEW_ARRAY: {
                dependency = new NewArrayDependency(from, to, line);
                break;
            }
            case CONSTRUCTOR_CALL: {
                dependency = new ConstructorCallDependency(from, to, line);
                break;
            }
            case PRIVATE_METHOD_CALL: {
                dependency = new PrivateMethodCallDependency(from, to, line);
                break;
            }
            case EXTENDS: {
                dependency = new ExtendsDependency(from, to, line);
                break;
            }
            case IMPLEMENTS: {
                dependency = new ImplementsDependency(from, to, line);
                break;
            }
            case FIELD: {
                dependency = new FieldDependency(from, to, line);
                break;
            }
            case PARAMETER: {
                dependency = new ParameterDependency(from, to, line);
                break;
            }
            case RETURNS: {
                dependency = new ReturnDependency(from, to, line);
                break;
            }
            case PERMITS: {
                dependency = new PermitDependency(from, to, line);
                break;
            }
            case THROWS: {
                dependency = new ThrowsDependency(from, to, line);
                break;
            }
            case LOCAL_VARIABLE: {
                dependency = new LocalVariableDependency(from, to, line);
                break;
            }
            case USES: {
                dependency = context == null ? new UsesDependency(from, to, line) : new UsesDependencyWithContext(from, to, line, context);
                break;
            }
            case READ_FIELD: {
                dependency = context == null ? new ReadFieldDependency(from, to, line) : new ReadFieldDependencyWithContext(from, to, line, context);
                break;
            }
            case READ_FIELD_INLINE: {
                dependency = context == null ? new ReadFieldInlineDependency(from, to, line) : new ReadFieldInlineDependencyWithContext(from, to, line, context);
                break;
            }
            case WRITE_FIELD: {
                dependency = context == null ? new WriteFieldDependency(from, to, line) : new WriteFieldDependencyWithContext(from, to, line, context);
                break;
            }
            case SUPER_METHOD_CALL: {
                dependency = context == null ? new SuperMethodCallDependency(from, to, line) : new SuperMethodCallDependencyWithContext(from, to, line, context);
                break;
            }
            case VIRTUAL_METHOD_CALL: {
                dependency = context == null ? new VirtualMethodCallDependency(from, to, line) : new VirtualMethodCallDependencyWithContext(from, to, line, context);
                break;
            }
            case STATIC_METHOD_CALL: {
                dependency = context == null ? new StaticMethodCallDependency(from, to, line) : new StaticMethodCallDependencyWithContext(from, to, line, context);
                break;
            }
            case DYNAMIC_METHOD_CALL: {
                dependency = context == null ? new DynamicMethodCallDependency(from, to, line) : new DynamicMethodCallDependencyWithContext(from, to, line, context);
                break;
            }
            case INTERFACE_METHOD_CALL: {
                dependency = context == null ? new InterfaceMethodCallDependency(from, to, line) : new InterfaceMethodCallDependencyWithContext(from, to, line, context);
                break;
            }
            case CLASS_BOUND: {
                dependency = new ClassBoundDependencyWithContext(from, to, line, context);
                break;
            }
            case INTERFACE_BOUND: {
                dependency = new InterfaceBoundDependencyWithContext(from, to, line, context);
                break;
            }
            case TYPE_ARGUMENT: {
                dependency = new TypeArgumentDependencyWithContext(from, to, line, context);
                break;
            }
            case TYPE_ARGUMENT_EXTENDS: {
                dependency = new TypeArgumentExtendsDependencyWithContext(from, to, line, context);
                break;
            }
            case TYPE_ARGUMENT_SUPER: {
                dependency = new TypeArgumentSuperDependencyWithContext(from, to, line, context);
                break;
            }
            case HAS_ANNOTATION: {
                dependency = new HasAnnotationDependencyWithContext(from, to, line, context);
                break;
            }
            case HAS_TYPE_ANNOTATION: {
                dependency = new HasTypeAnnotationDependencyWithContext(from, to, line, context);
                break;
            }
            case ANNOTATION_ENUMERATION_VALUE: {
                dependency = new AnnotationEnumerationValueDependencyWithContext(from, to, line, context);
                break;
            }
            case ANNOTATION_VALUE: {
                dependency = new AnnotationValueDependencyWithContext(from, to, line, context);
                break;
            }
            case NESTED_ANNOTATION_VALUE: {
                dependency = new NestedAnnotationValueDependencyWithContext(from, to, line, context);
                break;
            }
            default: {
                assert (false) : "Unhandled dependency type: " + String.valueOf(type);
                break;
            }
        }
        assert (dependency instanceof JavaDependencyWithContext || context == null) : "Parameter 'dependencyContext' of method 'addDependency' must be 'null' for: " + String.valueOf((Object)dependency) + " (" + String.valueOf(context) + ")";
        return dependency;
    }
}

