/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.kotlinfile;

import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.kotlinfile.IKotlinType;
import java.util.List;
import org.objectweb.asm.Type;

public final class KotlinFunctionType
implements IKotlinType {
    private final IKotlinType[] m_parameterTypes;
    private final IKotlinType m_returnType;

    public KotlinFunctionType(List<IKotlinType> parameterTypes, IKotlinType returnType) {
        assert (parameterTypes != null) : "Parameter 'parameterTypes' of method 'KotlinFunctionType' must not be null";
        assert (returnType != null) : "Parameter 'returnType' of method 'KotlinFunctionType' must not be null";
        this.m_parameterTypes = parameterTypes.toArray(new IKotlinType[parameterTypes.size()]);
        this.m_returnType = returnType;
    }

    public IKotlinType getReturnType() {
        return this.m_returnType;
    }

    @Override
    public boolean matches(Type javaType) {
        assert (javaType != null) : "Parameter 'javaType' of method 'matches' must not be null";
        String clsName = javaType.getClassName();
        if (clsName != null) {
            String projectedName = "kotlin.jvm.functions.Function" + this.m_parameterTypes.length;
            return clsName.equals(projectedName);
        }
        return false;
    }
}

