/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaElementAccessor;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.HasAnnotationDependencyWithContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.ParameterDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.TypeArgumentDependencyWithContext;
import gnu.trove.set.hash.THashSet;
import java.util.List;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FormalParameterLocationProcessor
extends DependencyProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormalParameterLocationProcessor.class);
    private final JavaMethod m_element;
    private final String m_userTypeName;
    private final int m_lineNumber;
    private final JavaDependencyType m_dependencyType;

    public FormalParameterLocationProcessor(JavaMethod javaMethod, String userTypeName, int lineNumber, JavaDependencyType dependencyType) {
        assert (javaMethod != null) : "Parameter 'javaMethod' of method 'FormalParameterLocationProcessor' must not be null";
        assert (userTypeName != null && userTypeName.length() > 0) : "Parameter 'userTypeName' of method 'FormalParameterLocationProcessor' must not be empty";
        this.m_element = javaMethod;
        this.m_userTypeName = userTypeName;
        this.m_lineNumber = lineNumber;
        this.m_dependencyType = dependencyType;
        LOGGER.debug("{} {} {}", new Object[]{this.m_userTypeName, this.m_lineNumber, this.m_dependencyType});
    }

    @Override
    public void process(IJavaElementAccessor accessor) {
        List dependencies = this.m_element.getOutgoingDependencies(new IParserDependencyType[]{this.m_dependencyType});
        THashSet existingLines = new THashSet();
        JavaDependency sample = null;
        for (ParserDependency parserDependency : dependencies) {
            JavaDependency javaDependency = (JavaDependency)parserDependency;
            ProgrammingElement to = parserDependency.getTo();
            if (!(to instanceof JavaType) || !to.getName().replaceAll(Matcher.quoteReplacement("$"), ".").endsWith(this.m_userTypeName)) continue;
            int line = javaDependency.getRawLineNumber();
            if (line > 0) {
                if (existingLines.contains(this.m_lineNumber)) {
                    return;
                }
                existingLines.add(line);
            } else {
                javaDependency.setLineNumber(this.m_lineNumber);
                existingLines.add(this.m_lineNumber);
            }
            sample = javaDependency;
        }
        if (!existingLines.contains(this.m_lineNumber) && sample != null) {
            JavaDependency dependency = switch (this.m_dependencyType) {
                case JavaDependencyType.PARAMETER -> new ParameterDependency(sample.getFrom(), sample.getTo(), this.m_lineNumber);
                case JavaDependencyType.TYPE_ARGUMENT -> new TypeArgumentDependencyWithContext(sample.getFrom(), sample.getTo(), this.m_lineNumber, JavaDependencyContext.PARAMETER);
                case JavaDependencyType.HAS_ANNOTATION -> new HasAnnotationDependencyWithContext(sample.getFrom(), sample.getTo(), this.m_lineNumber, JavaDependencyContext.PARAMETER);
                default -> null;
            };
            if (dependency != null) {
                LOGGER.debug("Creating new {} dependency from {}:{} to {}", new Object[]{dependency.getDependencyType(), dependency.getFrom(), this.m_lineNumber, dependency.getTo()});
                this.m_element.addDependency(dependency);
            }
        }
    }
}

