/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.model.system;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.MetricScope;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.metrics.MetricCategory;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.JavaProviderId;
import java.util.Arrays;
import java.util.List;

public final class JavaMetricId
extends Enum<JavaMetricId>
implements IMetricId {
    public static final /* enum */ JavaMetricId JAVA_PACKAGE_CYCLE_GROUPS = new JavaMetricId("Number of all Java Package Cycle Groups", "Number of all Java package cycle groups, errors and warnings", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ JavaMetricId JAVA_CRITICAL_PACKAGE_CYCLE_GROUPS = new JavaMetricId("Number of Critical Java Package Cycle Groups", "Number of Java package cycle groups marked as errors.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ JavaMetricId JAVA_CYCLIC_PACKAGES = new JavaMetricId("Number of Cyclic Java Packages", "Number of cyclic Java packages.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ JavaMetricId JAVA_IGNORED_CYCLIC_PACKAGES = new JavaMetricId("Number of Ignored Cyclic Java Packages", "Number of ignored cyclic Java packages.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ JavaMetricId JAVA_BIGGEST_PACKAGE_CYCLE_GROUP = new JavaMetricId("Biggest Java Package Cycle Group", "Biggest Java package cycle group.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ JavaMetricId JAVA_PACKAGES = new JavaMetricId("Number of Java Packages", "Number of Java packages containing types in fully analyzed and issue ignoring code.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.SIZE});
    public static final /* enum */ JavaMetricId JAVA_PACKAGES_FULLY_ANALYZED = new JavaMetricId("Number of Java Packages (Full Analysis)", "Number of Java packages containing fully analyzed types.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.SIZE});
    public static final /* enum */ JavaMetricId JAVA_BYTE_CODE_INSTRUCTIONS = new JavaMetricId("Byte Code Instructions", "Number of Java byte code instructions.", false, IMetricId.StandardSorting.INDIFFERENT, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.SIZE});
    public static final /* enum */ JavaMetricId JAVA_STRUCTURAL_DEBT_INDEX_PACKAGES = new JavaMetricId("Structural Debt Index (Java Packages)", "Cumulative structural debt index of all Java package cycle groups.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CODE_ANALYSIS});
    public static final /* enum */ JavaMetricId JAVA_PARSER_DEPENDENCIES_TO_REMOVE_PACKAGES = new JavaMetricId("Parser Dependencies to Remove (Java Packages)", "Number of code lines to change to break up all Java package cycle groups).", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CODE_ANALYSIS, MetricCategory.DEPENDENCY});
    public static final /* enum */ JavaMetricId JAVA_COMPONENT_DEPENDENCIES_TO_REMOVE_PACKAGES = new JavaMetricId("Component Dependencies to Remove (Java Packages)", "Number of component dependencies to remove to break up all Java package cycle groups.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CODE_ANALYSIS, MetricCategory.DEPENDENCY});
    public static final /* enum */ JavaMetricId JAVA_CLASS_MEMBER_VISIBILITY = new JavaMetricId("Java Member Visibility (%)", "Percentage of non-private Java members in a class", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, new IMetricCategory[]{MetricCategory.CODE_ANALYSIS});
    public static final /* enum */ JavaMetricId JAVA_PACKAGE_PUBLIC_VISIBILITY = new JavaMetricId("Java Public Visibility (%) (Module)", "Percentage of public Java types in a Java package", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricScope.MODULE, new IMetricCategory[]{MetricCategory.CODE_ANALYSIS});
    public static final /* enum */ JavaMetricId JAVA_AVERAGE_CLASS_MEMBER_VISIBILITY = new JavaMetricId("Average Java Class Member Visibility (%) (Module)", "Average of Java class member visibility in a Java package", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, MetricScope.MODULE, new IMetricCategory[]{MetricCategory.CODE_ANALYSIS});
    public static final /* enum */ JavaMetricId JAVA_AVERAGE_PACKAGE_PUBLIC_VISIBILITY = new JavaMetricId("Average Java Public Visibility (%)", "Average of Java public visibility for all Java packages in a Java module", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, new IMetricCategory[]{MetricCategory.CODE_ANALYSIS});
    public static final /* enum */ JavaMetricId JAVA_CYCLICITY_PACKAGES = new JavaMetricId("Cyclicity (Java Packages)", "Cumulated cyclicity of Java package cycle groups.", false, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.NULL_OR_POSITIVE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ JavaMetricId JAVA_RELATIVE_CYCLICITY_PACKAGES = new JavaMetricId("Relative Cyclicity (Java Packages)", "Relative Java package cyclicity in percent.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, new IMetricCategory[]{MetricCategory.CYCLE});
    public static final /* enum */ JavaMetricId JAVA_AVERAGE_RELATIVE_CYCLICITY_PACKAGES = new JavaMetricId("Average Relative Cyclicity (Java Packages)", "Weighted average of relative Java package cyclicity of modules in percent.", true, IMetricId.StandardSorting.HIGHER_WORSE, IMetricId.MetricRange.PERCENTAGE, new IMetricCategory[]{MetricCategory.CYCLE});
    private final String m_presentationName;
    private final String m_description;
    private final boolean m_isFloat;
    private final IMetricCategory[] m_categories;
    private final MetricScope m_metricScope;
    private final IMetricId.MetricRange m_range;
    private final IMetricId.StandardSorting m_sorting;
    private static final /* synthetic */ JavaMetricId[] ENUM$VALUES;

    static {
        ENUM$VALUES = new JavaMetricId[]{JAVA_PACKAGE_CYCLE_GROUPS, JAVA_CRITICAL_PACKAGE_CYCLE_GROUPS, JAVA_CYCLIC_PACKAGES, JAVA_IGNORED_CYCLIC_PACKAGES, JAVA_BIGGEST_PACKAGE_CYCLE_GROUP, JAVA_PACKAGES, JAVA_PACKAGES_FULLY_ANALYZED, JAVA_BYTE_CODE_INSTRUCTIONS, JAVA_STRUCTURAL_DEBT_INDEX_PACKAGES, JAVA_PARSER_DEPENDENCIES_TO_REMOVE_PACKAGES, JAVA_COMPONENT_DEPENDENCIES_TO_REMOVE_PACKAGES, JAVA_CLASS_MEMBER_VISIBILITY, JAVA_PACKAGE_PUBLIC_VISIBILITY, JAVA_AVERAGE_CLASS_MEMBER_VISIBILITY, JAVA_AVERAGE_PACKAGE_PUBLIC_VISIBILITY, JAVA_CYCLICITY_PACKAGES, JAVA_RELATIVE_CYCLICITY_PACKAGES, JAVA_AVERAGE_RELATIVE_CYCLICITY_PACKAGES};
    }

    private JavaMetricId(String presentationName, String description, boolean isFloat, IMetricId.StandardSorting sorting, IMetricId.MetricRange range, IMetricCategory ... category) {
        this(presentationName, description, isFloat, sorting, range, MetricScope.SYSTEM, category);
    }

    private JavaMetricId(String presentationName, String description, boolean isFloat, IMetricId.StandardSorting sorting, IMetricId.MetricRange range, MetricScope metricScope, IMetricCategory ... category) {
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'CoreMetricId' must not be empty";
        assert (description != null && description.length() > 0) : "Parameter 'description' of method 'CoreMetricId' must not be empty";
        assert (metricScope != null) : "Parameter 'metricScope' of method 'JavaMetricId' must not be null";
        assert (range != null) : "Parameter 'range' of method 'JavaMetricId' must not be null";
        assert (sorting != null) : "Parameter 'sorting' of method 'JavaMetricId' must not be null";
        this.m_presentationName = presentationName;
        this.m_description = description;
        this.m_isFloat = isFloat;
        this.m_metricScope = metricScope;
        this.m_categories = category;
        this.m_range = range;
        this.m_sorting = sorting;
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public IProviderId getProvider() {
        return JavaProviderId.INSTANCE;
    }

    public String getDescription() {
        return this.m_description;
    }

    public boolean isFloat() {
        return this.m_isFloat;
    }

    public List<IMetricCategory> getCategories() {
        return Arrays.asList(this.m_categories);
    }

    public IMetricId.IMetricRange getRange() {
        return this.m_range;
    }

    public IMetricId.StandardSorting getSorting() {
        return this.m_sorting;
    }

    public MetricScope getMetricScope() {
        return this.m_metricScope;
    }

    public static JavaMetricId[] values() {
        JavaMetricId[] javaMetricIdArray = ENUM$VALUES;
        int n = javaMetricIdArray.length;
        JavaMetricId[] javaMetricIdArray2 = new JavaMetricId[n];
        System.arraycopy(ENUM$VALUES, 0, javaMetricIdArray2, 0, n);
        return javaMetricIdArray2;
    }

    public static JavaMetricId valueOf(String string) {
        return Enum.valueOf(JavaMetricId.class, string);
    }
}

