/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile;

import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyToFieldProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyToMethodProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyToTypeProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.SyntheticsHelper;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.AnnotationVisitorImpl;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.DefaultValueAnnotationInterfaceMethodVisitorImpl;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.IClassFileParserContext;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.LocalVariableSignatureVisitorImpl;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaNameUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.ignore.JavaIgnoreAccess;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.LocalVariableDefinitionByteCode;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.LocalVariableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MethodVisitorImpl
extends MethodVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodVisitorImpl.class);
    private static final char ARRAY_START_CHAR = '[';
    private static final String GROOVY_ACCESS = "$get$$class$";
    private final IClassFileParserContext m_classFileParserContext;
    private final AnnotationVisitorImpl m_annotationVisitor;
    private final DefaultValueAnnotationInterfaceMethodVisitorImpl m_defaultValueAnnotationInterfaceMethodVisitor;
    private final Map<Label, Set<String>> m_labelToCatchedExceptionTypeName = new HashMap<Label, Set<String>>();
    private final Map<Label[], Integer> m_switchLabels = new HashMap<Label[], Integer>();
    private final List<LocalVariableDefinitionByteCode> m_localVariableDefinitions = new ArrayList<LocalVariableDefinitionByteCode>();
    private final List<Label> m_labels = new ArrayList<Label>();
    private final Map<Label, Integer> m_labelToLine = new HashMap<Label, Integer>();
    private int m_currentLine = -1;

    MethodVisitorImpl(IClassFileParserContext context) {
        super(589824);
        assert (context != null) : "Parameter 'context' of method 'MethodVisitorImpl' must not be null";
        this.m_classFileParserContext = context;
        this.m_annotationVisitor = new AnnotationVisitorImpl(this.m_classFileParserContext, JavaDependencyContext.METHOD);
        this.m_defaultValueAnnotationInterfaceMethodVisitor = new DefaultValueAnnotationInterfaceMethodVisitorImpl(this.m_classFileParserContext);
    }

    private int getEndLineOfBlock(Label label) {
        Label previousLabel;
        Integer startLineNumberAsInteger;
        assert (label != null) : "Parameter 'label' of method 'getEndLine' must not be null";
        int index = this.m_labels.indexOf(label);
        if (index > 0 && (startLineNumberAsInteger = this.m_labelToLine.get(previousLabel = this.m_labels.get(index - 1))) != null) {
            return startLineNumberAsInteger;
        }
        return -1;
    }

    public void visitParameter(String name, int access) {
        super.visitParameter(name, access);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return this.m_defaultValueAnnotationInterfaceMethodVisitor;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.m_classFileParserContext.incrementSize();
        this.m_classFileParserContext.addDependencyToType(Type.getType((String)desc), -1, JavaDependencyContext.METHOD, JavaDependencyType.HAS_ANNOTATION);
        this.m_annotationVisitor.setDependencyContext(JavaDependencyContext.METHOD, this.m_currentLine);
        return this.m_annotationVisitor;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.m_classFileParserContext.addDependencyToType(Type.getType((String)desc), -1, JavaDependencyContext.PARAMETER, JavaDependencyType.HAS_ANNOTATION);
        this.m_annotationVisitor.setDependencyContext(JavaDependencyContext.PARAMETER, this.m_currentLine);
        return this.m_annotationVisitor;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        JavaDependencyContext dependencyContext = JavaDependencyContext.METHOD;
        this.m_classFileParserContext.addDependencyToType(Type.getType((String)desc), this.m_currentLine, dependencyContext, JavaDependencyType.HAS_TYPE_ANNOTATION);
        this.m_annotationVisitor.setDependencyContext(dependencyContext, this.m_currentLine);
        return this.m_annotationVisitor;
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.m_classFileParserContext.addDependencyToType(Type.getType((String)desc), this.m_currentLine, JavaDependencyContext.INSTRUCTION, JavaDependencyType.HAS_ANNOTATION);
        this.m_annotationVisitor.setDependencyContext(JavaDependencyContext.INSTRUCTION, this.m_currentLine);
        return this.m_annotationVisitor;
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.m_classFileParserContext.addDependencyToType(Type.getType((String)desc), this.m_currentLine, JavaDependencyContext.TRY_CATCH, JavaDependencyType.HAS_ANNOTATION);
        this.m_annotationVisitor.setDependencyContext(JavaDependencyContext.TRY_CATCH, this.m_currentLine);
        return this.m_annotationVisitor;
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
        this.m_classFileParserContext.addDependencyToType(Type.getType((String)desc), this.m_currentLine, JavaDependencyContext.LOCAL_VARIABLE, JavaDependencyType.HAS_ANNOTATION);
        this.m_annotationVisitor.setDependencyContext(JavaDependencyContext.LOCAL_VARIABLE, this.m_currentLine);
        return this.m_annotationVisitor;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitCode() {
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
    }

    private void visitedInstruction() {
        JavaMethod method;
        if (!(this.m_currentLine == -1 || !this.m_classFileParserContext.isCurrentTypePotentiallyAnonymous() || this.m_classFileParserContext.hasFirstInstructionLineNumberOfPotentiallyAnonymousTypeBeenAdded() || (method = this.m_classFileParserContext.getCurrentJavaMethod()).isInitializer() || method.hasFlag(JavaElementFlag.SYNTHETIC) || method.hasFlag(JavaElementFlag.BRIDGE))) {
            this.m_classFileParserContext.getModuleModel().addAnonymousTypeLineNumberOfFirstInstructionInMethod(this.m_classFileParserContext.getCurrentJavaType(), this.m_classFileParserContext.getCurrentJavaMethod(), this.m_currentLine);
            this.m_classFileParserContext.setFirstInstructionLineNumberOfPotentiallyAnonymousTypeAdded();
        }
    }

    public void visitInsn(int opcode) {
        this.m_classFileParserContext.incrementSize();
        this.visitedInstruction();
    }

    public void visitIntInsn(int opcode, int operand) {
        this.m_classFileParserContext.incrementSize();
        this.visitedInstruction();
    }

    public void visitVarInsn(int opcode, int localVarIndex) {
        this.m_classFileParserContext.incrementSize();
        this.visitedInstruction();
    }

    public void visitTypeInsn(int opcode, String type) {
        JavaDependencyType dependencyType;
        assert (type != null && type.length() > 0) : "Parameter 'type' of method 'visitTypeInsn' must not be empty";
        this.m_classFileParserContext.incrementSize();
        switch (opcode) {
            case 187: {
                dependencyType = JavaDependencyType.NEW;
                break;
            }
            case 189: {
                dependencyType = JavaDependencyType.NEW_ARRAY;
                break;
            }
            case 192: {
                dependencyType = JavaDependencyType.USES;
                break;
            }
            case 193: {
                dependencyType = JavaDependencyType.INSTANCE_OF;
                break;
            }
            default: {
                dependencyType = null;
                assert (false) : "Unhandled opcode: " + opcode;
                break;
            }
        }
        if (type.charAt(0) == '[') {
            this.m_classFileParserContext.addDependencyToType(Type.getType((String)type), this.m_currentLine, null, dependencyType);
        } else {
            String fqTypeName = this.m_classFileParserContext.convertToFqName(type);
            this.m_classFileParserContext.addDependencyToTypeReference(fqTypeName, this.m_currentLine, null, dependencyType);
            if (dependencyType == JavaDependencyType.NEW && this.m_currentLine != -1 && JavaNameUtility.isPotentialAnonymousType(fqTypeName)) {
                this.m_classFileParserContext.getModuleModel().addAnonymousTypeInstantiationInfo(fqTypeName, this.m_classFileParserContext.getCurrentJavaMethod(), this.m_currentLine);
            }
        }
        this.visitedInstruction();
    }

    public void visitFieldInsn(int opcode, String owner, String fieldName, String desc) {
        JavaDependencyType dependencyType;
        assert (owner != null && owner.length() > 0) : "Parameter 'owner' of method 'visitFieldInsn' must not be empty";
        assert (fieldName != null && fieldName.length() > 0) : "Parameter 'fileName' of method 'visitFieldInsn' must not be empty";
        assert (desc != null && desc.length() > 0) : "Parameter 'desc' of method 'visitFieldInsn' must not be empty";
        if (SyntheticsHelper.isFieldSynthetic(fieldName)) {
            return;
        }
        this.m_classFileParserContext.incrementSize();
        boolean targetIsStatic = false;
        switch (opcode) {
            case 179: {
                dependencyType = JavaDependencyType.WRITE_FIELD;
                targetIsStatic = true;
                break;
            }
            case 181: {
                dependencyType = JavaDependencyType.WRITE_FIELD;
                break;
            }
            case 178: {
                dependencyType = JavaDependencyType.READ_FIELD;
                targetIsStatic = true;
                break;
            }
            case 180: {
                dependencyType = JavaDependencyType.READ_FIELD;
                break;
            }
            default: {
                dependencyType = null;
                assert (false) : "Unhandled op code: " + opcode;
                break;
            }
        }
        String convertedOwnerFqName = this.m_classFileParserContext.convertToFqName(owner);
        JavaIgnoreAccess ignoreAccess = this.m_classFileParserContext.getGlobalModel().getIgnoreAccess();
        if (ignoreAccess.ignoreTypeAccess(null, dependencyType, convertedOwnerFqName) || ignoreAccess.ignoreFieldAccess(null, dependencyType, convertedOwnerFqName, fieldName)) {
            return;
        }
        DependencyToFieldProcessor dependencyProcessor = new DependencyToFieldProcessor(this.m_classFileParserContext.getCurrentJavaElement(), this.m_currentLine, null, dependencyType, this.m_classFileParserContext.getCurrentModule(), convertedOwnerFqName, fieldName);
        if (targetIsStatic) {
            dependencyProcessor.setTargetElementFlags(JavaElementFlag.STATIC);
        }
        this.m_classFileParserContext.getGlobalModel().addDependencyProcessor(dependencyProcessor);
        this.visitedInstruction();
    }

    public void visitMethodInsn(int opcode, String owner, String methodName, String desc, boolean ownerIsInterface) {
        assert (owner != null && owner.length() > 0) : "Parameter 'owner' of method 'visitMethodInsn' must not be empty";
        assert (methodName != null && methodName.length() > 0) : "Parameter 'methodName' of method 'visitMethodInsn' must not be empty";
        assert (desc != null && desc.length() > 0) : "Parameter 'desc' of method 'visitMethodInsn' must not be empty";
        this.m_classFileParserContext.incrementSize();
        if (owner.startsWith("[")) {
            return;
        }
        String convertedOwnerFqName = this.m_classFileParserContext.convertToFqName(owner);
        if ("java.lang.Enum".equals(convertedOwnerFqName) && "<init>".equals(methodName)) {
            return;
        }
        if (SyntheticsHelper.isMethodSynthetic(convertedOwnerFqName, methodName, false)) {
            return;
        }
        JavaDependencyType dependencyType = switch (opcode) {
            case 182 -> JavaDependencyType.VIRTUAL_METHOD_CALL;
            case 184 -> JavaDependencyType.STATIC_METHOD_CALL;
            case 183 -> {
                if ("<init>".equals(methodName)) {
                    yield JavaDependencyType.CONSTRUCTOR_CALL;
                }
                if (this.m_classFileParserContext.getCurrentJavaType().getFqName().equals(convertedOwnerFqName)) {
                    yield JavaDependencyType.PRIVATE_METHOD_CALL;
                }
                yield JavaDependencyType.SUPER_METHOD_CALL;
            }
            case 185 -> JavaDependencyType.INTERFACE_METHOD_CALL;
            case 186 -> JavaDependencyType.DYNAMIC_METHOD_CALL;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"unexpected call opcode");
                }
                yield null;
            }
        };
        JavaIgnoreAccess ignoreAccess = this.m_classFileParserContext.getGlobalModel().getIgnoreAccess();
        if (ignoreAccess.ignoreTypeAccess(null, dependencyType, convertedOwnerFqName) || ignoreAccess.ignoreMethodAccess(null, dependencyType, convertedOwnerFqName, methodName)) {
            return;
        }
        this.m_classFileParserContext.incrementSize();
        this.m_classFileParserContext.getGlobalModel().addDependencyProcessor(new DependencyToMethodProcessor(this.m_classFileParserContext.getCurrentJavaElement(), this.m_currentLine, null, dependencyType, this.m_classFileParserContext.getCurrentModule(), convertedOwnerFqName, methodName, desc));
        if (methodName.startsWith(GROOVY_ACCESS)) {
            String typeName = methodName.substring(GROOVY_ACCESS.length());
            typeName = typeName.replace("$_", "#");
            typeName = typeName.replace('$', '.');
            typeName = typeName.replace("#", "$_");
            if (!this.m_classFileParserContext.getCurrentJavaType().getFqName().equals(typeName)) {
                this.m_classFileParserContext.getGlobalModel().addDependencyProcessor(new DependencyToTypeProcessor(this.m_classFileParserContext.getCurrentJavaElement(), this.m_currentLine, null, JavaDependencyType.NEW, this.m_classFileParserContext.getCurrentModule(), typeName));
                if (this.m_currentLine != -1 && JavaNameUtility.isPotentialAnonymousType(typeName)) {
                    this.m_classFileParserContext.getModuleModel().addAnonymousTypeInstantiationInfo(typeName, this.m_classFileParserContext.getCurrentJavaMethod(), this.m_currentLine);
                }
            }
        }
        this.visitedInstruction();
    }

    public void visitInvokeDynamicInsn(String methodName, String methodDesc, Handle bootstrapMethodHandle, Object ... bootstrapMethodArgs) {
        block14: {
            assert (methodName != null && methodName.length() > 0) : "Parameter 'methodName' of method 'visitInvokeDynamicInsn' must not be empty";
            assert (methodDesc != null && methodDesc.length() > 0) : "Parameter 'methodDesc' of method 'visitInvokeDynamicInsn' must not be empty";
            this.m_classFileParserContext.incrementSize();
            this.m_classFileParserContext.addDependencyToType(Type.getReturnType((String)methodDesc), this.m_currentLine, null, JavaDependencyType.USES);
            Type[] typeArray = Type.getArgumentTypes((String)methodDesc);
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type nextArgumentType = typeArray[n2];
                this.m_classFileParserContext.addDependencyToType(nextArgumentType, this.m_currentLine, null, JavaDependencyType.USES);
                ++n2;
            }
            JavaIgnoreAccess ignoreAccess = this.m_classFileParserContext.getGlobalModel().getIgnoreAccess();
            if (bootstrapMethodArgs.length <= 0) break block14;
            Object[] objectArray = bootstrapMethodArgs;
            int n3 = bootstrapMethodArgs.length;
            n = 0;
            while (n < n3) {
                block16: {
                    String desc;
                    String name;
                    String owner;
                    block17: {
                        Object nextArg;
                        block15: {
                            nextArg = objectArray[n];
                            if (!(nextArg instanceof Type)) break block15;
                            this.m_classFileParserContext.addDependencyToType((Type)nextArg, this.m_currentLine, null, JavaDependencyType.USES);
                            break block16;
                        }
                        if (!(nextArg instanceof Handle)) break block16;
                        Handle nextHandle = (Handle)nextArg;
                        owner = nextHandle.getOwner();
                        name = nextHandle.getName();
                        desc = nextHandle.getDesc();
                        int tag = nextHandle.getTag();
                        if (owner == null || owner.isEmpty() || name == null || name.isEmpty() || desc == null || desc.isEmpty()) break block17;
                        String convertedOwnerFqName = this.m_classFileParserContext.convertToFqName(owner);
                        switch (tag) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                if (!SyntheticsHelper.isFieldSynthetic(convertedOwnerFqName)) {
                                    if (!ignoreAccess.ignoreTypeAccess(null, JavaDependencyType.USES, convertedOwnerFqName)) {
                                        if (!ignoreAccess.ignoreFieldAccess(null, JavaDependencyType.USES, convertedOwnerFqName, name)) {
                                            this.m_classFileParserContext.getGlobalModel().addDependencyProcessor(new DependencyToFieldProcessor(this.m_classFileParserContext.getCurrentJavaMethod(), this.m_currentLine, null, JavaDependencyType.USES, this.m_classFileParserContext.getCurrentModule(), convertedOwnerFqName, name));
                                            break;
                                        }
                                    }
                                }
                                break block16;
                            }
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                if (!SyntheticsHelper.isMethodSynthetic(convertedOwnerFqName, name, false)) {
                                    if (!ignoreAccess.ignoreTypeAccess(null, JavaDependencyType.USES, convertedOwnerFqName)) {
                                        if (!ignoreAccess.ignoreMethodAccess(null, JavaDependencyType.USES, convertedOwnerFqName, name)) {
                                            this.m_classFileParserContext.getGlobalModel().addDependencyProcessor(new DependencyToMethodProcessor(this.m_classFileParserContext.getCurrentJavaMethod(), this.m_currentLine, null, JavaDependencyType.USES, this.m_classFileParserContext.getCurrentModule(), convertedOwnerFqName, name, desc));
                                            break;
                                        }
                                    }
                                }
                                break block16;
                            }
                        }
                        break block16;
                    }
                    LOGGER.warn("Unhandled dynamic instruction (o/n/d): " + owner + "/" + name + "/" + desc);
                }
                ++n;
            }
        }
        this.visitedInstruction();
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.m_classFileParserContext.incrementSize();
        this.visitedInstruction();
    }

    public void visitLdcInsn(Object cst) {
        this.m_classFileParserContext.incrementSize();
        if (cst instanceof Type) {
            Type type = (Type)cst;
            switch (type.getSort()) {
                case 10: {
                    String convertedFqTypeName = this.m_classFileParserContext.convertToFqName(type.getClassName());
                    if (this.m_classFileParserContext.getGlobalModel().getIgnoreAccess().ignoreTypeAccess(null, JavaDependencyType.USES, convertedFqTypeName)) {
                        return;
                    }
                    this.m_classFileParserContext.getGlobalModel().addDependencyProcessor(new DependencyToTypeProcessor(this.m_classFileParserContext.getCurrentJavaElement(), this.m_currentLine, null, JavaDependencyType.USES, this.m_classFileParserContext.getCurrentModule(), convertedFqTypeName));
                    break;
                }
                case 11: {
                    LOGGER.warn("Unhandled dependency: " + type.toString());
                }
            }
        }
        this.visitedInstruction();
    }

    public void visitIincInsn(int var, int increment) {
        this.m_classFileParserContext.incrementSize();
        this.visitedInstruction();
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        if (labels != null && labels.length > 0) {
            this.m_switchLabels.put(labels, this.m_currentLine);
        }
        this.m_classFileParserContext.incrementSize();
        this.visitedInstruction();
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.m_classFileParserContext.incrementSize();
        this.visitedInstruction();
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.m_classFileParserContext.incrementSize();
        this.visitedInstruction();
    }

    public void visitLabel(Label label) {
        this.m_labels.add(label);
    }

    public void visitTryCatchBlock(Label start, Label end, Label label, String type) {
        this.m_classFileParserContext.incrementSize();
        if (type != null) {
            Set<String> types = this.m_labelToCatchedExceptionTypeName.get(label);
            if (types == null) {
                types = new HashSet<String>();
                this.m_labelToCatchedExceptionTypeName.put(label, types);
            }
            types.add(type);
        }
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int localVarIndex) {
        Type type = Type.getType((String)desc);
        if (type.getSort() < 9) {
            return;
        }
        if (type.getSort() == 9 && type.getElementType().getSort() != 10) {
            return;
        }
        if (SyntheticsHelper.isLocalVariableSynthetic(name)) {
            return;
        }
        this.m_localVariableDefinitions.add(new LocalVariableDefinitionByteCode(name, type.getSort() == 9 ? type.getElementType() : type, start, end, signature));
    }

    public void visitLineNumber(int line, Label start) {
        this.m_currentLine = line;
        this.m_labelToLine.put(start, line);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
    }

    public void visitEnd() {
        Integer currentLine = null;
        for (Label label : this.m_labels) {
            Integer nextLine = this.m_labelToLine.get(label);
            if (nextLine != null) {
                currentLine = nextLine;
                continue;
            }
            this.m_labelToLine.put(label, currentLine);
        }
        for (Map.Entry entry : this.m_labelToCatchedExceptionTypeName.entrySet()) {
            Label nextLabel = (Label)entry.getKey();
            for (String nextType : (Set)entry.getValue()) {
                String convertedFqName = this.m_classFileParserContext.convertToFqName(nextType);
                if (this.m_classFileParserContext.getGlobalModel().getIgnoreAccess().ignoreTypeAccess(null, JavaDependencyType.CATCH, convertedFqName)) continue;
                Integer lineAsInteger = this.m_labelToLine.get(nextLabel);
                int line = lineAsInteger != null ? lineAsInteger : -1;
                this.m_classFileParserContext.getGlobalModel().addDependencyProcessor(new DependencyToTypeProcessor(this.m_classFileParserContext.getCurrentJavaElement(), line, null, JavaDependencyType.CATCH, this.m_classFileParserContext.getCurrentModule(), convertedFqName));
            }
        }
        for (LocalVariableDefinitionByteCode localVariableDefinitionByteCode : this.m_localVariableDefinitions) {
            String locVarName = localVariableDefinitionByteCode.getName();
            int endLineOfBlock = this.getEndLineOfBlock(localVariableDefinitionByteCode.getEndLabel());
            JavaMethod from = this.m_classFileParserContext.getCurrentJavaMethod();
            assert (from != null) : "'from' of method 'processVarIndexes' must not be null";
            if (this.m_classFileParserContext.getGlobalModel().localVariableInfoAlreadyAdded(from, locVarName, endLineOfBlock)) continue;
            String toTypeClassName = localVariableDefinitionByteCode.getType().getClassName();
            LocalVariableInfo info = new LocalVariableInfo(this.m_classFileParserContext.getCurrentModule(), endLineOfBlock, toTypeClassName);
            if (localVariableDefinitionByteCode.hasSignature()) {
                String signature = localVariableDefinitionByteCode.getSignature();
                try {
                    SignatureReader signatureReader = new SignatureReader(signature);
                    LocalVariableSignatureVisitorImpl localVariableSignatureVisitorImpl = new LocalVariableSignatureVisitorImpl(this.m_classFileParserContext, info);
                    signatureReader.accept((SignatureVisitor)localVariableSignatureVisitorImpl);
                }
                catch (Throwable t) {
                    JavaMethod currentMethod = this.m_classFileParserContext.getCurrentJavaMethod();
                    JavaType currentType = this.m_classFileParserContext.getCurrentJavaType();
                    LOGGER.warn("Unable to parse local variable signature '" + signature + "' of (type/method/variable/line): " + currentType.getFqName() + "/" + currentMethod.getShortName() + "/" + localVariableDefinitionByteCode.getName() + "/" + endLineOfBlock);
                }
            }
            this.m_classFileParserContext.getGlobalModel().addLocalVariableInfo(from, locVarName, info);
        }
        for (Map.Entry entry : this.m_switchLabels.entrySet()) {
            int startLineNumber;
            int endLineNumber = startLineNumber = ((Integer)entry.getValue()).intValue();
            Label[] labelArray = (Label[])entry.getKey();
            int n = labelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Label nextSwitchLabel = labelArray[n2];
                Integer nextLine = this.m_labelToLine.get(nextSwitchLabel);
                if (nextLine != null) {
                    endLineNumber = Math.max(endLineNumber, nextLine);
                }
                ++n2;
            }
            this.m_classFileParserContext.getGlobalModel().addSwitchInformation(this.m_classFileParserContext.getCurrentJavaMethod(), startLineNumber, endLineNumber);
        }
        this.m_labels.clear();
        this.m_labelToCatchedExceptionTypeName.clear();
        this.m_labelToLine.clear();
        this.m_localVariableDefinitions.clear();
        this.m_switchLabels.clear();
        this.m_currentLine = -1;
    }
}

