/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base;

import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyToMemberProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaElementAccessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.SyntheticsHelper;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.DependencyCreator;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependency;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;

public final class DependencyToMethodProcessor
extends DependencyToMemberProcessor {
    private final String m_descriptor;

    public DependencyToMethodProcessor(JavaElement from, int line, JavaDependencyContext context, JavaDependencyType type, JavaModule fromModule, String toFqTypeName, String memberName, String descriptor) {
        super(from, line, context, type, fromModule, toFqTypeName, memberName);
        assert (descriptor != null && descriptor.length() > 0) : "Parameter 'descriptor' of method 'DependencyToMethod' must not be empty";
        this.m_descriptor = descriptor.intern();
    }

    @Override
    public void process(IJavaElementAccessor accessor) {
        assert (accessor != null) : "Parameter 'accessor' of method 'process' must not be null";
        JavaType toType = this.getToType(accessor);
        if (toType != null) {
            JavaMethod toMethod = accessor.getMethod(toType, this.getMemberName(), this.m_descriptor, true, null);
            assert (toMethod != null) : "'toMethod' of method 'process' must not be null";
            if (!this.dependencyAlreadyExists(toMethod) && !SyntheticsHelper.isDependencySynthetic(this.getFrom(), toType, toMethod, this.m_descriptor, this.getType())) {
                JavaDependency dependency = DependencyCreator.create(this.getContext(), this.getType(), this.getFrom(), toMethod, this.getLine());
                this.getFrom().addDependency(dependency);
                this.addTargetElementFlags(toMethod);
            }
        }
    }
}

