/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.architecture.JavaAttributeRetriever;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;

public class JavaIsInterfaceRetriever
extends JavaAttributeRetriever {
    public String getName() {
        return "JavaIsInterface";
    }

    public String getShortName() {
        return "IsInterface";
    }

    public String getDescription(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        return "Matches the pattern against the fully qualified name of any interface type.\n\nIn a physical model only the Java main type (i.e. the type matching the component's name) is considered. This only works on 'internal' types.\n\nPlease note that \u201c*\u201d will match anything except dots ('.').\n\nWildcards: ?=any character, *=any sequence between slashes, **=any sequence";
    }

    @Override
    protected String computeAttributeForJavaType(IWorkerContext workerContext, JavaType type, String[] params) {
        if (!type.isInterface()) {
            return null;
        }
        String filterName = this.getDatum((NamedElement)type);
        if (filterName == null) {
            filterName = type.getName();
            this.setDatum((NamedElement)type, filterName);
        }
        return filterName;
    }
}

