/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryDoesNotExist;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.RootPathNoReadPermission;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.DirectoryScanner;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.RootPathNeitherAnArchiveNorDirectory;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceRootDirectoryPath;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ScanJob
extends NamedElementVisitor
implements JavaFile.IVisitor,
DirectoryScanner.IFileConsumer {
    private static final FileModificationProvider STANDARD_FILE_MODIFICATION_PROVIDER;
    private static FileModificationProvider s_fileModificationProvider;
    private final Map<TFile, JavaClassRootDirectoryPath> m_classRootDirectoryToScanToToRootDirectoryPath = new LinkedHashMap<TFile, JavaClassRootDirectoryPath>();
    private final Map<TFile, JavaSourceRootDirectoryPath> m_sourceRootDirectoryToScanToSourceRootDirectoryPath = new LinkedHashMap<TFile, JavaSourceRootDirectoryPath>();
    private final Map<String, FilePath> m_identifyingFilePathToExistingFilePath = new THashMap();
    private final IWorkerContext m_workerContext;
    private final ModuleDelta m_delta;
    private final List<String> m_ignoreDirectories;
    private final boolean m_platformIsCaseSensitive;
    private JavaClassRootDirectoryPath m_currentRootDirectory;
    private JavaSourceRootDirectoryPath m_currentSourceRootDirectory;
    private Phase m_phase;

    static {
        s_fileModificationProvider = STANDARD_FILE_MODIFICATION_PROVIDER = new FileModificationProvider();
    }

    public static void setFileModificationProvider(FileModificationProvider provider) {
        s_fileModificationProvider = provider != null ? provider : STANDARD_FILE_MODIFICATION_PROVIDER;
    }

    ScanJob(IWorkerContext workerContext, ModuleDelta delta, List<String> ignoreDirectories) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'RefreshJob' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'ScanJob' must not be null";
        assert (ignoreDirectories != null) : "Parameter 'ignoreDirectories' of method 'ScanJob' must not be null";
        this.m_delta = delta;
        this.m_workerContext = workerContext;
        this.m_ignoreDirectories = ignoreDirectories;
        this.m_platformIsCaseSensitive = Platform.isCaseSensitive();
    }

    public boolean continueScanning(TFile rootPathBeingScanned, TFile path) {
        assert (path != null) : "Parameter 'path' of method 'continueScanning' must not be null";
        this.m_workerContext.working("Scan directory", false);
        return !this.m_workerContext.hasBeenCanceled();
    }

    public IFileType accepts(TFile file) {
        JavaFileType fileType;
        assert (file != null) : "'file' must not be null";
        assert (this.m_phase != null) : "'m_phase' of method 'accepts' must not be null";
        if (s_fileModificationProvider.acceptInScan(file) && (fileType = JavaFileType.determine(file.getName())) != null) {
            return this.m_phase.accepts(fileType) ? fileType : null;
        }
        return null;
    }

    private RootDirectoryPath getRootDirectoryPath(JavaFileType fileType) {
        assert (fileType != null) : "Parameter 'fileType' of method 'getRootDirectoryPath' must not be null";
        switch (fileType) {
            case CLASS_FILE: {
                assert (this.m_currentRootDirectory != null) : "'currentRootDirectory' of method 'processAddedFile' must not be null";
                return this.m_currentRootDirectory;
            }
            case JAVA_FILE: 
            case GROOVY_FILE: 
            case KOTLIN_FILE: 
            case ASPECTJ_FILE: 
            case SCALA_FILE: {
                assert (this.m_currentSourceRootDirectory != null) : "'m_currentSourceRootDirectory' of method 'processAddedFile' must not be null";
                return this.m_currentSourceRootDirectory;
            }
        }
        assert (false) : "Unhandled file type: " + String.valueOf((Object)fileType);
        return null;
    }

    public void consume(TFile rootPathBeingScanned, TFile file, IFileType fileType) {
        assert (rootPathBeingScanned != null) : "'rootPathBeingScanned' must not be null";
        assert (file != null) : "'file' must not be null";
        assert (fileType != null) : "'fileType' must not be null";
        if (!this.m_workerContext.hasBeenCanceled()) {
            this.m_workerContext.working("Consume file", false);
            Long timeStamp = null;
            FilePath existingFile = this.m_identifyingFilePathToExistingFilePath.get(this.m_platformIsCaseSensitive ? FileUtility.getIdentifyingPath((TFile)file) : FileUtility.getIdentifyingPath((TFile)file).toLowerCase());
            if (existingFile != null) {
                timeStamp = existingFile.getTimestamp();
                if (timeStamp.longValue() != file.lastModified()) {
                    existingFile.setTimestamp(Long.valueOf(file.lastModified()).longValue());
                    this.m_delta.modified(existingFile);
                }
            } else {
                this.m_delta.added(this.getRootDirectoryPath((JavaFileType)fileType), fileType, file);
            }
        }
    }

    private void checkIssues(TFile rootDirectoryToScan, RootDirectoryPath rootDirectoryPath) {
        assert (rootDirectoryToScan != null) : "Parameter 'rootDirectoryToScan' of method 'checkIssues' must not be null";
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'checkIssues' must not be null";
        rootDirectoryPath.removeIssues();
        if (rootDirectoryToScan.exists()) {
            if (!FileUtility.isArchive((TFile)rootDirectoryToScan) && !rootDirectoryToScan.isDirectory()) {
                rootDirectoryPath.addIssue((Issue)new RootPathNeitherAnArchiveNorDirectory((NamedElement)rootDirectoryPath, "Path: " + rootDirectoryToScan.getAbsolutePath()));
            } else if (!rootDirectoryToScan.canRead()) {
                rootDirectoryPath.addIssue((Issue)new RootPathNoReadPermission((NamedElement)rootDirectoryPath));
            }
        } else {
            rootDirectoryPath.addIssue((Issue)new RootDirectoryDoesNotExist((NamedElement)rootDirectoryPath));
        }
    }

    private void checkIssues() {
        if (!this.m_classRootDirectoryToScanToToRootDirectoryPath.isEmpty() || !this.m_sourceRootDirectoryToScanToSourceRootDirectoryPath.isEmpty()) {
            this.m_workerContext.working("Check issues", false);
            for (Map.Entry<TFile, JavaClassRootDirectoryPath> entry : this.m_classRootDirectoryToScanToToRootDirectoryPath.entrySet()) {
                this.checkIssues(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<TFile, RootDirectoryPath> entry : this.m_sourceRootDirectoryToScanToSourceRootDirectoryPath.entrySet()) {
                this.checkIssues(entry.getKey(), entry.getValue());
            }
        }
    }

    private void detectModifiedOrCreatedFiles() {
        if (!this.m_classRootDirectoryToScanToToRootDirectoryPath.isEmpty() || !this.m_sourceRootDirectoryToScanToSourceRootDirectoryPath.isEmpty()) {
            TFile nextRootDirectoryToScan;
            this.m_workerContext.working("Detect modified or created files", false);
            this.m_workerContext.beginBlockOfWork(this.m_classRootDirectoryToScanToToRootDirectoryPath.size() + this.m_sourceRootDirectoryToScanToSourceRootDirectoryPath.size());
            DirectoryScanner scanner = new DirectoryScanner(this.m_ignoreDirectories, false);
            this.m_phase = Phase.CLASS_FILES;
            for (Map.Entry<TFile, JavaClassRootDirectoryPath> entry : this.m_classRootDirectoryToScanToToRootDirectoryPath.entrySet()) {
                if (this.m_workerContext.hasBeenCanceled()) break;
                nextRootDirectoryToScan = entry.getKey();
                this.m_currentRootDirectory = entry.getValue();
                if (nextRootDirectoryToScan.exists() && (FileUtility.isArchive((TFile)nextRootDirectoryToScan) || nextRootDirectoryToScan.isDirectory())) {
                    scanner.scan(nextRootDirectoryToScan, (DirectoryScanner.IFileConsumer)this);
                }
                this.m_currentRootDirectory = null;
                this.m_workerContext.workItemCompleted();
            }
            this.m_phase = Phase.SOURCE_FILES;
            for (Map.Entry<TFile, RootDirectoryPath> entry : this.m_sourceRootDirectoryToScanToSourceRootDirectoryPath.entrySet()) {
                if (this.m_workerContext.hasBeenCanceled()) break;
                nextRootDirectoryToScan = entry.getKey();
                this.m_currentSourceRootDirectory = (JavaSourceRootDirectoryPath)entry.getValue();
                if (nextRootDirectoryToScan.exists() && (FileUtility.isArchive((TFile)nextRootDirectoryToScan) || nextRootDirectoryToScan.isDirectory())) {
                    scanner.scan(nextRootDirectoryToScan, (DirectoryScanner.IFileConsumer)this);
                }
                this.m_currentSourceRootDirectory = null;
                this.m_workerContext.workItemCompleted();
            }
            this.m_phase = null;
        }
    }

    private boolean filePathStillExists(FilePath filePath) {
        assert (filePath != null) : "Parameter 'filePath' of method 'filePathStillExists' must not be null";
        if (s_fileModificationProvider.deleted(filePath)) {
            this.m_delta.deleted(filePath);
            return false;
        }
        return true;
    }

    public void visitChildrenOf(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
        if (!this.m_workerContext.hasBeenCanceled()) {
            for (NamedElement next : element.getChildrenList()) {
                next.accept((NamedElement.INamedElementVisitor)this);
            }
        }
    }

    @Override
    public void visitJavaFile(JavaFile element) {
        assert (element != null) : "Parameter 'element' of method 'visitJavaFile' must not be null";
        if (!this.m_workerContext.hasBeenCanceled() && this.filePathStillExists(element)) {
            String nexIdentifyingPath = this.m_platformIsCaseSensitive ? FileUtility.getIdentifyingPath((TFile)element.getFile()) : FileUtility.getIdentifyingPath((TFile)element.getFile()).toLowerCase();
            this.m_identifyingFilePathToExistingFilePath.put(nexIdentifyingPath, element);
        }
    }

    private void detectDeletedFiles() {
        if (!this.m_classRootDirectoryToScanToToRootDirectoryPath.isEmpty() || !this.m_sourceRootDirectoryToScanToSourceRootDirectoryPath.isEmpty()) {
            this.m_workerContext.working("Detect deleted files", false);
            for (Map.Entry<TFile, JavaClassRootDirectoryPath> entry : this.m_classRootDirectoryToScanToToRootDirectoryPath.entrySet()) {
                if (this.m_workerContext.hasBeenCanceled()) break;
                JavaClassRootDirectoryPath nextClassRootDirectoryPath = entry.getValue();
                nextClassRootDirectoryPath.accept(this);
            }
            for (Map.Entry<TFile, RootDirectoryPath> entry : this.m_sourceRootDirectoryToScanToSourceRootDirectoryPath.entrySet()) {
                if (this.m_workerContext.hasBeenCanceled()) break;
                JavaSourceRootDirectoryPath nextSourceRootDirectoryPath = (JavaSourceRootDirectoryPath)entry.getValue();
                nextSourceRootDirectoryPath.accept(this);
            }
        }
    }

    private void collectRootDirectories() {
        List rootDirectoryPaths = this.m_delta.getModule().getOriginalChildren(RootDirectoryPath.class);
        if (!rootDirectoryPaths.isEmpty()) {
            this.m_workerContext.working("Collect root directories", false);
            for (RootDirectoryPath nextRootDirectoryPath : rootDirectoryPaths) {
                if (this.m_workerContext.hasBeenCanceled()) break;
                RootDirectoryPath nextOriginalRootDirectoryPath = nextRootDirectoryPath;
                if (!nextOriginalRootDirectoryPath.isEnabled()) continue;
                if (nextOriginalRootDirectoryPath instanceof JavaClassRootDirectoryPath) {
                    this.m_classRootDirectoryToScanToToRootDirectoryPath.put(nextOriginalRootDirectoryPath.getFile(), (JavaClassRootDirectoryPath)nextOriginalRootDirectoryPath);
                    continue;
                }
                assert (nextOriginalRootDirectoryPath instanceof JavaSourceRootDirectoryPath) : "Unexpected class in method 'collectRootDirectories': " + String.valueOf(nextOriginalRootDirectoryPath);
                this.m_sourceRootDirectoryToScanToSourceRootDirectoryPath.put(nextOriginalRootDirectoryPath.getFile(), (JavaSourceRootDirectoryPath)nextOriginalRootDirectoryPath);
            }
        }
    }

    public void start() {
        this.m_workerContext.setNumberOfSteps(4);
        this.collectRootDirectories();
        this.m_workerContext.endStep();
        this.checkIssues();
        this.m_workerContext.endStep();
        this.detectDeletedFiles();
        this.m_workerContext.endStep();
        this.detectModifiedOrCreatedFiles();
        this.m_workerContext.endStep();
        s_fileModificationProvider.scanFinished();
    }

    public static class FileModificationProvider {
        public boolean acceptInScan(TFile file) {
            assert (file != null) : "Parameter 'file' of method 'acceptInScan' must not be null";
            return true;
        }

        public boolean deleted(FilePath filePath) {
            assert (filePath != null) : "Parameter 'filePath' of method 'deleted' must not be null";
            return !filePath.getFile().exists();
        }

        public void scanFinished() {
        }
    }

    static final class Phase
    extends Enum<Phase> {
        public static final /* enum */ Phase CLASS_FILES = new Phase(new JavaFileType[]{JavaFileType.CLASS_FILE});
        public static final /* enum */ Phase SOURCE_FILES = new Phase(new JavaFileType[]{JavaFileType.JAVA_FILE, JavaFileType.GROOVY_FILE, JavaFileType.KOTLIN_FILE, JavaFileType.SCALA_FILE, JavaFileType.ASPECTJ_FILE});
        private final JavaFileType[] m_fileTypes;
        private static final /* synthetic */ Phase[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Phase[]{CLASS_FILES, SOURCE_FILES};
        }

        private Phase(JavaFileType[] fileTypes) {
            assert (fileTypes != null && fileTypes.length > 0) : "Parameter 'fileTypes' of method 'Phase' must not be empty";
            this.m_fileTypes = fileTypes;
        }

        boolean accepts(JavaFileType fileType) {
            assert (fileType != null) : "Parameter 'fileType' of method 'accepts' must not be null";
            JavaFileType[] javaFileTypeArray = this.m_fileTypes;
            int n = this.m_fileTypes.length;
            int n2 = 0;
            while (n2 < n) {
                JavaFileType next = javaFileTypeArray[n2];
                if (next.equals((Object)fileType)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public static Phase[] values() {
            Phase[] phaseArray = ENUM$VALUES;
            int n = phaseArray.length;
            Phase[] phaseArray2 = new Phase[n];
            System.arraycopy(ENUM$VALUES, 0, phaseArray2, 0, n);
            return phaseArray2;
        }

        public static Phase valueOf(String string) {
            return Enum.valueOf(Phase.class, string);
        }
    }
}

