/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system;

import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.JavaTypeInfo;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JavaTypeRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaTypeRegistry.class);
    private final Map<String, List<JavaTypeInfo>> m_fqNameToTypeInfo = new THashMap();
    private final Map<String, List<JavaType>> m_shortNameToTypes = new THashMap();
    private final Map<String, List<JavaField>> m_shortNameToPotentialInlineFields = new THashMap();
    private final Map<JavaModule, Set<JavaFile>> m_filesToReparse = new LinkedHashMap<JavaModule, Set<JavaFile>>();
    private final MultipleValueMap<String, JavaTypeInfo> m_kotlinHelperClasses = new MultipleValueMap();

    JavaTypeRegistry() {
    }

    private void registerShortName(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'registerShortName' must not be null";
        String shortName = type.getShortName();
        List<JavaType> types = this.m_shortNameToTypes.get(shortName);
        if (types == null) {
            types = new ArrayList<JavaType>(4);
            this.m_shortNameToTypes.put(shortName, types);
        }
        types.add(type);
    }

    private void deRegisterShortName(String shortName, JavaType type) {
        assert (shortName != null) : "Parameter 'shortName' of method 'deRegisterShortName' must not be null";
        assert (type != null) : "Parameter 'type' of method 'registerShortName' must not be null";
        List<JavaType> types = this.m_shortNameToTypes.get(shortName);
        if (types != null) {
            boolean success = types.remove(type);
            if (!success) {
                LOGGER.warn("Unable to deregister short name of type '" + type.getFqName() + "'");
            } else if (types.isEmpty()) {
                this.m_shortNameToTypes.remove(shortName);
            }
        } else {
            LOGGER.warn("No types found for '" + type.getFqName() + "'");
        }
    }

    void addFileToReparse(JavaModule module, JavaFile file) {
        assert (module != null) : "Parameter 'module' of method 'addFileToReparse' must not be null";
        assert (file != null) : "Parameter 'file' of method 'addFileToReparse' must not be null";
        Set<JavaFile> files = this.m_filesToReparse.get((Object)module);
        if (files == null) {
            files = new LinkedHashSet<JavaFile>();
            this.m_filesToReparse.put(module, files);
        }
        files.add(file);
    }

    Map<JavaModule, Set<JavaFile>> getFilesToReparse() {
        return Collections.unmodifiableMap(this.m_filesToReparse);
    }

    void clearFilesToReparse() {
        this.m_filesToReparse.clear();
    }

    void updateShortNameOfTypeIfNecessary(String oldShortName, JavaType type) {
        assert (oldShortName != null) : "Parameter 'oldShortName' of method 'updateShortNameOfTypeIfNecessary' must not be null";
        assert (type != null) : "Parameter 'type' of method 'updateShortNameOfTypeIfNecessary' must not be null";
        if (!oldShortName.equals(type.getShortName())) {
            this.deRegisterShortName(oldShortName, type);
            this.registerShortName(type);
        }
    }

    List<JavaTypeInfo> addType(JavaModule module, JavaType type) {
        assert (type != null) : "'type' must not be null";
        String fqName = type.getFqName();
        List<JavaTypeInfo> typeInfo = this.m_fqNameToTypeInfo.get(fqName);
        if (typeInfo == null) {
            typeInfo = new ArrayList<JavaTypeInfo>(1);
            this.m_fqNameToTypeInfo.put(fqName, typeInfo);
        }
        JavaTypeInfo ti = new JavaTypeInfo(module, type);
        typeInfo.add(ti);
        this.registerShortName(type);
        String shortName = type.getShortName();
        if (shortName.endsWith("Kt") && !(type.getParent() instanceof JavaType)) {
            this.m_kotlinHelperClasses.put((Object)shortName.toLowerCase(), (Object)ti);
        }
        return typeInfo;
    }

    void removeType(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'removeType' must not be null";
        String fqName = type.getFqName();
        List<JavaTypeInfo> typeInfos = this.m_fqNameToTypeInfo.get(fqName);
        if (typeInfos != null) {
            JavaTypeInfo found = null;
            for (JavaTypeInfo javaTypeInfo : typeInfos) {
                if (javaTypeInfo.getType() != type) continue;
                found = javaTypeInfo;
                break;
            }
            if (found != null) {
                typeInfos.remove(found);
                if (typeInfos.isEmpty()) {
                    this.m_fqNameToTypeInfo.remove(fqName);
                }
            } else {
                LOGGER.warn("Type to remove not found '" + type.getFqName() + "'");
            }
        } else {
            LOGGER.warn("No type info found for type to remove '" + type.getFqName() + "'");
        }
        for (JavaField nextField : type.getChildren(JavaField.class)) {
            String shortName = nextField.getShortName();
            List<JavaField> javaFields = this.m_shortNameToPotentialInlineFields.get(shortName);
            if (javaFields == null || !javaFields.remove(nextField) || !javaFields.isEmpty()) continue;
            this.m_shortNameToPotentialInlineFields.remove(shortName);
        }
        String shortName = type.getShortName();
        if (shortName != null && !shortName.isEmpty()) {
            JavaTypeInfo javaTypeInfo;
            this.deRegisterShortName(shortName, type);
            if (type.hasFlag(JavaElementFlag.KOTLIN_TYPE) && shortName.endsWith("Kt") && (javaTypeInfo = (JavaTypeInfo)this.m_kotlinHelperClasses.get((Object)shortName.toLowerCase()).stream().filter(ti -> ti.getType() == type).findFirst().orElse(null)) != null) {
                this.m_kotlinHelperClasses.remove((Object)shortName.toLowerCase(), (Object)javaTypeInfo);
            }
        }
    }

    void addKotlinHelperClass(String name) {
        JavaModule module;
        JavaType type;
        List<JavaType> types = this.m_shortNameToTypes.get(name);
        if (types != null && (type = (JavaType)types.stream().filter(t -> !(t.getParent() instanceof JavaType)).findFirst().orElse(null)) != null && (module = (JavaModule)((Object)type.getParent(JavaModule.class, new Class[0]))) != null) {
            this.m_kotlinHelperClasses.put((Object)name.toLowerCase(), (Object)new JavaTypeInfo(module, type));
        }
    }

    JavaType findKotlinHelperClass(JavaModule module, String lowerCaseName, String packageName) {
        assert (module != null) : "Parameter 'module' of method 'findKotlinHelperClass' must not be null";
        assert (lowerCaseName != null && lowerCaseName.length() > 0) : "Parameter 'lowerCaseName' of method 'findKotlinHelperClass' must not be empty";
        JavaTypeInfo typeInfo = packageName != null ? (JavaTypeInfo)this.m_kotlinHelperClasses.get((Object)lowerCaseName).stream().filter(ti -> ti.getModule() == module && ti.getType().getName().equals(packageName + "." + ti.getType().getShortName())).findFirst().orElse(null) : (JavaTypeInfo)this.m_kotlinHelperClasses.get((Object)lowerCaseName).stream().filter(ti -> ti.getModule() == module && ti.getType().getName().equalsIgnoreCase(lowerCaseName)).findFirst().orElse(null);
        return typeInfo != null ? typeInfo.getType() : null;
    }

    JavaType getType(JavaModule module, String fqTypeName) {
        assert (fqTypeName != null && fqTypeName.length() > 0) : "Parameter 'fqTypeName' of method 'getType' must not be empty";
        List<JavaTypeInfo> typeInfos = this.m_fqNameToTypeInfo.get(fqTypeName);
        if (typeInfos != null) {
            for (JavaTypeInfo nextTypeInfo : typeInfos) {
                if (nextTypeInfo.getModule() != module) continue;
                return nextTypeInfo.getType();
            }
        }
        return null;
    }

    List<JavaTypeInfo> getTypes(String fqTypeName) {
        assert (fqTypeName != null && fqTypeName.length() > 0) : "Parameter 'fqTypeName' of method 'getType' must not be empty";
        List<JavaTypeInfo> typeInfos = this.m_fqNameToTypeInfo.get(fqTypeName);
        return typeInfos != null ? Collections.unmodifiableList(typeInfos) : Collections.emptyList();
    }

    Collection<JavaType> getTypesByShortName(String shortName) {
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'getTypesByShortName' must not be empty";
        List<JavaType> types = this.m_shortNameToTypes.get(shortName);
        return types != null ? Collections.unmodifiableList(types) : Collections.emptySet();
    }

    void addPotentialInlineField(JavaField field) {
        assert (field != null) : "Parameter 'field' of method 'addPotentialInlineField' must not be null";
        String shortName = field.getShortName();
        List<JavaField> javaFields = this.m_shortNameToPotentialInlineFields.get(shortName);
        if (javaFields == null) {
            javaFields = new ArrayList<JavaField>(1);
            this.m_shortNameToPotentialInlineFields.put(shortName, javaFields);
        }
        javaFields.add(field);
    }

    List<JavaField> getInlineFields(String fieldName) {
        assert (fieldName != null && fieldName.length() > 0) : "Parameter 'fieldName' of method 'getPotentialInlineFields' must not be empty";
        List<JavaField> candidates = this.m_shortNameToPotentialInlineFields.get(fieldName);
        return candidates != null ? Collections.unmodifiableList(candidates) : Collections.emptyList();
    }

    void modificationFinished() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Java Types (" + this.m_fqNameToTypeInfo.values().stream().mapToInt(n -> n.size()).sum() + ")");
            int i = 1;
            for (List<JavaTypeInfo> nextTypes : this.m_fqNameToTypeInfo.values()) {
                for (JavaTypeInfo nextTypeInfo : nextTypes) {
                    LOGGER.debug("(" + i + ") " + String.valueOf(nextTypeInfo));
                    ++i;
                }
            }
        }
    }
}

