/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.command.system;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.AbstractCreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemController;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportModuleCandidate;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.java.command.system.JavaCommandId;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.IJavaModulesExtension;
import java.util.Set;

public final class CreateSystemBasedOnBuildUnitsCommand
extends AbstractCreateSoftwareSystemCommand {
    private final IInteraction m_interaction;

    public CreateSystemBasedOnBuildUnitsCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'CreateSystemBasedOnBuildUnitsCommand' must not be null";
        this.m_interaction = interaction;
    }

    public ICommandId getId() {
        return JavaCommandId.CREATE_SOFTWARE_SYSTEM_BASED_ON_BUILD_UNITS;
    }

    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        ISoftwareSystemController controller = this.getController();
        CreateSoftwareSystemCommand createSoftwareSystemCommand = new CreateSoftwareSystemCommand((ISoftwareSystemProvider)controller, (AbstractCreateSoftwareSystemCommand.IInteraction)this.m_interaction);
        if (!createSoftwareSystemCommand.isEnabled().isSuccess()) {
            return;
        }
        this.runPrerequisiteCommand((Command)createSoftwareSystemCommand, workerContext);
        if (createSoftwareSystemCommand.canceled() || !controller.hasSoftwareSystem()) {
            return;
        }
        Data data = new Data();
        if (!this.m_interaction.collect(data)) {
            return;
        }
        IJavaModulesExtension extension = (IJavaModulesExtension)controller.getInstallation().getExtension(IJavaModulesExtension.class);
        SoftwareSystem softwareSystem = controller.getSoftwareSystem();
        assert (softwareSystem != null) : "No system available";
        OperationResult createModulesResult = extension.createAdditionalModulesAndRootDirectories(workerContext, data.getCandidates(), "from build unit(s)", softwareSystem, IJavaModulesExtension.Mode.SYSTEM_CREATION);
        this.m_interaction.processModuleCreationResult(createModulesResult);
    }

    public static final class Data
    implements ICommandInteractionData {
        private Set<ImportModuleCandidate> m_moduleCandidates;

        public void setCandidates(Set<ImportModuleCandidate> candidates) {
            assert (candidates != null) : "Parameter 'candidates' of method 'setCandidates' must not be null";
            this.m_moduleCandidates = candidates;
        }

        public Set<ImportModuleCandidate> getCandidates() {
            assert (this.m_moduleCandidates != null) : "'m_moduleCandidates' of method 'getCandidates' must not be null";
            return this.m_moduleCandidates;
        }
    }

    public static interface IInteraction
    extends AbstractCreateSoftwareSystemCommand.IInteraction {
        public boolean collect(Data var1);

        public void processModuleCreationResult(OperationResult var1);
    }
}

