/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.AbstractImportModulesCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportModuleCandidate;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.java.command.system.JavaCommandId;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.IJavaModulesExtension;
import java.util.Set;

public final class CreateAdditionalModulesAndRootDirectoriesModulesCommand
extends AbstractImportModulesCommand<IInteraction> {
    public CreateAdditionalModulesAndRootDirectoriesModulesCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super((ICommandInteraction)interaction, provider);
    }

    public final ICommandId getId() {
        return JavaCommandId.CREATE_ADDITIONAL_MODULES_AND_ROOT_DIRECTORIES;
    }

    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        Data importData = new Data();
        if (!((IInteraction)this.getInteraction()).collect(importData)) {
            return;
        }
        IJavaModulesExtension extension = (IJavaModulesExtension)this.getController().getInstallation().getExtension(IJavaModulesExtension.class);
        OperationResult createModulesResult = extension.createAdditionalModulesAndRootDirectories(workerContext, importData.getCandidates(), importData.getContextInfo(), importData.getSoftwareSystem(), IJavaModulesExtension.Mode.SYSTEM_MODIFICATION);
        ((IInteraction)this.getInteraction()).processModuleCreationResult(createModulesResult);
    }

    public static final class Data
    implements ICommandInteractionData {
        private SoftwareSystem m_softwareSystem;
        private Set<ImportModuleCandidate> m_moduleCandidates;
        private String m_contextInfo;

        public void setData(SoftwareSystem softwareSystem, Set<ImportModuleCandidate> candidates, String contextInfo) {
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'setData' must not be null";
            assert (candidates != null && !candidates.isEmpty()) : "Parameter 'candidates' of method 'setData' must not be empty";
            assert (contextInfo != null && contextInfo.length() > 0) : "Parameter 'contextInfo' of method 'setData' must not be empty";
            this.m_softwareSystem = softwareSystem;
            this.m_moduleCandidates = candidates;
            this.m_contextInfo = contextInfo;
        }

        SoftwareSystem getSoftwareSystem() {
            assert (this.m_softwareSystem != null) : "'m_softwareSystem' of method 'getSoftwareSystem' must not be null";
            return this.m_softwareSystem;
        }

        Set<ImportModuleCandidate> getCandidates() {
            assert (this.m_moduleCandidates != null) : "'m_moduleCandidates' of method 'getCandidates' must not be null";
            return this.m_moduleCandidates;
        }

        String getContextInfo() {
            assert (this.m_contextInfo != null) : "'m_contextInfo' of method 'getContextInfo' must not be null";
            return this.m_contextInfo;
        }
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collect(Data var1);

        public void processModuleCreationResult(OperationResult var1);
    }
}

