/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.architecture.model;

import com.hello2morrow.sonargraph.integration.architecture.model.Filter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ArchitectureElement {
    private final String name;
    private final List<Filter> inclusionFilters = new ArrayList<Filter>();
    private final List<Filter> exclusionFilters = new ArrayList<Filter>();

    protected ArchitectureElement(String fqn) {
        assert (fqn != null && fqn.length() > 0);
        this.name = fqn;
    }

    public String getName() {
        int dotPos = this.name.lastIndexOf(46);
        if (dotPos == -1) {
            return this.name;
        }
        return this.name.substring(dotPos + 1);
    }

    public String getFullName() {
        return this.name;
    }

    public void addIncludeFilter(String pattern, boolean isStromg) {
        this.inclusionFilters.add(new Filter(pattern, isStromg));
    }

    public void addExcludeFilter(String pattern) {
        this.exclusionFilters.add(new Filter(pattern, false));
    }

    public List<Filter> getIncludeFilters() {
        return Collections.unmodifiableList(this.inclusionFilters);
    }

    public List<Filter> getExcludeFilters() {
        return Collections.unmodifiableList(this.exclusionFilters);
    }
}

