/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IElement;
import com.hello2morrow.sonargraph.integration.access.model.ILogicalNamespace;
import com.hello2morrow.sonargraph.integration.access.model.ILogicalProgrammingElement;
import com.hello2morrow.sonargraph.integration.access.model.IMetricId;
import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import com.hello2morrow.sonargraph.integration.access.model.IMetricValue;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.INamedElementContainer;
import com.hello2morrow.sonargraph.integration.access.model.internal.LogicalNamespaceImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.LogicalProgrammingElementImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.MetaDataAccessImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.NamedElementComparator;
import com.hello2morrow.sonargraph.integration.access.model.internal.NamedElementImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.NamedElementRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;

public abstract class NamedElementContainerImpl
extends NamedElementImpl
implements INamedElementContainer {
    private static final long serialVersionUID = 995206422502257231L;
    private final Map<IMetricLevel, HashMap<IMetricId, HashMap<INamedElement, IMetricValue>>> metricValues = new HashMap<IMetricLevel, HashMap<IMetricId, HashMap<INamedElement, IMetricValue>>>();
    private final Map<String, Set<INamedElement>> kindToNamedElements = new HashMap<String, Set<INamedElement>>();
    private final Set<LogicalNamespaceImpl> logicalNamespaces = new TreeSet<INamedElement>(new NamedElementComparator());
    private final Set<LogicalProgrammingElementImpl> logicalProgrammingElements = new TreeSet<INamedElement>(new NamedElementComparator());
    private final MetaDataAccessImpl metaDataAccessImpl;
    private final NamedElementRegistry elementRegistryImpl;

    public NamedElementContainerImpl(String kind, String presentationKind, String name, String presentationName, String fqName, String description, MetaDataAccessImpl metaDataAccessImpl, NamedElementRegistry elementRegistryImpl, String imageResourceName) {
        super(kind, presentationKind, name, presentationName, fqName, description, imageResourceName);
        assert (metaDataAccessImpl != null) : "Parameter 'metaDataAccessImpl' of method 'NamedElementContainerImpl' must not be null";
        assert (elementRegistryImpl != null) : "Parameter 'elementRegistryImpl' of method 'NamedElementContainerImpl' must not be null";
        this.metaDataAccessImpl = metaDataAccessImpl;
        this.elementRegistryImpl = elementRegistryImpl;
    }

    public final MetaDataAccessImpl getMetaDataAccess() {
        return this.metaDataAccessImpl;
    }

    public final NamedElementRegistry getElementRegistry() {
        return this.elementRegistryImpl;
    }

    public final void addElement(INamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'addElement' must not be null";
        Set<INamedElement> namedElements = this.kindToNamedElements.get(element.getKind());
        if (namedElements == null) {
            namedElements = new LinkedHashSet<INamedElement>();
            this.kindToNamedElements.put(element.getKind(), namedElements);
        }
        namedElements.add(element);
        if (!element.isLocationOnly()) {
            this.getElementRegistry().addElement(element);
        }
    }

    public boolean hasElement(INamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'hasElement' must not be null";
        Set<INamedElement> namedElements = this.kindToNamedElements.get(element.getKind());
        return namedElements != null ? namedElements.contains(element) : false;
    }

    @Override
    public final Set<INamedElement> getElements(String elementKind) {
        assert (elementKind != null && elementKind.length() > 0) : "Parameter 'elementKind' of method 'getElements' must not be empty";
        Set<INamedElement> namedElements = this.kindToNamedElements.get(elementKind);
        return namedElements != null ? Collections.unmodifiableSet(namedElements) : Collections.emptySet();
    }

    @Override
    public final Set<INamedElement> getElements(Predicate<INamedElement> predicate) {
        assert (predicate != null);
        HashSet<INamedElement> result = new HashSet<INamedElement>();
        for (Set<INamedElement> elements : this.kindToNamedElements.values()) {
            elements.stream().filter(n -> predicate.test((INamedElement)n)).forEach(n -> {
                boolean bl = result.add((INamedElement)n);
            });
        }
        return result;
    }

    @Override
    public final Set<String> getElementKinds() {
        return Collections.unmodifiableSet(this.kindToNamedElements.keySet());
    }

    public final void addLogicalNamespace(LogicalNamespaceImpl logicalNamespaceImpl) {
        assert (logicalNamespaceImpl != null) : "Parameter 'logicalNamespaceImpl' of method 'addLogicalNamespace' must not be null";
        boolean success = this.logicalNamespaces.add(logicalNamespaceImpl);
        assert (success) : "Logical namespace already added: " + String.valueOf(logicalNamespaceImpl);
    }

    public final void addLogicalProgrammingElement(LogicalProgrammingElementImpl logicalProgrammingElementImpl) {
        assert (logicalProgrammingElementImpl != null) : "Parameter 'logicalProgrammingElementImpl' of method 'addLogicalProgrammingElement' must not be null";
        boolean success = this.logicalProgrammingElements.add(logicalProgrammingElementImpl);
        assert (success) : "Logical programming element already added: " + String.valueOf(logicalProgrammingElementImpl);
    }

    @Override
    public final Set<ILogicalNamespace> getLogicalNamespaces() {
        return Collections.unmodifiableSet(this.logicalNamespaces);
    }

    @Override
    public final Set<ILogicalProgrammingElement> getLogicalProgrammingElements() {
        return Collections.unmodifiableSet(this.logicalProgrammingElements);
    }

    public final void addMetricValueForElement(IMetricValue value, INamedElement element) {
        HashMap valuesForMetric;
        HashMap<Object, Object> valuesOfLevel;
        assert (value != null) : "Parameter 'value' of method 'addMetricValue' must not be null";
        IMetricId metricId = value.getId();
        assert (this.metaDataAccessImpl.getMetricIds().containsKey(metricId.getName())) : "MetricId '" + metricId.getName() + "'has not been added";
        assert (element != null) : "Parameter 'element' of method 'addMetricValueForElement' must not be null";
        IMetricLevel level = value.getLevel();
        assert (this.metaDataAccessImpl.getMetricLevels().containsKey(level.getName())) : "Level '" + level.getName() + "' has not been added";
        if (!this.metricValues.containsKey(level)) {
            valuesOfLevel = new HashMap();
            this.metricValues.put(level, valuesOfLevel);
        } else {
            valuesOfLevel = this.metricValues.get(level);
        }
        if (!valuesOfLevel.containsKey(metricId)) {
            valuesForMetric = new HashMap();
            valuesOfLevel.put(metricId, valuesForMetric);
        } else {
            valuesForMetric = (HashMap)valuesOfLevel.get(metricId);
        }
        valuesForMetric.put(element, value);
    }

    public final Optional<IMetricValue> getMetricValueForElement(IMetricId metricId, IMetricLevel metricLevel, String elementName) {
        assert (metricId != null) : "Parameter 'metricId' of method 'getMetricValueForElement' must not be null";
        assert (elementName != null && elementName.length() > 0) : "Parameter 'elementName' of method 'getMetricValueForElement' must not be empty";
        if (!this.metricValues.containsKey(metricLevel)) {
            return Optional.empty();
        }
        HashMap<IMetricId, HashMap<INamedElement, IMetricValue>> metricIdsOfLevel = this.metricValues.get(metricLevel);
        if (!metricIdsOfLevel.containsKey(metricId)) {
            return Optional.empty();
        }
        Optional<INamedElement> element = this.getElementRegistry().getElement(elementName);
        if (!element.isPresent()) {
            return Optional.empty();
        }
        IElement namedElement = element.get();
        Map valuesForMetricId = metricIdsOfLevel.get(metricId);
        if (!valuesForMetricId.containsKey(namedElement)) {
            return Optional.empty();
        }
        return Optional.of((IMetricValue)valuesForMetricId.get(namedElement));
    }

    public final void addMetricLevel(IMetricLevel level) {
        assert (level != null) : "Parameter 'level' of method 'addMetricLevel' must not be null";
        this.metaDataAccessImpl.addMetricLevel(level);
    }

    public final Map<String, IMetricLevel> getAllMetricLevels() {
        return this.metaDataAccessImpl.getMetricLevels();
    }

    public List<IMetricId> getMetricIdsForLevel(IMetricLevel metricLevel) {
        assert (metricLevel != null) : "Parameter 'metricLevel' of method 'getMetricIdsForLevel' must not be null";
        if (!this.metricValues.containsKey(metricLevel)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<IMetricId>(this.metricValues.get(metricLevel).keySet()));
    }

    public Map<INamedElement, IMetricValue> getMetricValues(String metricLevel, String metricId) {
        assert (metricLevel != null && metricLevel.length() > 0) : "Parameter 'metricLevel' of method 'getMetricValues' must not be empty";
        assert (metricId != null && metricId.length() > 0) : "Parameter 'metricId' of method 'getMetricValues' must not be empty";
        Map<String, IMetricLevel> metricLevels = this.getAllMetricLevels();
        if (!metricLevels.containsKey(metricLevel)) {
            return Collections.emptyMap();
        }
        IMetricLevel level = metricLevels.get(metricLevel);
        HashMap<IMetricId, HashMap<INamedElement, IMetricValue>> metricIdValueMap = this.metricValues.get(level);
        Optional<IMetricId> optionalId = metricIdValueMap.keySet().stream().filter(id -> id.getName().equals(metricId)).findAny();
        if (!optionalId.isPresent()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap((Map)metricIdValueMap.get(optionalId.get()));
    }

    public Map<INamedElement, IMetricValue> getMetricValues(IMetricLevel metricLevel, IMetricId metricId) {
        assert (metricLevel != null) : "Parameter 'metricLevel' of method 'getMetricValues' must not be null";
        assert (metricId != null) : "Parameter 'metricId' of method 'getMetricValues' must not be null";
        if (!this.metricValues.containsKey(metricLevel)) {
            return Collections.emptyMap();
        }
        HashMap<IMetricId, HashMap<INamedElement, IMetricValue>> metricIdValueMap = this.metricValues.get(metricLevel);
        if (!metricIdValueMap.containsKey(metricId)) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap((Map)metricIdValueMap.get(metricId));
    }
}

