/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model;

import com.hello2morrow.sonargraph.integration.access.foundation.IEnumeration;
import com.hello2morrow.sonargraph.integration.access.foundation.Utility;

public final class RefactoringStatus
extends Enum<RefactoringStatus>
implements IEnumeration {
    public static final /* enum */ RefactoringStatus NOT_APPLICABLE = new RefactoringStatus(false);
    public static final /* enum */ RefactoringStatus APPLICABLE = new RefactoringStatus(true);
    public static final /* enum */ RefactoringStatus PARTIALLY_APPLICABLE = new RefactoringStatus(true);
    public static final /* enum */ RefactoringStatus POTENTIALLY_DONE = new RefactoringStatus(false);
    public static final /* enum */ RefactoringStatus NO_ELEMENT_MATCHED = new RefactoringStatus(false);
    public static final /* enum */ RefactoringStatus LANGUAGE_NOT_AVAILABLE = new RefactoringStatus(false);
    public static final /* enum */ RefactoringStatus TARGET_ROOT_DIRECTORY_NOT_FOUND = new RefactoringStatus(false);
    public static final /* enum */ RefactoringStatus NONE = new RefactoringStatus(false);
    private final String m_standardName = Utility.convertConstantNameToStandardName(this.name());
    private final String m_presentationName = Utility.convertConstantNameToPresentationName(this.name());
    private final boolean m_isApplicable;
    private static final /* synthetic */ RefactoringStatus[] ENUM$VALUES;

    static {
        ENUM$VALUES = new RefactoringStatus[]{NOT_APPLICABLE, APPLICABLE, PARTIALLY_APPLICABLE, POTENTIALLY_DONE, NO_ELEMENT_MATCHED, LANGUAGE_NOT_AVAILABLE, TARGET_ROOT_DIRECTORY_NOT_FOUND, NONE};
    }

    private RefactoringStatus(boolean isApplicable) {
        this.m_isApplicable = isApplicable;
    }

    @Override
    public String getStandardName() {
        return this.m_standardName;
    }

    @Override
    public String getPresentationName() {
        return this.m_presentationName;
    }

    public boolean isApplicable() {
        return this.m_isApplicable;
    }

    public static RefactoringStatus createFromStandardName(String name) {
        String nameLowerCase;
        assert (name != null && name.trim().length() > 0) : "Parameter 'name' of method 'createFromStandardName' must not be empty";
        switch (nameLowerCase = name.toLowerCase().trim()) {
            case "applicable": {
                return APPLICABLE;
            }
            case "notapplicable": {
                return NOT_APPLICABLE;
            }
            case "partiallyapplicable": {
                return PARTIALLY_APPLICABLE;
            }
            case "potentiallydone": {
                return POTENTIALLY_DONE;
            }
            case "noelementmatched": {
                return NO_ELEMENT_MATCHED;
            }
            case "languagenotavailable": {
                return LANGUAGE_NOT_AVAILABLE;
            }
            case "targetrootdirectorynotfound": {
                return TARGET_ROOT_DIRECTORY_NOT_FOUND;
            }
            case "none": {
                return NONE;
            }
        }
        assert (false) : "Unspported refactoring status '" + name + "'";
        return null;
    }

    public static RefactoringStatus[] values() {
        RefactoringStatus[] refactoringStatusArray = ENUM$VALUES;
        int n = refactoringStatusArray.length;
        RefactoringStatus[] refactoringStatusArray2 = new RefactoringStatus[n];
        System.arraycopy(ENUM$VALUES, 0, refactoringStatusArray2, 0, n);
        return refactoringStatusArray2;
    }

    public static RefactoringStatus valueOf(String string) {
        return Enum.valueOf(RefactoringStatus.class, string);
    }
}

