/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.architecture.model;

import com.hello2morrow.sonargraph.integration.architecture.model.Artifact;
import com.hello2morrow.sonargraph.integration.architecture.model.Connector;
import com.hello2morrow.sonargraph.integration.architecture.model.Interface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ArchitecturalModel {
    private final String fileName;
    private final String model;
    private final List<Artifact> m_artifacts = new ArrayList<Artifact>();
    private long timestamp;
    private String systemId;
    private String systemPath;
    private String version;

    @Deprecated
    public ArchitecturalModel(String fileName, String model) {
        this.fileName = fileName;
        this.model = model;
    }

    public ArchitecturalModel(String fileName, String model, String systemPath, String systemId, long timestamp, String version) {
        assert (fileName != null && fileName.length() > 0) : "Parameter 'fileName' of method 'ArchitectureModel' must not be empty";
        assert (model != null && model.length() > 0) : "Parameter 'model' of method 'ArchitectureModel' must not be empty";
        assert (systemPath != null && systemPath.length() > 0) : "Parameter 'systemPath' of method 'ArchitectureModel' must not be empty";
        assert (systemId != null && systemId.length() > 0) : "Parameter 'systemId' of method 'ArchitectureModel' must not be empty";
        assert (timestamp > 0L) : "Parameter 'timestamp' must be positive but is " + timestamp;
        assert (version != null && version.length() > 0) : "Parameter 'version' of method 'ArchitecturalModel' must not be empty";
        this.fileName = fileName;
        this.model = model;
        this.systemPath = systemPath;
        this.systemId = systemId;
        this.timestamp = timestamp;
        this.version = version;
    }

    public String getSystemPath() {
        return this.systemPath;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getModel() {
        return this.model;
    }

    public void addArtifact(Artifact artifact) {
        assert (artifact != null);
        this.m_artifacts.add(artifact);
    }

    public List<Artifact> getArtifacts() {
        return Collections.unmodifiableList(this.m_artifacts);
    }

    public List<Artifact> getAllArtifacts() {
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : this.m_artifacts) {
            this.addArtifactAndChildrenToList(result, artifact);
        }
        return result;
    }

    private void addArtifactAndChildrenToList(List<Artifact> list, Artifact artifact) {
        list.add(artifact);
        for (Artifact child : artifact.getChildren()) {
            this.addArtifactAndChildrenToList(list, child);
        }
    }

    public Artifact findArtifact(String fullName) {
        assert (fullName != null && fullName.length() > 0);
        return this.getAllArtifacts().stream().filter(a -> a.getFullName().equals(fullName)).findFirst().orElse(null);
    }

    public Interface findInterface(String fullName) {
        assert (fullName != null && fullName.length() > 0);
        int dotPos = fullName.lastIndexOf(46);
        if (dotPos <= 0) {
            return null;
        }
        String artifactName = fullName.substring(0, dotPos);
        String interfaceName = fullName.substring(dotPos + 1);
        Artifact artifact = this.findArtifact(artifactName);
        if (artifact != null) {
            return artifact.getInterfaces().stream().filter(i -> i.getName().equals(interfaceName)).findFirst().orElse(null);
        }
        return null;
    }

    public Connector findConnector(String fullName) {
        assert (fullName != null && fullName.length() > 0);
        int dotPos = fullName.lastIndexOf(46);
        if (dotPos <= 0) {
            return null;
        }
        String artifactName = fullName.substring(0, dotPos);
        String connectorName = fullName.substring(dotPos + 1);
        Artifact artifact = this.findArtifact(artifactName);
        if (artifact != null) {
            return artifact.getConnectors().stream().filter(c -> c.getName().equals(connectorName)).findFirst().orElse(null);
        }
        return null;
    }
}

