/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.view.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.reorg.DestinationContentProvider;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

abstract class ReorgUserInputPage
extends UserInputWizardPage {
    private static final long LABEL_FLAGS = 2129995L;
    private TreeViewer m_viewer;

    public ReorgUserInputPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        result.setLayout((Layout)new GridLayout());
        Object initialSelection = this.getInitiallySelectedElement();
        this.verifyDestination(initialSelection, true);
        this.addLabel(result);
        this.m_viewer = this.createViewer(result);
        this.m_viewer.setSelection((ISelection)new StructuredSelection(initialSelection), true);
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ReorgUserInputPage.this.viewerSelectionChanged(event);
            }
        });
        this.m_viewer.addDoubleClickListener((IDoubleClickListener)new TreeViewerDoubleClickListener());
        Dialog.applyDialogFont((Control)result);
    }

    protected Control addLabel(Composite parent) {
        Label label = new Label(parent, 64);
        int resources = this.getResources().length;
        int javaElements = this.getJavaElements().length;
        String text = resources == 0 && javaElements == 1 ? Messages.format((String)ReorgMessages.ReorgUserInputPage_choose_destination_single, (Object)JavaElementLabels.getElementLabel((IJavaElement)this.getJavaElements()[0], (long)2129995L)) : (resources == 1 && javaElements == 0 ? Messages.format((String)ReorgMessages.ReorgUserInputPage_choose_destination_single, (Object)BasicElementLabels.getResourceName((IResource)this.getResources()[0])) : Messages.format((String)ReorgMessages.ReorgUserInputPage_choose_destination_multi, (Object)String.valueOf(resources + javaElements)));
        label.setText(text);
        GridData data = new GridData(4, 0x1000008, true, false);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        label.setLayoutData((Object)data);
        return label;
    }

    private void viewerSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        this.verifyDestination(ss.getFirstElement(), false);
    }

    protected abstract Object getInitiallySelectedElement();

    protected abstract RefactoringStatus verifyDestination(Object var1) throws JavaModelException;

    protected abstract IResource[] getResources();

    protected abstract IJavaElement[] getJavaElements();

    protected abstract IReorgDestinationValidator getDestinationValidator();

    private final void verifyDestination(Object selected, boolean initialVerification) {
        try {
            RefactoringStatus status = this.verifyDestination(selected);
            this.setPageComplete(status);
        }
        catch (JavaModelException e) {
            JavaPlugin.log((Throwable)e);
            this.setPageComplete(false);
        }
    }

    private TreeViewer createViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 2820);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        treeViewer.getTree().setLayoutData((Object)gd);
        treeViewer.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider(256));
        treeViewer.setContentProvider((IContentProvider)new DestinationContentProvider(this.getDestinationValidator()));
        treeViewer.setComparator((ViewerComparator)new JavaElementComparator());
        treeViewer.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        return treeViewer;
    }

    protected TreeViewer getTreeViewer() {
        return this.m_viewer;
    }

    private final class TreeViewerDoubleClickListener
    implements IDoubleClickListener {
        private TreeViewerDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object element = selection.getFirstElement();
            if (ReorgUserInputPage.this.m_viewer.isExpandable(element)) {
                if (ReorgUserInputPage.this.m_viewer.getExpandedState(element)) {
                    ReorgUserInputPage.this.m_viewer.collapseToLevel(element, 1);
                } else {
                    ITreeContentProvider contentProvider = (ITreeContentProvider)ReorgUserInputPage.this.m_viewer.getContentProvider();
                    Object[] children = contentProvider.getChildren(element);
                    if (children.length > 0) {
                        ReorgUserInputPage.this.m_viewer.expandToLevel(element, 1);
                    }
                }
            }
        }
    }
}

