/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.view.refactoring;

import com.hello2morrow.sonargraph.ide.eclipse.e3.E3DialogSettings;
import com.hello2morrow.sonargraph.ide.eclipse.view.refactoring.ReorgUserInputPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgDestinationFactory;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.refactoring.QualifiedNameComponent;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.wizards.NewPackageWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class MoveInputPage
extends ReorgUserInputPage {
    private static final String PAGE_NAME = "MoveInputPage";
    private static final String UPDATE_QUALIFIED_NAMES = "moveWizard.updateQualifiedNames";
    private static final long LABEL_FLAGS = 2129995L;
    private Button m_referenceCheckbox;
    private Button m_qualifiedNameCheckbox;
    private QualifiedNameComponent m_qualifiedNameComponent;
    private ICreateTargetQuery m_createTargetQuery;
    private final JavaMoveProcessor m_moveProcessor;
    private final IJavaElement m_destinationElement;

    public MoveInputPage(JavaMoveProcessor moveProcessor, IJavaElement destinationElement) {
        super(PAGE_NAME);
        this.m_moveProcessor = moveProcessor;
        this.m_destinationElement = destinationElement;
    }

    private JavaMoveProcessor getJavaMoveProcessor() {
        return this.m_moveProcessor;
    }

    @Override
    protected Object getInitiallySelectedElement() {
        return this.m_destinationElement.exists() ? this.m_destinationElement : JavaModelUtil.getPackageFragmentRoot((IJavaElement)this.m_destinationElement);
    }

    @Override
    protected IJavaElement[] getJavaElements() {
        return this.getJavaMoveProcessor().getJavaElements();
    }

    @Override
    protected IResource[] getResources() {
        return this.getJavaMoveProcessor().getResources();
    }

    @Override
    protected IReorgDestinationValidator getDestinationValidator() {
        return this.getJavaMoveProcessor();
    }

    protected boolean performFinish() {
        return super.performFinish() || this.getJavaMoveProcessor().wasCanceled();
    }

    @Override
    protected RefactoringStatus verifyDestination(Object selected) throws JavaModelException {
        JavaMoveProcessor processor = this.getJavaMoveProcessor();
        RefactoringStatus refactoringStatus = processor.setDestination(ReorgDestinationFactory.createDestination((Object)selected));
        this.updateUIStatus();
        return refactoringStatus;
    }

    private void updateUIStatus() {
        this.getRefactoringWizard().setForcePreviewReview(false);
        JavaMoveProcessor processor = this.getJavaMoveProcessor();
        if (this.m_referenceCheckbox != null) {
            processor.setUpdateReferences(this.m_referenceCheckbox.getSelection());
        }
        if (this.m_qualifiedNameCheckbox != null) {
            boolean enabled = processor.canEnableQualifiedNameUpdating();
            this.m_qualifiedNameCheckbox.setEnabled(enabled);
            if (enabled) {
                this.m_qualifiedNameComponent.setEnabled(processor.getUpdateQualifiedNames());
                if (processor.getUpdateQualifiedNames()) {
                    this.getRefactoringWizard().setForcePreviewReview(true);
                }
            } else {
                this.m_qualifiedNameComponent.setEnabled(false);
            }
            processor.setUpdateQualifiedNames(this.m_qualifiedNameCheckbox.getEnabled() && this.m_qualifiedNameCheckbox.getSelection());
        }
    }

    private void addUpdateReferenceComponent(Composite result) {
        final JavaMoveProcessor processor = this.getJavaMoveProcessor();
        if (!processor.canUpdateJavaReferences()) {
            return;
        }
        int resources = this.getResources().length;
        int javaElements = this.getJavaElements().length;
        String text = resources == 0 && javaElements == 1 ? Messages.format((String)ReorgMessages.JdtMoveAction_update_references_singular, (Object)JavaElementLabels.getElementLabel((IJavaElement)this.getJavaElements()[0], (long)2129995L)) : (resources == 1 && javaElements == 0 ? Messages.format((String)ReorgMessages.JdtMoveAction_update_references_singular, (Object)BasicElementLabels.getResourceName((IResource)this.getResources()[0])) : Messages.format((String)ReorgMessages.JdtMoveAction_update_references_plural, (Object)String.valueOf(resources + javaElements)));
        this.m_referenceCheckbox = new Button(result, 32);
        this.m_referenceCheckbox.setText(text);
        this.m_referenceCheckbox.setSelection(processor.getUpdateReferences());
        this.m_referenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                processor.setUpdateReferences(((Button)e.widget).getSelection());
                MoveInputPage.this.updateUIStatus();
            }
        });
    }

    private void addUpdateQualifiedNameComponent(Composite parent, int marginWidth) {
        final JavaMoveProcessor processor = this.getJavaMoveProcessor();
        if (!processor.canEnableQualifiedNameUpdating() || !processor.canUpdateQualifiedNames()) {
            return;
        }
        this.m_qualifiedNameCheckbox = new Button(parent, 32);
        int indent = marginWidth + this.m_qualifiedNameCheckbox.computeSize((int)-1, (int)-1).x;
        this.m_qualifiedNameCheckbox.setText(RefactoringMessages.RenameInputWizardPage_update_qualified_names);
        this.m_qualifiedNameCheckbox.setLayoutData((Object)new GridData(768));
        this.m_qualifiedNameCheckbox.setSelection(processor.getUpdateQualifiedNames());
        this.m_qualifiedNameComponent = new QualifiedNameComponent(parent, 0, (IQualifiedNameUpdating)processor, this.getRefactoringSettings());
        this.m_qualifiedNameComponent.setLayoutData((Object)new GridData(768));
        GridData gd = (GridData)this.m_qualifiedNameComponent.getLayoutData();
        gd.horizontalAlignment = 4;
        gd.horizontalIndent = indent;
        this.updateQualifiedNameUpdating(processor, processor.getUpdateQualifiedNames());
        this.m_qualifiedNameCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ((Button)e.widget).getSelection();
                MoveInputPage.this.updateQualifiedNameUpdating(processor, enabled);
            }
        });
        this.m_qualifiedNameCheckbox.setSelection(this.getRefactoringSettings().getBoolean(UPDATE_QUALIFIED_NAMES));
        this.updateQualifiedNameUpdating(processor, this.m_qualifiedNameCheckbox.getSelection());
    }

    private void updateQualifiedNameUpdating(JavaMoveProcessor processor, boolean enabled) {
        this.m_qualifiedNameComponent.setEnabled(enabled);
        processor.setUpdateQualifiedNames(enabled);
        this.updateUIStatus();
    }

    @Override
    public void createControl(Composite parent) {
        this.m_createTargetQuery = this.getJavaMoveProcessor().getCreateTargetQuery();
        super.createControl(parent);
        this.getTreeViewer().getTree().setFocus();
        Composite result = (Composite)super.getControl();
        this.addUpdateReferenceComponent(result);
        this.addUpdateQualifiedNameComponent(result, ((GridLayout)result.getLayout()).marginWidth);
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
    }

    @Override
    protected Control addLabel(Composite parent) {
        if (this.m_createTargetQuery != null) {
            if (!this.m_destinationElement.exists()) {
                Label info = new Label(parent, 0);
                info.setText("Specified target element does not yet exist. You can either create it or select another already existing one.");
                info.setLayoutData((Object)new GridData(4, 1, true, false));
            }
            Composite firstLine = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            firstLine.setLayout((Layout)layout);
            firstLine.setLayoutData((Object)new GridData(768));
            Control label = super.addLabel(firstLine);
            label.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 128 && e.doit) {
                        e.detail = 0;
                        MoveInputPage.this.getTreeViewer().getTree().setFocus();
                    }
                }
            });
            Button newButton = new Button(firstLine, 8);
            newButton.setText(this.m_createTargetQuery.getNewButtonLabel());
            GridData gd = new GridData(642);
            gd.widthHint = SWTUtil.getButtonWidthHint((Button)newButton);
            newButton.setLayoutData((Object)gd);
            newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MoveInputPage.this.createNewPackage();
                }
            });
            return firstLine;
        }
        return super.addLabel(parent);
    }

    private void createNewPackage() {
        IPackageFragment newElement;
        IPackageFragmentRoot initRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)this.m_destinationElement);
        NewPackageWizardPage packagePage = new NewPackageWizardPage();
        packagePage.setPackageFragmentRoot(initRoot, true);
        packagePage.setPackageText(this.m_destinationElement.getElementName(), true);
        InnerNewPackageCreationWizard wizard = new InnerNewPackageCreationWizard(packagePage);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0 && (newElement = packagePage.getNewPackageFragment()) != null) {
            TreeViewer viewer = this.getTreeViewer();
            ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
            viewer.refresh(contentProvider.getParent((Object)newElement));
            viewer.setSelection((ISelection)new StructuredSelection((Object)newElement), true);
            viewer.getTree().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        IDialogSettings settings = this.getRefactoringSettings();
        if (settings == null) {
            return;
        }
        if (this.m_qualifiedNameCheckbox != null) {
            settings.put(UPDATE_QUALIFIED_NAMES, this.m_qualifiedNameCheckbox.getSelection());
        }
        if (this.m_qualifiedNameComponent != null) {
            this.m_qualifiedNameComponent.savePatterns(settings);
        }
    }

    private class InnerNewPackageCreationWizard
    extends NewElementWizard {
        private final NewPackageWizardPage fPage;

        public InnerNewPackageCreationWizard(NewPackageWizardPage page) {
            this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWPACK);
            this.setDialogSettings(E3DialogSettings.getJavaPluginDialogSettings());
            this.setWindowTitle(NewWizardMessages.NewPackageCreationWizard_title);
            this.fPage = page;
        }

        public void addPages() {
            super.addPages();
            this.addPage((IWizardPage)this.fPage);
        }

        protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
            this.fPage.createPackage(monitor);
        }

        public IJavaElement getCreatedElement() {
            return this.fPage.getNewPackageFragment();
        }
    }
}

