/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.view;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.PortValidator;
import com.hello2morrow.sonargraph.core.model.remoting.RemoteConfiguration;
import com.hello2morrow.sonargraph.ide.eclipse.model.PreferredViewForRevealingRemoteSelection;
import com.hello2morrow.sonargraph.ide.eclipse.view.SonargraphEclipseDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class RemoteSelectionConfigurationDialog
extends StandardDialog {
    private final RemoteConfiguration m_originalConfiguration;
    private final RemoteConfiguration m_defaultConfiguration;
    private int m_modifiedPortIncoming;
    private int m_modifiedPortOutgoing;
    private final PreferredViewForRevealingRemoteSelection m_originalPreferredView;
    private PreferredViewForRevealingRemoteSelection m_modifiedPreferredView;
    private Button m_packageExplorer;
    private Button m_projectExplorer;

    public RemoteSelectionConfigurationDialog(Shell shell, RemoteConfiguration original, PreferredViewForRevealingRemoteSelection preferredView, RemoteConfiguration defaultConfiguration) {
        super(shell, "Configuration of Remote Selection Ports");
        assert (original != null) : "Parameter 'original' of method 'RemoteSelectionConfigurationDialog' must not be null";
        assert (preferredView != null) : "Parameter 'preferredView' of method 'RemoteSelectionConfigurationDialog' must not be null";
        assert (defaultConfiguration != null) : "Parameter 'defaultConfiguration' of method 'RemoteSelectionConfigurationDialog' must not be null";
        this.m_originalConfiguration = original;
        this.m_defaultConfiguration = defaultConfiguration;
        this.m_originalPreferredView = preferredView;
        this.m_modifiedPortIncoming = original.getServerPort();
        this.m_modifiedPortOutgoing = original.getRemotePort();
        this.m_modifiedPreferredView = preferredView;
    }

    protected IDialogId getDialogId() {
        return SonargraphEclipseDialogId.REMOTE_SELECTION_DIALOG;
    }

    protected void fillDialogArea(Composite parent) {
        Label info = new Label(parent, 64);
        info.setText("Specify the port for incoming selection events the Eclipse plugin receives from Sonargraph and the port for outgoing selection events that Eclipse plugin sends to Sonargraph.");
        info.setLayoutData((Object)new GridData(4, 4, true, false, this.getNumberOfColumns(), 1));
        SwtUtility.placeHorizontalSeparator((Composite)parent, (int)this.getNumberOfColumns());
        Label incomingPortLabel = new Label(parent, 0);
        incomingPortLabel.setText("Eclipse Plugin Port (Incoming Requests): ");
        incomingPortLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        final ValidatingTextWidget incomingText = new ValidatingTextWidget(parent, (ITextValidator)new PortValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                RemoteSelectionConfigurationDialog.this.m_modifiedPortIncoming = input != null ? Integer.parseInt(input.trim()) : -1;
                RemoteSelectionConfigurationDialog.this.inputModified();
            }
        }, Integer.toString(this.m_originalConfiguration.getServerPort()), 0);
        incomingText.setLayoutData((Object)new GridData(4, 4, true, false));
        Label outgoingPortLabel = new Label(parent, 0);
        outgoingPortLabel.setText("Sonargraph Port (Outgoing Requests): ");
        outgoingPortLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        final ValidatingTextWidget outgoingText = new ValidatingTextWidget(parent, (ITextValidator)new PortValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                RemoteSelectionConfigurationDialog.this.m_modifiedPortOutgoing = input != null ? Integer.parseInt(input.trim()) : -1;
                RemoteSelectionConfigurationDialog.this.inputModified();
            }
        }, Integer.toString(this.m_originalConfiguration.getRemotePort()), 0);
        outgoingText.setLayoutData((Object)new GridData(4, 4, true, false));
        Label preferredViewLabel = new Label(parent, 0);
        preferredViewLabel.setText("Preferred View to Reveal Selection:");
        preferredViewLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        Composite choices = new Composite(parent, 0);
        choices.setLayout((Layout)new RowLayout(256));
        choices.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_packageExplorer = new Button(choices, 16);
        this.m_packageExplorer.setText(PreferredViewForRevealingRemoteSelection.PACKAGE_EXPLORER.getPresentationName());
        this.m_packageExplorer.setImage(UiResourceManager.getInstance().getImage("PackageExplorer"));
        this.m_packageExplorer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RemoteSelectionConfigurationDialog.this.m_packageExplorer.getSelection()) {
                    RemoteSelectionConfigurationDialog.this.m_modifiedPreferredView = PreferredViewForRevealingRemoteSelection.PACKAGE_EXPLORER;
                }
                RemoteSelectionConfigurationDialog.this.inputModified();
            }
        });
        this.m_projectExplorer = new Button(choices, 16);
        this.m_projectExplorer.setText(PreferredViewForRevealingRemoteSelection.PROJECT_EXPLORER.getPresentationName());
        this.m_projectExplorer.setImage(UiResourceManager.getInstance().getImage("ProjectExplorer"));
        this.m_projectExplorer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RemoteSelectionConfigurationDialog.this.m_projectExplorer.getSelection()) {
                    RemoteSelectionConfigurationDialog.this.m_modifiedPreferredView = PreferredViewForRevealingRemoteSelection.PROJECT_EXPLORER;
                }
                RemoteSelectionConfigurationDialog.this.inputModified();
            }
        });
        Composite filler = new Composite(parent, 0);
        filler.setLayoutData((Object)new GridData(4, 4, false, true));
        Button defaultsButton = new Button(parent, 8);
        defaultsButton.setLayoutData((Object)new GridData(0x1000008, 1024, true, false));
        defaultsButton.setText("Restore Defaults");
        defaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                incomingText.setText(Integer.toString(RemoteSelectionConfigurationDialog.this.m_defaultConfiguration.getServerPort()));
                outgoingText.setText(Integer.toString(RemoteSelectionConfigurationDialog.this.m_defaultConfiguration.getRemotePort()));
            }
        });
        SwtUtility.placeHorizontalSeparator((Composite)parent, (int)this.getNumberOfColumns());
    }

    protected void applyData() {
        if (this.m_modifiedPreferredView == PreferredViewForRevealingRemoteSelection.PACKAGE_EXPLORER) {
            this.m_packageExplorer.setSelection(true);
        } else {
            this.m_projectExplorer.setSelection(true);
        }
        this.getButton(0).setEnabled(false);
        this.getButton(1).setEnabled(true);
    }

    private void inputModified() {
        boolean isValid;
        boolean mdified = this.m_modifiedPortIncoming != this.m_originalConfiguration.getServerPort() || this.m_modifiedPortOutgoing != this.m_originalConfiguration.getRemotePort() || this.m_modifiedPreferredView != this.m_originalPreferredView;
        boolean bl = isValid = this.m_modifiedPortIncoming > 0 && this.m_modifiedPortOutgoing > 0;
        if (isValid && this.m_modifiedPortIncoming == this.m_modifiedPortOutgoing) {
            isValid = false;
            UserInterfaceAdapter.getInstance().error("Invalid Ports", "Ports must be different.");
        }
        this.getButton(0).setEnabled(mdified && isValid);
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected Point getPreferredSize() {
        return new Point(500, 300);
    }

    public RemoteConfiguration getModifiedConfiguration() {
        return new RemoteConfiguration(this.m_originalConfiguration.isEnabled(), this.m_modifiedPortIncoming, this.m_originalConfiguration.isRemoteEnabled(), this.m_modifiedPortOutgoing);
    }

    public PreferredViewForRevealingRemoteSelection getPreferredView() {
        return this.m_modifiedPreferredView;
    }
}

