/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.view;

import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public final class MostRecentlyUsedSystemsDialog
extends StandardDialog {
    private final List<String> m_systemPaths;
    private Combo m_paths;
    private String m_selectedPath;
    private final String m_messagePrefix;

    public MostRecentlyUsedSystemsDialog(Shell shell, List<String> systemPaths, String message) {
        super(shell, "Sonargraph Systems");
        assert (systemPaths != null && systemPaths.size() > 0) : "Parameter 'systemPaths' of method 'MostRecentlyUseSystemsDialog' must not be empty";
        this.m_systemPaths = systemPaths;
        this.m_messagePrefix = message != null ? message + "\n" : "";
    }

    protected Point getPreferredSize() {
        return new Point(700, 280);
    }

    protected void fillDialogArea(Composite composite) {
        Label info = new Label(composite, 64);
        info.setLayoutData((Object)new GridData(4, 4, true, false));
        info.setText(this.m_messagePrefix + "The following Sonargraph systems have been detected in the Eclipse projects.\nEither select one from the list or press cancel.");
        this.m_paths = new Combo(composite, 0x800808);
        this.m_paths.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_paths.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MostRecentlyUsedSystemsDialog.this.m_selectedPath = MostRecentlyUsedSystemsDialog.this.m_paths.getText();
            }
        });
    }

    public String getSelectedSystemPath() {
        return this.m_selectedPath;
    }

    protected void applyData() {
        for (String next : this.m_systemPaths) {
            this.m_paths.add(next);
        }
        this.m_selectedPath = this.m_systemPaths.get(0);
        this.m_paths.select(0);
        this.getButton(0).setEnabled(true);
    }

    protected int getNumberOfColumns() {
        return 1;
    }
}

