/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.view;

import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public final class EclipsePreferenceUtils {
    private static final String LAST_USED_SYSTEM_PATH = "com.hello2morrow.sonargraph.ide.eclipse.lastUsedSystemPath";
    private static final String EXECUTION_STATUS = "com.hello2morrow.sonargraph.ide.eclipse.executionStatus";
    private static final String CYCLE_VIEW_SHOW_IGNORED = "com.hello2morrow.sonargraph.ide.eclipse.showIgnoredCycleGroups";

    private EclipsePreferenceUtils() {
    }

    public static void storeLastUsedSystemInPreferences(String systemPath) {
        IEclipsePreferences preferences = PreferencesUtility.getPreferences((String)LAST_USED_SYSTEM_PATH);
        if (systemPath == null || systemPath.length() == 0) {
            preferences.remove(LAST_USED_SYSTEM_PATH);
        } else {
            preferences.put(LAST_USED_SYSTEM_PATH, systemPath);
        }
        PreferencesUtility.save((IEclipsePreferences)preferences);
    }

    public static String getLastUsedSoftwareSystemPath() {
        IEclipsePreferences prefs = PreferencesUtility.getPreferences((String)LAST_USED_SYSTEM_PATH);
        return prefs.get(LAST_USED_SYSTEM_PATH, null);
    }

    public static boolean isExecutingStatus() {
        IEclipsePreferences pref = PreferencesUtility.getPreferences((String)EXECUTION_STATUS);
        return pref.getBoolean(EXECUTION_STATUS, true);
    }

    public static void storeExecutingStatus(boolean isExecuting) {
        IEclipsePreferences preferences = PreferencesUtility.getPreferences((String)EXECUTION_STATUS);
        preferences.putBoolean(EXECUTION_STATUS, isExecuting);
        PreferencesUtility.save((IEclipsePreferences)preferences);
    }

    public static boolean isShowIgnoredCycles() {
        IEclipsePreferences pref = PreferencesUtility.getPreferences((String)CYCLE_VIEW_SHOW_IGNORED);
        return pref.getBoolean(CYCLE_VIEW_SHOW_IGNORED, true);
    }

    public static void storeShowIgnoredCycles(boolean showIgnored) {
        IEclipsePreferences preferences = PreferencesUtility.getPreferences((String)CYCLE_VIEW_SHOW_IGNORED);
        preferences.putBoolean(CYCLE_VIEW_SHOW_IGNORED, showIgnored);
        PreferencesUtility.save((IEclipsePreferences)preferences);
    }
}

