/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.refactoring;

import com.hello2morrow.sonargraph.ide.eclipse.e3.E3DialogSettings;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.ChangeType;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.IEclipseRefactoringInteraction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class StandardEclipseRefactoringInteraction
implements IEclipseRefactoringInteraction {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardEclipseRefactoringInteraction.class);
    private String m_dialogInfo = "";
    private final List<IJavaElement> m_elements;

    public StandardEclipseRefactoringInteraction(List<IJavaElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'StandardEclipseRefactoringInteraction' must not be empty";
        this.m_elements = elements;
    }

    @Override
    public void updateElements(Map<IResource, IJavaElement> oldResourceToNewJavaElementMap) {
        assert (oldResourceToNewJavaElementMap != null && oldResourceToNewJavaElementMap.size() > 0) : "Parameter 'oldResourceToNewJavaElementMap' of method 'updateElements' must not be empty";
        ArrayList<IJavaElement> newList = new ArrayList<IJavaElement>(this.m_elements);
        int i = 0;
        while (i < this.m_elements.size()) {
            IJavaElement next = this.m_elements.get(i);
            IResource resource = next.getResource();
            IJavaElement newElement = oldResourceToNewJavaElementMap.get(resource);
            if (newElement != null) {
                assert (next.getClass().equals(newElement.getClass())) : "Different classes: " + next.getClass().getCanonicalName() + " and " + newElement.getClass().getCanonicalName();
                newList.remove(i);
                newList.add(i, newElement);
                LOGGER.debug("Updating element {} to {} for interaction {}", new Object[]{resource.getFullPath(), newElement.getResource().getFullPath(), this.getClass().getCanonicalName()});
            }
            ++i;
        }
        this.m_elements.clear();
        this.m_elements.addAll(newList);
    }

    protected List<IJavaElement> getElements() {
        return this.m_elements;
    }

    protected final IDialogSettings getRefactoringSettings() {
        IDialogSettings settings = E3DialogSettings.getJavaPluginDialogSettings();
        assert (settings != null) : "Standard dialog settings of JavaPlugin must not be null";
        IDialogSettings refactoringSettings = settings.getSection("org.eclipse.ltk.ui.refactoring.settings");
        if (refactoringSettings == null) {
            refactoringSettings = new DialogSettings("org.eclipse.ltk.ui.refactoring.settings");
            settings.addSection(refactoringSettings);
        }
        return refactoringSettings;
    }

    @Override
    public void setDialogInfo(String info) {
        assert (info != null) : "Parameter 'info' of method 'setDialogInfo' must not be null";
        this.m_dialogInfo = info;
    }

    protected String getDialogInfo() {
        return this.m_dialogInfo;
    }

    protected final IDialogSettings getRefactoringSettings(IDialogSettings settings) {
        assert (settings != null) : "Standard dialog settings of JavaPlugin must not be null";
        IDialogSettings refactoringSettings = settings.getSection("org.eclipse.ltk.ui.refactoring.settings");
        if (refactoringSettings == null) {
            refactoringSettings = new DialogSettings("org.eclipse.ltk.ui.refactoring.settings");
            settings.addSection(refactoringSettings);
        }
        return refactoringSettings;
    }

    protected final Boolean getBooleanSetting(IDialogSettings refactoringSettings, String key) {
        assert (refactoringSettings != null) : "Parameter 'refactoringSettings' of method 'getBooleanSetting' must not be null";
        assert (key != null && key.length() > 0) : "Parameter 'key' of method 'getBooleanSetting' must not be empty";
        String update = refactoringSettings.get(key);
        if (update != null) {
            return (boolean)Boolean.valueOf(update);
        }
        return null;
    }

    public abstract String toString();

    @Override
    public String getExecutionPlan() {
        return this.toString();
    }

    @Override
    public ChangeType getChangeType() {
        return ChangeType.MODIFY;
    }
}

