/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.refactoring;

import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringChange;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringScope;
import com.hello2morrow.sonargraph.ide.eclipse.refactoring.StandardEclipseRefactoringInteraction;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RenameCompilationUnitInteraction
extends StandardEclipseRefactoringInteraction {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenameCompilationUnitInteraction.class);
    private final String m_newName;
    private final String m_plannedNameWhenExecuting;
    private final boolean m_useEscaping;

    public RenameCompilationUnitInteraction(ICompilationUnit compilationUnit, String newName) {
        this(compilationUnit, newName, false);
    }

    public RenameCompilationUnitInteraction(ICompilationUnit compilationUnit, String newName, boolean useEscaping) {
        super(new ArrayList<ICompilationUnit>(new ArrayList<ICompilationUnit>(Arrays.asList(compilationUnit))));
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'RenameCompilationUnitInteraction' must not be empty";
        this.m_newName = newName;
        this.m_plannedNameWhenExecuting = null;
        this.m_useEscaping = useEscaping;
    }

    public RenameCompilationUnitInteraction(ICompilationUnit compilationUnit, String newName, String nameWhenExecuting) {
        super(new ArrayList<ICompilationUnit>(new ArrayList<ICompilationUnit>(Arrays.asList(compilationUnit))));
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'RenameCompilationUnitInteraction' must not be empty";
        assert (nameWhenExecuting != null && nameWhenExecuting.length() > 0) : "Parameter 'nameWhenExecuting' of method 'RenameCompilationUnitInteraction' must not be empty";
        this.m_newName = newName;
        this.m_plannedNameWhenExecuting = nameWhenExecuting;
        this.m_useEscaping = false;
    }

    @Override
    public boolean isExecutable() {
        return this.getElements().get(0).exists();
    }

    @Override
    public boolean isExecutedAsPlanned(List<RefactoringChange> changes) {
        assert (changes != null) : "Parameter 'changes' of method 'isExecutedAsPlanned' must not be null";
        boolean executedAsPlanned = true;
        for (IJavaElement element : this.getElements()) {
            String parentPath = element.getParent().getResource().getFullPath().toString();
            boolean isRenamed = false;
            for (RefactoringChange change : changes) {
                if (change.getTo() == null) continue;
                String newPath = change.getTo().getFullPath().toString();
                String newName = newPath.substring(parentPath.length() + 1, newPath.length());
                if (!change.getFrom().equals((Object)element.getResource()) || !change.getTo().getParent().getFullPath().toString().equals(parentPath) || !newName.equals(this.m_newName)) continue;
                isRenamed = true;
                break;
            }
            if (isRenamed) continue;
            LOGGER.info("Deviation detected, because element '" + String.valueOf(element.getResource().getFullPath()) + "' is not found as renamed element in changes");
            executedAsPlanned = false;
        }
        return executedAsPlanned;
    }

    @Override
    public boolean execute() throws CoreException {
        RenameSupport renameSupport = RenameSupport.create((ICompilationUnit)((ICompilationUnit)this.getElements().get(0)), (String)this.m_newName, (int)1);
        return renameSupport.openDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), false);
    }

    @Override
    public String toString() {
        return "Rename '" + (this.m_plannedNameWhenExecuting == null ? this.getElements().get(0).getElementName() : this.m_plannedNameWhenExecuting) + "' to '" + this.m_newName + "'" + (this.m_useEscaping ? " (because of naming collision)" : "");
    }

    @Override
    public String getExecutionPlan() {
        if (this.m_plannedNameWhenExecuting == null) {
            return this.toString();
        }
        return "Rename '" + this.m_plannedNameWhenExecuting + "' to '" + this.m_newName + "'" + (this.m_useEscaping ? " (because of naming collision)" : "");
    }

    @Override
    public Set<RefactoringScope> getScopes() {
        return EnumSet.of(RefactoringScope.COMPILATION_UNIT);
    }
}

