/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.refactoring;

import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.ChangeType;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringChange;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RefactoringChangeListener
implements IResourceChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefactoringChangeListener.class);
    private final ChangeType m_type;
    private final List<Pair<IPath, IPath>> m_changes = new ArrayList<Pair<IPath, IPath>>();
    private final Map<IPath, IResource> m_addedFiles = new HashMap<IPath, IResource>();
    private final Map<IPath, IResource> m_removedFiles = new HashMap<IPath, IResource>();
    private final Map<IPath, IResource> m_modifiedFiles = new HashMap<IPath, IResource>();
    private final List<IResource> m_addedFolders = new ArrayList<IResource>();
    private final List<IResource> m_foldersOfAddedFiles = new ArrayList<IResource>();
    private final List<IResource> m_foldersOfRemovedFiles = new ArrayList<IResource>();
    private final List<IResource> m_removedFolders = new ArrayList<IResource>();
    private final Set<RefactoringScope> m_scopes;

    public RefactoringChangeListener(ChangeType type, Set<RefactoringScope> scopes) {
        assert (type != null) : "Parameter 'type' of method 'RefactoringChangeListener' must not be null";
        assert (scopes != null && scopes.size() > 0) : "Parameter 'scopes' of method 'RefactoringChangeListener' must not be empty";
        this.m_type = type;
        this.m_scopes = scopes;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    if (resource instanceof IFolder) {
                        IJavaElement javaElement = JavaCore.create((IResource)resource);
                        if (javaElement == null) {
                            LOGGER.debug("No Java element found for folder: {}", (Object)resource.getFullPath());
                            return true;
                        }
                        IJavaElement parent = javaElement.getParent();
                        if (parent instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)parent).getKind() == 2) {
                            LOGGER.debug("Skipping delta of binary package fragment: {}", (Object)resource.getFullPath());
                            return false;
                        }
                        if ((delta.getKind() & 2) != 0) {
                            LOGGER.debug("Removed folder: {}", (Object)resource.getFullPath());
                            RefactoringChangeListener.this.m_removedFolders.add(resource);
                        }
                        if ((delta.getKind() & 1) != 0) {
                            LOGGER.debug("Added folder: {}", (Object)resource.getFullPath());
                            RefactoringChangeListener.this.m_addedFolders.add(resource);
                        }
                    } else if (resource instanceof IFile) {
                        IJavaElement javaElement = JavaCore.create((IResource)resource);
                        if (javaElement == null) {
                            LOGGER.debug("No Java element found for file: {}", (Object)resource.getFullPath());
                            return false;
                        }
                        if ((delta.getKind() & 2) != 0) {
                            LOGGER.debug("Removed file: {}", (Object)resource.getFullPath());
                            if (RefactoringChangeListener.this.m_type == ChangeType.DELETE) {
                                RefactoringChangeListener.this.m_changes.add((Pair<IPath, IPath>)new Pair((Object)resource.getFullPath(), null));
                            }
                            RefactoringChangeListener.this.m_removedFiles.put(resource.getFullPath(), resource);
                            RefactoringChangeListener.this.m_foldersOfRemovedFiles.add((IResource)resource.getParent());
                        } else if ((delta.getKind() & 1) != 0) {
                            LOGGER.debug("Added file: {}", (Object)resource.getFullPath());
                            RefactoringChangeListener.this.m_foldersOfAddedFiles.add((IResource)resource.getParent());
                            RefactoringChangeListener.this.m_addedFiles.put(resource.getFullPath(), resource);
                        } else if ((delta.getKind() & 4) != 0) {
                            if ((delta.getFlags() & 0x100) != 0) {
                                LOGGER.debug("Modified content {}", (Object)resource.getFullPath());
                                RefactoringChangeListener.this.m_changes.add((Pair<IPath, IPath>)new Pair((Object)resource.getFullPath(), (Object)resource.getFullPath()));
                                RefactoringChangeListener.this.m_modifiedFiles.put(resource.getFullPath(), resource);
                            } else {
                                boolean markersChanged = (delta.getFlags() & 0x20000) != 0;
                                LOGGER.trace("Omitting {}, because content has not changed. Markers changed: {}", (Object)resource.getFullPath(), (Object)markersChanged);
                            }
                        }
                        if ((delta.getFlags() & 0x2000) != 0) {
                            LOGGER.debug("Moved {} -> {}", (Object)resource.getFullPath(), (Object)delta.getMovedToPath());
                            RefactoringChangeListener.this.m_changes.add((Pair<IPath, IPath>)new Pair((Object)resource.getFullPath(), (Object)delta.getMovedToPath()));
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException ex) {
            LOGGER.error("Failed to process change event: " + String.valueOf(event), (Throwable)ex);
        }
    }

    public List<RefactoringChange> getChanges() {
        LOGGER.debug("Determine changes for type {}, scopes {}", (Object)this.m_type.name(), (Object)StringUtility.concat((Collection)this.m_scopes.stream().map(s -> s.name()).collect(Collectors.toList()), (String)","));
        ArrayList<RefactoringChange> result = new ArrayList<RefactoringChange>();
        if (this.m_type != ChangeType.DELETE) {
            this.m_addedFolders.retainAll(this.m_foldersOfAddedFiles);
            this.m_removedFolders.retainAll(this.m_foldersOfRemovedFiles);
        }
        if (this.m_type == ChangeType.MODIFY && this.m_scopes.contains((Object)RefactoringScope.PACKAGE)) assert (this.m_removedFolders.size() == this.m_addedFolders.size()) : "Different number of removed and added packages: " + this.m_removedFolders.size() + " != " + this.m_addedFolders.size();
        int i = 0;
        while (i < this.m_removedFolders.size()) {
            IResource nextRemoved = this.m_removedFolders.get(i);
            if (this.m_type == ChangeType.DELETE) {
                result.add(new RefactoringChange(nextRemoved));
            } else {
                IResource nextAdded = this.m_addedFolders.get(i);
                result.add(new RefactoringChange(nextRemoved, nextAdded));
            }
            ++i;
        }
        for (Pair<IPath, IPath> next : this.m_changes) {
            IResource original;
            if (((IPath)next.getFirst()).equals(next.getSecond())) {
                original = this.m_modifiedFiles.get(next.getFirst());
                result.add(new RefactoringChange(original, original));
                continue;
            }
            original = this.m_removedFiles.get(next.getFirst());
            if (next.getSecond() == null) {
                result.add(new RefactoringChange(original));
                continue;
            }
            IResource target = this.m_addedFiles.get(next.getSecond());
            assert (target != null) : "no entry found for added resource: " + String.valueOf(next.getSecond());
            result.add(new RefactoringChange(original, target));
        }
        result.sort(new RefactoringChange.Comparator());
        return result;
    }
}

