/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.refactoring;

import com.hello2morrow.sonargraph.ide.eclipse.e3.E3DialogSettings;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.ChangeType;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.IEclipseRefactoringInteraction;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringChange;
import com.hello2morrow.sonargraph.ide.eclipse.model.refactoring.RefactoringScope;
import com.hello2morrow.sonargraph.ide.eclipse.refactoring.StandardEclipseRefactoringInteraction;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaDeleteProcessor;
import org.eclipse.jdt.internal.ui.refactoring.reorg.DeleteUserInterfaceManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeleteElementsInteraction
extends StandardEclipseRefactoringInteraction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteElementsInteraction.class);
    private static final String DIALOG_SETTINGS_DELETE_SUB_PACKAGES = "deleteSubPackages";
    private final IEclipseRefactoringInteraction.Recursive m_recursive;
    private final boolean m_updateElements;
    private final List<String> m_namesWhenExecuting;

    public DeleteElementsInteraction(List<IJavaElement> elementsToDelete, IEclipseRefactoringInteraction.Recursive recursive, List<String> namesWhenExecuting) {
        super(elementsToDelete);
        assert (recursive != null) : "Parameter 'recursive' of method 'DeleteElementsInteraction' must not be null";
        assert (namesWhenExecuting != null && namesWhenExecuting.size() > 0) : "Parameter 'namesWhenExecuting' of method 'DeleteElementsInteraction' must not be empty";
        this.m_recursive = recursive;
        this.m_updateElements = true;
        this.m_namesWhenExecuting = namesWhenExecuting;
    }

    public DeleteElementsInteraction(List<IJavaElement> elementsToDelete, IEclipseRefactoringInteraction.Recursive recursive) {
        super(elementsToDelete);
        assert (recursive != null) : "Parameter 'recursive' of method 'DeleteElementsInteraction' must not be null";
        this.m_recursive = recursive;
        this.m_updateElements = false;
        this.m_namesWhenExecuting = Collections.emptyList();
    }

    @Override
    public boolean isExecutable() {
        return this.getElements().stream().filter(e -> e.exists()).findAny().isPresent();
    }

    @Override
    public void updateElements(Map<IResource, IJavaElement> oldResourceToNewJavaElementMap) {
        if (this.m_updateElements) {
            super.updateElements(oldResourceToNewJavaElementMap);
        }
    }

    @Override
    public boolean isExecutedAsPlanned(List<RefactoringChange> changes) {
        assert (changes != null) : "Parameter 'changes' of method 'isExecutedAsPlanned' must not be null";
        boolean executedAsPlanned = true;
        for (IJavaElement element : this.getElements()) {
            if (element instanceof IMember) {
                if (!element.exists()) continue;
                LOGGER.info("Deviation detected, because element '" + String.valueOf(element.getResource().getFullPath()) + "' still exists");
                continue;
            }
            boolean isDeleted = changes.stream().anyMatch(change -> change.getFrom().equals((Object)element.getResource()) && change.getTo() == null);
            if (isDeleted) continue;
            LOGGER.info("Deviation detected, because element '" + String.valueOf(element.getResource().getFullPath()) + "' is not found as deleted element in changes");
            executedAsPlanned = false;
        }
        return executedAsPlanned;
    }

    @Override
    public boolean execute() throws CoreException {
        List<Object> existingElements = this.getElements().stream().filter(e -> e.exists()).collect(Collectors.toList());
        IDialogSettings refactoringSettings = this.getRefactoringSettings(E3DialogSettings.getRefactoringPluginDialogSettings());
        Boolean originalDeleteSubPackages = this.getBooleanSetting(refactoringSettings, DIALOG_SETTINGS_DELETE_SUB_PACKAGES);
        refactoringSettings.put(DIALOG_SETTINGS_DELETE_SUB_PACKAGES, this.m_recursive == IEclipseRefactoringInteraction.Recursive.YES);
        JavaDeleteProcessor deleteProcessor = new JavaDeleteProcessor(existingElements.toArray(new Object[existingElements.size()]));
        DeleteRefactoring refactoring = new DeleteRefactoring((DeleteProcessor)deleteProcessor);
        try {
            boolean bl = DeleteUserInterfaceManager.getDefault().getStarter((Refactoring)refactoring).activate((Refactoring)refactoring, WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), 3);
            return bl;
        }
        finally {
            if (originalDeleteSubPackages != null) {
                refactoringSettings.put(DIALOG_SETTINGS_DELETE_SUB_PACKAGES, originalDeleteSubPackages.booleanValue());
            }
        }
    }

    @Override
    public String getExecutionPlan() {
        if (this.getElements().size() == 1) {
            IJavaElement element = this.getElements().get(0);
            String elementPath = this.m_namesWhenExecuting.isEmpty() ? this.getElementName(element) : this.m_namesWhenExecuting.get(0);
            return "Delete '" + elementPath + "'.";
        }
        return "Delete " + this.getElements().size() + " elements.";
    }

    private String getElementName(IJavaElement element) {
        Object elementPath = element instanceof IMember ? element.getParent().getElementName() + "." + element.getElementName() : element.getResource().getFullPath().toString();
        return elementPath;
    }

    @Override
    public String toString() {
        if (this.getElements().size() == 1) {
            return "Delete '" + this.getElementName(this.getElements().get(0)) + "'.";
        }
        return "Delete " + this.getElements().size() + " elements.";
    }

    @Override
    public Set<RefactoringScope> getScopes() {
        return EnumSet.of(RefactoringScope.COMPILATION_UNIT, RefactoringScope.PACKAGE);
    }

    @Override
    public ChangeType getChangeType() {
        return ChangeType.DELETE;
    }
}

