/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.plugin;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.PluginConstants;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.CloseSoftwareSystemJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SonargraphEclipseWorkspaceChangeListener
implements IElementChangedListener,
IResourceChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphEclipseWorkspaceChangeListener.class);
    private final ISoftwareSystemProvider m_systemProvider;
    private boolean m_closingStarted = false;
    private final IEventBroker m_eventBroker;

    public SonargraphEclipseWorkspaceChangeListener(ISoftwareSystemProvider systemProvider, IEventBroker eventBroker) {
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'SonargraphResourceChangeListener' must not be null";
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'SonargraphEclipseWorkspaceChangeListener' must not be null";
        this.m_systemProvider = systemProvider;
        this.m_eventBroker = eventBroker;
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        if (!this.m_closingStarted) {
            this.visit(delta);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.m_systemProvider.hasSoftwareSystem()) {
            LOGGER.error("No system is opened, but workspace change listener is still active and will be deactivated now.");
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            return;
        }
        if (this.m_closingStarted) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("\n------------------- event type [" + event.getType() + "]--------------------");
            if (event.getSource() instanceof IProject) {
                LOGGER.trace("Change scope: Eclipse Project");
            } else if (event.getSource() instanceof IWorkspace) {
                LOGGER.trace("Change scope: Eclipse Workspace");
            } else {
                LOGGER.trace("Change scope: " + event.getSource().getClass().getName());
            }
        }
        switch (event.getType()) {
            case 2: {
                if (EclipseWorkspaceUtils.isSonargraphResource(event.getResource())) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Pre close of project {}", (Object)event.getResource());
                    }
                    this.closeSoftwareSystem(event.getResource().getName());
                }
                return;
            }
            case 4: {
                if (EclipseWorkspaceUtils.isSonargraphResource(event.getResource())) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Pre delete of project {}", (Object)event.getResource());
                    }
                    this.closeSoftwareSystem(event.getResource().getName());
                }
                return;
            }
            case 1: {
                if (!LOGGER.isTraceEnabled()) break;
                LOGGER.trace("Post change!");
                break;
            }
            default: {
                if (!LOGGER.isTraceEnabled()) break;
                LOGGER.trace("Event type: " + event.getType());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void visit(IJavaElementDelta delta) {
        if (this.m_closingStarted) {
            return;
        }
        IJavaElement element = delta.getElement();
        switch (element.getElementType()) {
            case 1: {
                this.visitChildren(delta);
                return;
            }
            case 2: {
                if (!EclipseWorkspaceUtils.isSonargraphResource(element.getResource())) return;
                if (this.isProjectClosed(delta.getFlags())) {
                    LOGGER.debug("Project closed: " + element.getElementName());
                    this.closeSoftwareSystem(element.getElementName());
                    return;
                }
                if (!this.isClasspathChanged(delta.getFlags()) || !(element instanceof IJavaProject)) return;
                IJavaProject javaProject = (IJavaProject)element;
                IProject project = javaProject.getProject();
                try {
                    ModuleInfo projectInfo = EclipseWorkspaceUtils.convertToModuleInfo(project);
                    Workspace workspace = (Workspace)this.m_systemProvider.getSoftwareSystem().getUniqueExistingChild(Workspace.class);
                    Object moduleName = project.getSessionProperty(PluginConstants.SONARGRAPH_RESOURCE_MODULE_QUALIFIED_NAME);
                    JavaModule module = (JavaModule)workspace.getUniqueChild((NamedElement.IFilter)new ShortNameFilter(moduleName.toString()), JavaModule.class);
                    if (this.haveActiveRootPathsChanged(module, projectInfo)) {
                        LOGGER.info("Active root paths changed of project: " + project.getName() + ", resource: " + element.getResource().getName());
                        this.closeSoftwareSystem(project.getName());
                        return;
                    }
                    if (!this.areInactiveRootPathsNowPresent(module, projectInfo)) return;
                    LOGGER.info("Inactive root paths are now present in project: " + project.getName() + ", resource: " + element.getResource().getName());
                    this.closeSoftwareSystem(project.getName());
                    return;
                }
                catch (JavaModelException ex) {
                    LOGGER.error("Failed to convert project '" + project.getName() + "' to module info: ", (Throwable)ex);
                    UserInterfaceAdapter.getInstance().error("Failed to Convert Project", "Failed to process project '" + project.getName() + "'");
                    this.closeSoftwareSystem(project.getName());
                    return;
                }
                catch (CoreException ex) {
                    LOGGER.error("Failed to get module name property from project '" + project.getName() + "': ", (Throwable)ex);
                    UserInterfaceAdapter.getInstance().error("Failed to Get Module Name", "Failed to get module name of project '" + project.getName() + "'");
                    this.closeSoftwareSystem(project.getName());
                    return;
                }
            }
        }
    }

    private boolean isProjectClosed(int flags) {
        boolean closed = (flags & 0x400) != 0;
        return closed;
    }

    private void visitChildren(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta nextDelta = iJavaElementDeltaArray[n2];
            if (this.m_closingStarted) {
                return;
            }
            this.visit(nextDelta);
            ++n2;
        }
    }

    private final boolean isClasspathChanged(int flags) {
        boolean changed = (flags & 0x200000) != 0;
        return changed;
    }

    private void closeSoftwareSystem(String projectName) {
        assert (projectName != null && projectName.length() > 0) : "Parameter 'projectName' of method 'closeSoftwareSystem' must not be empty";
        this.m_closingStarted = true;
        if (!this.m_systemProvider.hasSoftwareSystem()) {
            return;
        }
        CloseSoftwareSystemJob closeJob = new CloseSoftwareSystemJob(this.m_eventBroker, this.m_systemProvider, "Sonargraph analysis will be suspended due to detected workspace changes in project '" + projectName + "'.\nResume the Sonargraph analysis when you are finished with the modifications.");
        closeJob.schedule();
    }

    private boolean areInactiveRootPathsNowPresent(JavaModule module, ModuleInfo projectInfo) {
        assert (module != null) : "Parameter 'module' of method 'areInactiveRootPathsNowPresent' must not be null";
        assert (projectInfo != null) : "Parameter 'projectInfo' of method 'areInactiveRootPathsNowPresent' must not be null";
        List projectSrcRoots = projectInfo.getNonStandardRootPaths().stream().map(r -> r.getPath()).collect(Collectors.toList());
        List inactiveModuleScrRoots = module.getChildren(JavaSourceRootDirectoryPath.class).stream().filter(r -> !r.isEnabled()).map(r -> FileUtility.getIdentifyingPath((TFile)r.getFile())).collect(Collectors.toList());
        List inactiveSourceRoots = inactiveModuleScrRoots.stream().filter(r -> projectSrcRoots.contains(r)).collect(Collectors.toList());
        if (inactiveSourceRoots.size() > 0) {
            LOGGER.info("Inactive Sonargraph source root(s) '" + inactiveSourceRoots.stream().collect(Collectors.joining(", ")) + "' now present in project");
            return true;
        }
        List projectClsRoots = projectInfo.getStandardRootPaths().stream().map(r -> r.getPath()).collect(Collectors.toList());
        List inactiveModuleClsRoots = module.getChildren(JavaClassRootDirectoryPath.class).stream().filter(r -> !r.isEnabled()).map(r -> FileUtility.getIdentifyingPath((TFile)r.getFile())).collect(Collectors.toList());
        List inactiveClassRoots = inactiveModuleClsRoots.stream().filter(r -> projectClsRoots.contains(r)).collect(Collectors.toList());
        if (inactiveClassRoots.size() > 0) {
            LOGGER.info("Inactive Sonargraph class root(s) '" + inactiveClassRoots.stream().collect(Collectors.joining(", ")) + "' now present in project");
            return true;
        }
        return false;
    }

    private boolean haveActiveRootPathsChanged(JavaModule module, ModuleInfo projectInfo) {
        assert (module != null) : "Parameter 'module' of method 'haveActiveRootPathsChanged' must not be null";
        assert (projectInfo != null) : "Parameter 'projectInfo' of method 'haveActiveRootPathsChanged' must not be null";
        List srcRoots = module.getChildren(JavaSourceRootDirectoryPath.class);
        List activeSourceRoots = srcRoots.stream().filter(r -> r.isEnabled()).map(r -> FileUtility.getIdentifyingPath((TFile)r.getOriginal().getFile())).collect(Collectors.toList());
        List eclipseSrcRoots = projectInfo.getNonStandardRootPaths().stream().map(r -> r.getPath()).collect(Collectors.toList());
        activeSourceRoots.removeAll(eclipseSrcRoots);
        if (activeSourceRoots.size() > 0) {
            LOGGER.info("Active Sonargraph source root(s) '" + activeSourceRoots.stream().collect(Collectors.joining(", ")) + "' no longer present.");
            return true;
        }
        List classRoots = module.getChildren(JavaClassRootDirectoryPath.class);
        List activeClassRoots = classRoots.stream().filter(r -> r.isEnabled()).map(r -> FileUtility.getIdentifyingPath((TFile)r.getOriginal().getFile())).collect(Collectors.toList());
        List eclipseClassRoots = projectInfo.getStandardRootPaths().stream().map(r -> r.getPath()).collect(Collectors.toList());
        activeClassRoots.removeAll(eclipseClassRoots);
        if (activeClassRoots.size() > 0) {
            LOGGER.info("Active Sonargraph class root(s) '" + activeClassRoots.stream().collect(Collectors.joining(", ")) + "' no longer present.");
            return true;
        }
        return false;
    }
}

