/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.plugin;

import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.DeltaRefreshSoftwareSystemJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.marker.AbstractCreateMarkerJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.RefreshInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SonargraphEclipseWorkspaceBuildEventListener
implements IResourceChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SonargraphEclipseWorkspaceBuildEventListener.class);
    private final ISonargraphEclipsePlugin m_plugin;
    private final IEventBroker m_eventBroker;

    public SonargraphEclipseWorkspaceBuildEventListener(ISonargraphEclipsePlugin plugin, IEventBroker eventBroker) {
        assert (plugin != null) : "Parameter 'plugin' of method 'SonargraphEclipseWorkspaceBuildEventListener' must not be null";
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'SonargraphEclipseWorkspaceBuildEventListener' must not be null";
        this.m_plugin = plugin;
        this.m_eventBroker = eventBroker;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.m_plugin.isInitialized() || !this.m_plugin.getSoftwareSystemProvider().hasSoftwareSystem() || this.m_plugin.isStopping()) {
            LOGGER.error("No system is opened, but resource change listener is still active and will be deactivated now.");
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            return;
        }
        RefreshInfo refreshInfo = this.m_plugin.getRefreshInfo();
        long start = System.currentTimeMillis();
        assert (event.getType() == 8 || event.getType() == 16) : "Only pre or post build events allowed!";
        String eventType = this.getEvent(event);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\n------------------- event type [" + eventType + "]--------------------");
        }
        if (event.getSource() instanceof IProject) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Change scope: Eclipse project");
            }
        } else if (event.getSource() instanceof IWorkspace) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Change scope: Eclipse Workspace");
            }
        } else assert (false) : "Unexpected change scope: " + event.getSource().getClass().getName();
        if (event.getType() == 8) {
            refreshInfo.clear();
        } else if (event.getType() == 16) {
            if (refreshInfo.getDeltas().isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} ms needed to check that no deltas exist and no refresh of Sonargraph system is needed", (Object)(System.currentTimeMillis() - start));
                }
            } else {
                List<ModuleDelta> deltas = refreshInfo.getDeltas().stream().filter(delta -> !delta.isEmpty()).collect(Collectors.toList());
                refreshInfo.clear();
                if (!deltas.isEmpty()) {
                    DeltaRefreshSoftwareSystemJob.cancelAllJobsByClass(AbstractCreateMarkerJob.class);
                    DeltaRefreshSoftwareSystemJob deltaRefresh = new DeltaRefreshSoftwareSystemJob(this.m_eventBroker, this.m_plugin.getSoftwareSystemProvider(), this.m_plugin.getFileRegistry(), deltas);
                    deltaRefresh.schedule();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("{} ms needed to trigger Sonargraph refresh", (Object)(System.currentTimeMillis() - start));
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("{} ms needed to check that all deltas are empty and no refresh of Sonargraph system is needed.", (Object)(System.currentTimeMillis() - start));
                }
            }
        }
        long duration = System.currentTimeMillis() - start;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\n-------------------- {} ms needed to process {} event ", (Object)duration, (Object)eventType);
        }
    }

    private String getEvent(IResourceChangeEvent event) {
        String eventType = event.getType() == 8 ? "PRE_BUILD" : (event.getType() == 16 ? "POST_BUILD" : "UNSUPPORTED");
        return eventType;
    }
}

