/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.plugin;

import com.hello2morrow.sonargraph.client.eclipse.application.EclipseApplication;
import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.foundation.common.SwtResourceProviderAdapter;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderAdapter;
import com.hello2morrow.sonargraph.ide.eclipse.commandhandler.E4HandlerUtil;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.EclipsePluginResourceProviderAdapter;
import com.hello2morrow.sonargraph.ide.eclipse.model.E4ModelUtil;
import com.hello2morrow.sonargraph.ide.eclipse.plugin.EclipseSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.WizardRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IProgressService;

@Singleton
@Creatable
final class SonargraphEclipsePluginApplication
extends EclipseApplication {
    @Inject
    EModelService m_modelService;
    @Inject
    MApplication m_application;
    @Inject
    EclipseSelectionAdapter m_eclipseSelectionAdapter;
    @Inject
    @Optional
    IProgressService m_progressService;

    @Inject
    public SonargraphEclipsePluginApplication() {
        super(EclipseApplication.BundleHandling.STATIC, SonargraphProduct.SONARGRAPH_ECLIPSE);
    }

    public void startupComplete() {
        assert (this.m_modelService != null) : "Field 'm_modelService' must be injected";
        assert (this.m_application != null) : "Field 'm_application' must be injected";
        Map<String, MMenuItem> commandIdToMenuItem = E4ModelUtil.findSonargraphMenuItems(this.m_modelService, this.m_application);
        List<MHandler> handlers = E4HandlerUtil.findSonargraphHandlers(this.m_modelService, this.m_application);
        for (MHandler nextHandler : handlers) {
            String nextCommandId;
            MMenuItem nextMenuItem;
            assert (nextHandler != null) : "E4ModelUtil.findSonargraphHandlers must not return null MHandler";
            assert (nextHandler.getObject() instanceof CommandHandler) : "E4ModelUtil.findSonargraphHandlers must only return CommandHandler";
            CommandHandler nextCommandHandler = (CommandHandler)nextHandler.getObject();
            MCommand nextModelCommand = nextHandler.getCommand();
            assert (nextModelCommand != null) : "E4ModelUtil.findSonargraphHandlers must not return null MCommand";
            IContextMenuContributor contributor = nextCommandHandler.createContextMenuContributor();
            if (contributor == null || (nextMenuItem = commandIdToMenuItem.get(nextCommandId = nextModelCommand.getElementId())) == null) continue;
            WorkbenchRegistry.getInstance().registerContextMenuContributor(nextCommandId, nextMenuItem, contributor);
        }
        if (!CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.ARCHITECTURE)) {
            this.removeToolBarElementFromModel("com.hello2morrow.sonargraph.ide.eclipse.handledtoolitem.startStopHttpServer");
            this.removeToolBarElementFromModel("com.hello2morrow.sonargraph.ide.eclipse.handledtoolitem.revealRemoteSelection");
            this.removeToolBarElementFromModel("com.hello2morrow.sonargraph.ide.eclipse.handledtoolitem.selectInStandalone");
        }
        if (this.m_progressService != null) {
            this.m_progressService.registerIconForFamily(ImageDescriptor.createFromFile(SonargraphEclipsePluginApplication.class, (String)"/images/SonargraphJob.gif"), (Object)"com.hello2morrow.sonargraph.ide.eclipse.jobs");
        }
        super.startupComplete();
    }

    @PostConstruct
    final void start(IEclipseContext eclipseContext, Display display) {
        assert (eclipseContext != null) : "Parameter 'applicationContext' of method 'postContextCreate' must not be null";
        assert (display != null) : "Parameter 'display' of method 'postContextCreate' must not be null";
        if (!UiResourceManager.hasInstance()) {
            UiResourceManager.createInstance((Display)Display.getDefault());
            UiResourceManager.getInstance().addResourceProviderAdapter((ResourceProviderAdapter)EclipsePluginResourceProviderAdapter.getInstance());
            UiResourceManager.getInstance().addResourceProviderAdapter((ResourceProviderAdapter)SwtResourceProviderAdapter.getInstance());
        }
        WizardRegistry.createInstance((IEclipseContext)eclipseContext);
    }

    private void removeToolBarElementFromModel(String id) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'removeToolBarElementFromModel' must not be empty";
        List elements = this.m_modelService.findElements((MUIElement)this.m_application, id, MToolBarElement.class, null);
        for (MToolBarElement element : elements) {
            MElementContainer parent = element.getParent();
            List children = parent.getChildren();
            children.remove(element);
            element.setParent(null);
        }
    }

    @PreDestroy
    public void stop() {
        WizardRegistry.delete();
        UserInterfaceAdapter.delete();
        UiResourceManager.delete();
    }
}

