/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.plugin;

import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefactoringsViewContextMenuHelper
extends PropertyTester {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefactoringsViewContextMenuHelper.class);
    private static final String APPLICABLE_PROPERTY = "isApplicable";
    private static final String HAS_ELEMENTS_PROPERTY = "hasElements";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof RefactoringDefinition) {
            RefactoringDefinition refactoring = (RefactoringDefinition)receiver;
            if (APPLICABLE_PROPERTY.equals(property)) {
                boolean applicable = refactoring.getStatus().isApplicable();
                LOGGER.trace("Refactoring is {}applicable", (Object)(applicable ? "" : "not "));
                return applicable;
            }
            if (HAS_ELEMENTS_PROPERTY.equals(property)) {
                List associatedIssues = refactoring.getAssociatedIssues();
                boolean hasElements = false;
                for (IIssue nextIssue : associatedIssues) {
                    if (!(nextIssue instanceof NamedElementIssue)) continue;
                    hasElements = true;
                    break;
                }
                LOGGER.trace("Refactoring has {}elements", (Object)(hasElements ? "" : "no "));
                return hasElements;
            }
        }
        return false;
    }
}

