/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.plugin;

import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.MPartUtility;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.SelectionChangedJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.IStructuredSelection;

@Creatable
@Singleton
public final class EclipseSelectionAdapter {
    private Object m_lastSelection = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Inject
    public void selectionChanged(IEclipseContext eclipseContext, @Optional ISonargraphEclipsePlugin plugin, @Optional @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, @Named(value="e4ActivePart") MPart part) {
        if (selection == null) {
            if (part == null) return;
            Object selected = MPartUtility.getJavaFileOfEditor(part);
            if (selected == null) {
                this.m_lastSelection = null;
                return;
            }
            if (selected instanceof IJavaElement && ((IJavaElement)selected).getJavaProject() == null) {
                this.m_lastSelection = null;
                return;
            }
            this.m_lastSelection = selected;
        } else {
            if (selection == this.m_lastSelection) {
                return;
            }
            Object object = this.m_lastSelection = selection.size() > 0 ? selection.getFirstElement() : null;
        }
        if (this.m_lastSelection != null && plugin != null && WorkbenchRegistry.isRunning() && WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) {
            SelectionChangedJob job = new SelectionChangedJob(plugin, eclipseContext, this.m_lastSelection);
            SelectionChangedJob.cancelAll();
            job.schedule();
            return;
        }
        SelectionChangedJob.selectDefault(eclipseContext);
    }
}

