/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.plugin;

import com.hello2morrow.sonargraph.client.eclipse.application.IExceptionHandler;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.SendFeedbackCommand;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ide.eclipse.commandhandler.EclipsePluginProxySettingsProvider;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ui.swt.base.IProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.EclipseApplicationExceptionHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.IExceptionHandlingSupport;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.dialog.feedback.FeedbackOnErrorDialog;
import com.hello2morrow.sonargraph.userfeedback.model.Feedback;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EclipsePluginExceptionHandler
extends EclipseApplicationExceptionHandler
implements IExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(EclipsePluginExceptionHandler.class);
    private static final String ORG_ECLIPSE_EQUINOX_P2 = "org.eclipse.equinox.p2";
    private final ISonargraphEclipsePlugin m_sonargraphPlugin;

    public EclipsePluginExceptionHandler(IExceptionHandlingSupport uiAdapterProvider, ISonargraphEclipsePlugin sonargraphPlugin) {
        super(uiAdapterProvider);
        this.m_sonargraphPlugin = sonargraphPlugin;
    }

    protected void handleFeedbackInteraction(IStatus status, Throwable throwable) {
        assert (status != null) : "Parameter 'status' of method 'handleFeedbackInteraction' must not be null";
        assert (throwable != null) : "Parameter 'throwable' of method 'handleFeedbackInteraction' must not be null";
        if (!UserInterfaceAdapter.hasInstance()) {
            return;
        }
        TFile logFile = SendFeedbackCommand.getLogFile();
        EclipsePluginProxySettingsProvider proxySettingsProvider = new EclipsePluginProxySettingsProvider(SonargraphLicenseHandler.getHosts());
        String infoText = "Sadly we did not even detect this problem during our 'Monkey' test." + StringUtility.LINE_SEPARATOR + "We recommend that you send us the error report. " + StringUtility.LINE_SEPARATOR + StringUtility.LINE_SEPARATOR;
        FeedbackOnErrorDialog dialog = new FeedbackOnErrorDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), throwable, logFile, "com.hello2morrow.sonargraph.ide.eclipse", (IProxySettingsProvider)proxySettingsProvider, infoText, new String[]{IDialogConstants.SHOW_DETAILS_LABEL, IDialogConstants.OK_LABEL}, 1);
        dialog.open();
        if (dialog.sendErrorEmail()) {
            try {
                List additionalFiles;
                if (logFile != null) {
                    additionalFiles = new ArrayList(1);
                    additionalFiles.add(new TFile((File)EclipsePluginExceptionHandler.getWorkspaceMetaDataDirectory(), ".log"));
                } else {
                    additionalFiles = Collections.emptyList();
                }
                OperationResult result = SendFeedbackCommand.sendErrorFeedback((Feedback.Salutation)dialog.getSalutation(), (String)dialog.getContactName(), (String)dialog.getEmail(), (String)dialog.getPhone(), (String)(dialog.getContextInfo() + "\n\nRunning on Eclipse platform version " + this.m_sonargraphPlugin.getEclipsePlatformVersion()), (Throwable)throwable, (String)status.getMessage(), (TFile)logFile, additionalFiles, (ProxySettings)proxySettingsProvider.getProxySettings(false));
                UserInterfaceAdapter.getInstance().process(result);
            }
            catch (Throwable t) {
                LOGGER.error("Failed to send error email! " + StringUtility.LINE_SEPARATOR + "{}", (Object)ExceptionUtility.collectAll((Throwable)t));
            }
        }
        UserInterfaceAdapter.getInstance().information("Monitoring is Suspended", "The Sonargraph monitoring will be suspended." + StringUtility.LINE_SEPARATOR + "You can re-activate the monitoring by selecting 'Resume Analysis' from the Sonargraph menu.");
        this.m_sonargraphPlugin.setStopping(true);
        Job.getJobManager().cancel((Object)"com.hello2morrow.sonargraph.ide.eclipse.jobs");
        TearDownJob tearDown = new TearDownJob();
        tearDown.setPriority(10);
        tearDown.schedule();
    }

    public static TFile getWorkspaceMetaDataDirectory() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        TFile workspaceDirectory = new TFile(workspace.getRoot().getLocation().toFile());
        return new TFile((File)workspaceDirectory, ".metadata");
    }

    protected boolean isRelevant(String plugin, IStatus status, Throwable throwable) {
        assert (plugin != null) : "Parameter 'plugin' of method 'isRelevant' must not be null";
        assert (status != null) : "Parameter 'status' of method 'isRelevant' must not be null";
        assert (throwable != null) : "Parameter 'throwable' of method 'isRelevant' must not be null";
        if (plugin.startsWith(ORG_ECLIPSE_EQUINOX_P2)) {
            return false;
        }
        String pluginFromStatus = status.getPlugin();
        if (pluginFromStatus != null && pluginFromStatus.startsWith(ORG_ECLIPSE_EQUINOX_P2)) {
            return false;
        }
        if (pluginFromStatus != null && pluginFromStatus.startsWith("org.codehaus.groovy.eclipse.core")) {
            return false;
        }
        if (throwable.getClass().equals(RuntimeException.class) && throwable.getMessage() != null && throwable.getMessage().startsWith("WARNINGS:")) {
            return false;
        }
        if (throwable.getClass().equals(CoreException.class) && throwable.getMessage() != null && throwable.getMessage().matches("No property tester contributes a property .* to type class org.eclipse.core.internal.resources.Project")) {
            return false;
        }
        if (throwable.getClass().equals(BundleException.class) && throwable.getMessage() != null && throwable.getMessage().contains("Unable to acquire the state change lock for the module")) {
            return false;
        }
        return pluginFromStatus != null && ExceptionUtility.collectAllStacktraceElements((Throwable)throwable).stream().anyMatch(ste -> ste.getClassName().startsWith("com.hello2morrow") && !ste.getClassName().startsWith("com.hello2morrow.sonar."));
    }

    private class TearDownJob
    extends Job {
        public TearDownJob() {
            super("Tear down and re-initialize plugin");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            ISoftwareSystemProvider systemProvider = EclipsePluginExceptionHandler.this.m_sonargraphPlugin.getSoftwareSystemProvider();
            if (systemProvider.hasSoftwareSystem()) {
                CloseSoftwareSystemCommand close = new CloseSoftwareSystemCommand(systemProvider, new CloseSoftwareSystemCommand.ICloseInteraction(){

                    public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                        if (!$assertionsDisabled && system == null) {
                            throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                        }
                        if (!$assertionsDisabled && toBeSaved == null) {
                            throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                        }
                        return Collections.emptyMap();
                    }

                    public boolean closeSoftwareSystem() {
                        return true;
                    }

                    public boolean collectSaveData(SaveSoftwareSystemCommand.ModifiableFilesToBeSavedData data) {
                        return true;
                    }
                });
                close.runSynchronously();
            }
            EclipsePluginExceptionHandler.this.m_sonargraphPlugin.reinitializeAfterError();
            EclipsePluginExceptionHandler.this.setHasCriticalExceptionAlreadyOccurred(false);
            EclipsePluginExceptionHandler.this.setAlreadyShowingWarningOrErrorDialog(false);
            EclipsePluginExceptionHandler.this.setLastHandledThrowableHashCode(-1);
            return Status.OK_STATUS;
        }
    }
}

