/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model.refactoring;

import org.eclipse.core.resources.IResource;

public class RefactoringChange {
    private final IResource m_from;
    private final IResource m_to;
    private final Type m_type;
    private String m_comment;

    public RefactoringChange(IResource from) {
        assert (from != null) : "Parameter 'from' of method 'RefactoringChange' must not be null";
        this.m_from = from;
        this.m_to = null;
        this.m_type = Type.DELETED;
    }

    public RefactoringChange(IResource from, IResource to) {
        assert (from != null) : "Parameter 'from' of method 'RefactoringChange' must not be null";
        assert (to != null) : "Parameter 'to' of method 'RefactoringChange' must not be null";
        this.m_from = from;
        this.m_to = to;
        this.m_type = this.m_to == null ? Type.DELETED : (this.m_from.equals((Object)this.m_to) ? Type.MODIFIED : Type.MOVED);
    }

    public IResource getFrom() {
        return this.m_from;
    }

    public IResource getTo() {
        return this.m_to;
    }

    public void setComment(String comment) {
        assert (comment != null) : "Parameter 'comment' of method 'setComment' must not be null";
        this.m_comment = comment;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        if (this.m_to == null) {
            msg.append("Deleted: ").append(this.m_from.getFullPath());
        } else if (this.m_from.equals((Object)this.m_to)) {
            msg.append("Modified: ").append(this.m_from.getFullPath());
        } else {
            msg.append("Moved: ").append(this.m_from.getFullPath()).append(" -> ").append(this.m_to.getFullPath());
        }
        if (this.m_comment != null) {
            msg.append("; ").append("Comment: " + this.m_comment);
        }
        return msg.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_comment == null ? 0 : this.m_comment.hashCode());
        result = 31 * result + (this.m_from == null ? 0 : this.m_from.hashCode());
        result = 31 * result + (this.m_to == null ? 0 : this.m_to.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RefactoringChange other = (RefactoringChange)obj;
        if (this.m_comment == null ? other.m_comment != null : !this.m_comment.equals(other.m_comment)) {
            return false;
        }
        if (this.m_from == null ? other.m_from != null : !this.m_from.equals((Object)other.m_from)) {
            return false;
        }
        return !(this.m_to == null ? other.m_to != null : !this.m_to.equals((Object)other.m_to));
    }

    public static class Comparator
    implements java.util.Comparator<RefactoringChange> {
        @Override
        public int compare(RefactoringChange rc1, RefactoringChange rc2) {
            assert (rc1 != null) : "Parameter 'rc1' of method 'compareTo' must not be null";
            assert (rc2 != null) : "Parameter 'rc2' of method 'compare' must not be null";
            int typeCompare = Integer.compare(rc1.m_type.ordinal(), rc2.m_type.ordinal());
            if (typeCompare != 0) {
                return typeCompare;
            }
            int fromCompare = rc1.m_from.getFullPath().toString().compareTo(rc2.m_from.getFullPath().toString());
            return fromCompare;
        }
    }

    private static enum Type {
        MOVED,
        DELETED,
        MODIFIED;

    }
}

