/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model;

import org.eclipse.core.resources.IResource;

public class ResourceInfo {
    private final boolean m_isResourceTrueElement;
    private final String m_elementName;
    private final IResource m_resource;
    private final boolean m_isPartOfActiveWorkspace;

    public ResourceInfo(IResource resource, String sonargraphElementName, boolean isResourceTrueElement, boolean isPartOfActiveWorkspace) {
        assert (sonargraphElementName != null && sonargraphElementName.length() > 0) : "Parameter 'sonargraphElementName' of method 'ResourceInfo' must not be empty";
        this.m_resource = resource;
        this.m_elementName = sonargraphElementName;
        this.m_isResourceTrueElement = isResourceTrueElement;
        this.m_isPartOfActiveWorkspace = isPartOfActiveWorkspace;
    }

    public IResource getResource() {
        return this.m_resource;
    }

    public String getSonargraphElementName() {
        return this.m_elementName;
    }

    public boolean isResourceTrueElement() {
        return this.m_isResourceTrueElement;
    }

    public boolean isPartOfActiveWorkspace() {
        return this.m_isPartOfActiveWorkspace;
    }

    public boolean isValid() {
        return this.m_isPartOfActiveWorkspace && this.m_resource != null && this.m_resource.exists();
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        if (!this.m_isPartOfActiveWorkspace) {
            msg.append("[Inactive]");
        }
        if (!this.isValid()) {
            msg.append("[Invalid] ");
        } else {
            msg.append("Resource: ").append(this.m_resource.getName()).append(", ");
        }
        msg.append("Sonargraph element: ").append(this.m_elementName);
        msg.append(", isTrueElement: ").append(this.m_isResourceTrueElement);
        return msg.toString();
    }
}

