/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model;

import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RefreshInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshInfo.class);
    private final Map<String, ModuleDelta> m_deltas = new LinkedHashMap<String, ModuleDelta>();

    public void addModuleDelta(ModuleDelta delta) {
        assert (delta != null) : "Parameter 'delta' of method 'addModuleDelta' must not be null";
        String moduleName = delta.getModule().getName();
        ModuleDelta existingDelta = this.m_deltas.get(moduleName);
        if (existingDelta != null) {
            LOGGER.warn("Integrating new delta for module {}", (Object)moduleName);
            existingDelta.integrate(delta);
        } else {
            this.m_deltas.put(moduleName, delta);
        }
    }

    public List<ModuleDelta> getDeltas() {
        return new ArrayList<ModuleDelta>(this.m_deltas.values());
    }

    public void clear() {
        this.m_deltas.clear();
    }

    public String toString() {
        if (this.m_deltas.isEmpty()) {
            return "RefreshInfo is empty";
        }
        StringBuilder summary = new StringBuilder("RefreshInfo contains the following module deltas: ");
        summary.append(this.m_deltas.keySet().stream().collect(Collectors.joining(", ")));
        return summary.toString();
    }
}

