/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseMethodSignatureResolver;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaInternalCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class JavaElementNameFilter
implements NamedElement.IFilter {
    private final String m_javaElementName;
    private final boolean m_isTypeOrLower;

    public JavaElementNameFilter(IJavaElement javaElement) throws JavaModelException {
        if (javaElement instanceof ICompilationUnit) {
            ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
            IPackageFragment packageFragment = (IPackageFragment)compilationUnit.getParent();
            this.m_javaElementName = packageFragment == null || packageFragment.getElementName().trim().length() == 0 ? "./" + javaElement.getElementName() : "./" + packageFragment.getElementName().replaceAll("\\.", "/") + "/" + javaElement.getElementName();
            this.m_isTypeOrLower = false;
        } else if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            this.m_javaElementName = type.getFullyQualifiedName();
            this.m_isTypeOrLower = true;
        } else if (javaElement instanceof IMethod) {
            IMethod method = (IMethod)javaElement;
            IType type = method.getDeclaringType();
            String typeFQN = type.getFullyQualifiedName();
            String signature = "(" + EclipseMethodSignatureResolver.getResolvedParameterList(type, method) + ")";
            this.m_javaElementName = typeFQN + "." + method.getElementName() + signature;
            this.m_isTypeOrLower = true;
        } else if (javaElement instanceof IField) {
            IField field = (IField)javaElement;
            IType type = field.getDeclaringType();
            String typeFQN = type.getFullyQualifiedName();
            this.m_javaElementName = typeFQN + "." + field.getElementName() + com.hello2morrow.sonargraph.core.model.programming.IField.DESCRIPTOR_NAME_PART_SUFFIX;
            this.m_isTypeOrLower = true;
        } else {
            this.m_javaElementName = javaElement.getElementName();
            this.m_isTypeOrLower = false;
        }
    }

    public boolean accept(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'accept' must not be null";
        String name = namedElement.getName();
        if (this.checkName(namedElement, name)) {
            return true;
        }
        String originalName = this.getOriginalName(namedElement);
        return this.checkName(namedElement, originalName);
    }

    private boolean checkName(NamedElement namedElement, String name) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'checkName' must not be null";
        assert (name != null) : "Parameter 'name' of method 'checkName' must not be null";
        if (namedElement instanceof JavaMethod) {
            JavaMethod javaMethod = (JavaMethod)namedElement;
            String methodSignature = javaMethod.getFullyQualifiedNamePart();
            name = Signature.getQualifier((String)name) + "." + this.adaptSonargraphMethodSignatureToEclipse(methodSignature);
        }
        return ((String)name).equals(this.m_javaElementName);
    }

    private String getOriginalName(NamedElement element) {
        StringBuilder builder = new StringBuilder();
        if (!this.m_isTypeOrLower) {
            builder.append("./");
        }
        this.appendOriginalFullyQualifiedNamePart(element.getOriginal(), builder);
        return builder.toString();
    }

    private void appendOriginalFullyQualifiedNamePart(NamedElement element, StringBuilder builder) {
        assert (builder != null) : "Parameter 'builder' of method 'appendFullyQualifiedNamePart' must not be null";
        NamedElement parent = element.getParent();
        if (parent != null && !((parent = parent.getOriginal()) instanceof RootDirectoryPath)) {
            if (this.m_isTypeOrLower && parent instanceof JavaInternalCompilationUnit) {
                parent = parent.getParent().getOriginal();
            }
            this.appendOriginalFullyQualifiedNamePart(parent, builder);
            if (this.m_isTypeOrLower) {
                builder.append('.');
            } else {
                builder.append('/');
            }
        }
        builder.append(Element.escapeSpecialCharacters((String)element.getFullyQualifiedNamePart()));
    }

    private String adaptSonargraphMethodSignatureToEclipse(String methodSignature) {
        assert (methodSignature != null) : "Parameter 'methodSignature' of method 'adaptSonargraphMethodSignatureToEclipse' must not be null";
        methodSignature = methodSignature.replaceAll(", ", ",");
        return methodSignature;
    }
}

