/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleMappingInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathMappingInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathType;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemMappingInfo;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.PluginConstants;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipsePluginMessageCause;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaLanguage;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import de.schlichtherle.truezip.file.TFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EclipseWorkspaceUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(EclipseWorkspaceUtils.class);

    private EclipseWorkspaceUtils() {
    }

    public static List<Pair<String, TFile>> getProjectDirectories(List<IProject> projects) {
        assert (projects != null && projects.size() > 0) : "Parameter 'projects' of method 'getProjectDirectories' must not be empty";
        ArrayList<Pair> projectDirs = new ArrayList<Pair>();
        for (IProject project : projects) {
            if (!project.isOpen() || project.getLocation() == null) continue;
            projectDirs.add(new Pair((Object)project.getName(), (Object)new TFile(project.getLocation().toFile()).getNormalizedAbsoluteFile()));
        }
        return Collections.unmodifiableList(projectDirs);
    }

    public static List<IProject> getJavaProjects() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        List<IProject> projects = Arrays.asList(workspaceRoot.getProjects());
        return Collections.unmodifiableList(projects.stream().filter(p -> p.isAccessible() && EclipseWorkspaceUtils.hasJavaNature(p)).collect(Collectors.toList()));
    }

    public static boolean hasJavaNature(IProject project) {
        assert (project != null) : "Parameter 'project' of method 'hasJavaNature' must not be null";
        try {
            return project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException ex) {
            LOGGER.error("Failed to check for Java nature of project '" + project.getName() + "'", (Throwable)ex);
            return false;
        }
    }

    public static IJavaProject getJavaProject(IProject project) {
        assert (project != null) : "Parameter 'project' of method 'getJavaProject' must not be null";
        if (EclipseWorkspaceUtils.hasJavaNature(project)) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static List<IProject> getActiveSonargraphProjects() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        List<IProject> projects = Arrays.asList(workspaceRoot.getProjects());
        return Collections.unmodifiableList(projects.stream().filter(p -> p.isOpen() && EclipseWorkspaceUtils.isSonargraphResource((IResource)p)).collect(Collectors.toList()));
    }

    public static DynamicSystemInfo convertToDynamicInfo(SystemMappingInfo systemMappingInfo) {
        assert (systemMappingInfo != null) : "Parameter 'systemMappingInfo' of method 'convertToDynamicInfo' must not be null";
        DynamicSystemInfo result = new DynamicSystemInfo(systemMappingInfo.getId(), systemMappingInfo.getName(), systemMappingInfo.getDescription());
        for (ModuleMappingInfo next : systemMappingInfo.getModuleMappings()) {
            if (!next.isMappingDefined()) continue;
            ModuleInfo sgModule = (ModuleInfo)next.getSonargraphModule().get();
            ModuleInfo module = new ModuleInfo(sgModule.getId(), sgModule.getName(), sgModule.getDescription(), sgModule.getLanguage(), sgModule.getModuleType());
            next.getRootPaths(r -> r.getRoot().getType() == RootPathType.STANDARD && r.getStatus().containsAll(EnumSet.of(RootPathMappingInfo.MappingStatus.EXTERNAL, RootPathMappingInfo.MappingStatus.ACTIVE))).forEach(rm -> module.addRootPath(rm.getRoot()));
            next.getRootPaths(r -> r.getRoot().getType() == RootPathType.NON_STANDARD && r.getStatus().containsAll(EnumSet.of(RootPathMappingInfo.MappingStatus.EXTERNAL, RootPathMappingInfo.MappingStatus.INTERNAL, RootPathMappingInfo.MappingStatus.ACTIVE))).forEach(rm -> module.addRootPath(rm.getRoot()));
            result.addModule(module);
        }
        return result;
    }

    public static SystemMappingInfo reduceSystemMappingInfo(SystemMappingInfo systemMappingInfo) {
        assert (systemMappingInfo != null) : "Parameter 'systemMappingInfo' of method 'reduceSystemMappingInfo' must not be null";
        ArrayList<ModuleMappingInfo> projects = new ArrayList<ModuleMappingInfo>();
        for (ModuleMappingInfo next : systemMappingInfo.getModuleMappings()) {
            if (!next.isMappingDefined()) continue;
            ModuleMappingInfo copy = EclipseWorkspaceUtils.reduceModuleMapping(next);
            projects.add(copy);
        }
        SystemMappingInfo reduced = new SystemMappingInfo(systemMappingInfo.getId(), systemMappingInfo.getName(), systemMappingInfo.getDescription(), projects);
        return reduced;
    }

    private static ModuleMappingInfo reduceModuleMapping(ModuleMappingInfo moduleMapping) {
        assert (moduleMapping != null) : "Parameter 'moduleMapping' of method 'reduceModuleMapping' must not be null";
        ModuleInfo module = moduleMapping.getSonargraphModule().orElse(null);
        ModuleInfo project = moduleMapping.getExternalProject().orElse(null);
        ModuleMappingInfo reducedMapping = new ModuleMappingInfo(module, project);
        for (RootPathMappingInfo rootPathMapping : moduleMapping.getRootPaths(r -> r.getStatus().contains(RootPathMappingInfo.MappingStatus.ACTIVE))) {
            ModuleInfo parent = rootPathMapping.getParent() == module ? module : project;
            RootPathInfo root = rootPathMapping.getRoot().copy();
            reducedMapping.addRootPathMapping(new RootPathMappingInfo((Object)parent, root, rootPathMapping.getStatus()));
        }
        return reducedMapping;
    }

    public static List<ModuleInfo> getJavaWorkspaceProjectsAsModuleInfos() {
        ArrayList<ModuleInfo> projects = new ArrayList<ModuleInfo>();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = workspaceRoot.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject next = iProjectArray[n2];
            if (EclipseWorkspaceUtils.hasJavaNature(next)) {
                if (next.isAccessible()) {
                    try {
                        projects.add(EclipseWorkspaceUtils.convertToModuleInfo(next));
                    }
                    catch (CoreException ex) {
                        LOGGER.error("Failed to process project '" + next.getName() + "'", (Throwable)ex);
                    }
                } else {
                    LOGGER.debug("Ignoring not accessible project '" + next.getName() + "'");
                }
            }
            ++n2;
        }
        return Collections.unmodifiableList(projects);
    }

    public static Optional<IFile> getLocationForFile(TFile file) {
        try {
            assert (file != null) : "Parameter 'file' of method 'getLocationForFile' must not be null";
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toURI());
            if (files.length == 0) {
                return Optional.empty();
            }
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile next = iFileArray[n2];
                if (next.exists()) {
                    return Optional.of(next);
                }
                ++n2;
            }
            return Optional.empty();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to get location for file '" + (file == null ? "null" : file.getAbsolutePath()) + "'", t);
            return Optional.empty();
        }
    }

    public static Optional<IFolder> getLocationForDirectory(TFile dir) {
        assert (dir != null) : "Parameter 'dir' of method 'getLocationForDirectory' must not be null";
        try {
            IContainer[] directories;
            IContainer[] iContainerArray = directories = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(dir.toURI());
            int n = directories.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer directory = iContainerArray[n2];
                if (directory instanceof IFolder && directory.exists()) {
                    return Optional.of((IFolder)directory);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get location for directory: {}, uri: ", (Object)dir.getAbsoluteFile(), (Object)dir.toURI());
            LOGGER.warn(e.getMessage());
        }
        return Optional.empty();
    }

    public static Optional<TFile> getFileOfResource(IResource resource) {
        assert (resource != null) : "Parameter 'resource' of method 'getFileOfResource' must not be null";
        URI locationURI = resource.getLocationURI();
        if (locationURI == null) {
            return Optional.empty();
        }
        return Optional.of(new TFile(locationURI));
    }

    public static boolean hasSonargraphNature(IProject project) {
        assert (project != null) : "Parameter 'project' of method 'isSonargraphProject' must not be null";
        try {
            return project.isOpen() && project.hasNature("com.hello2morrow.sonargraph.ide.eclipse.nature");
        }
        catch (CoreException ex) {
            LOGGER.error("Failed to check for Sonargraph nature on project '" + project.getName() + "'", (Throwable)ex);
            return false;
        }
    }

    public static ModuleInfo convertToModuleInfo(IProject eclipseProject) throws CoreException {
        assert (eclipseProject != null) : "Parameter 'eclipseProject' of method 'convertToModuleInfo' must not be null";
        IJavaProject javaProject = JavaCore.create((IProject)eclipseProject);
        ModuleInfo moduleInfo = new ModuleInfo(eclipseProject.getName(), eclipseProject.getName(), "", JavaLanguage.INSTANCE.getStandardName(), JavaModule.JavaModuleType.ECLIPSE.getStandardName());
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath outputLocation = javaProject.getOutputLocation();
        LinkedHashSet<String> outputPaths = new LinkedHashSet<String>();
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                Optional<IPath> outputPathOptional = EclipseWorkspaceUtils.getOutputPathForSource(workspaceRoot, javaProject, root, outputLocation);
                if (outputPathOptional.isPresent()) {
                    IPath path = outputPathOptional.get();
                    String absoluteOutputPath = path.isAbsolute() ? path.toString() : workspaceRoot.getFolder(path).getLocation().toString();
                    IPath src = root.getResource().getLocation();
                    TFile absoluteDir = new TFile(src.toFile());
                    moduleInfo.addRootPath(new RootPathInfo(FileUtility.getIdentifyingPath((TFile)absoluteDir), RootPathType.NON_STANDARD));
                    outputPaths.add(FileUtility.getIdentifyingPath((TFile)new TFile(absoluteOutputPath)));
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            LOGGER.warn("Cannot convert to module info", (Throwable)jme);
        }
        catch (Exception e) {
            LOGGER.error("Eclipse problem", (Throwable)e);
        }
        outputPaths.forEach(entry -> moduleInfo.addRootPath(new RootPathInfo(entry, RootPathType.STANDARD)));
        return moduleInfo;
    }

    public static String getProjectRelativePath(IPath path) {
        assert (path != null) : "Parameter 'path' of method 'getRelativePath' must not be null";
        return path.removeFirstSegments(1).toString();
    }

    public static Optional<IPath> getOutputPathForSource(IWorkspaceRoot workspaceRoot, IJavaProject project, IPackageFragmentRoot srcRoot, IPath defaultOutputLocation) throws JavaModelException {
        assert (workspaceRoot != null) : "Parameter 'workspaceRoot' of method 'getOutputPathForSource' must not be null";
        assert (project != null) : "Parameter 'project' of method 'getOutputPathForSource' must not be null";
        assert (srcRoot != null) : "Parameter 'srcRoot' of method 'getOutputPathForSource' must not be null";
        assert (defaultOutputLocation != null) : "Parameter 'defaultOutputLocation' of method 'getOutputPathForSource' must not be null";
        if (EclipseWorkspaceUtils.isSourceRootOfProject(project, srcRoot)) {
            if (srcRoot.getParent().getElementName().equals(project.getElementName())) {
                IPath individualOutputLocation = srcRoot.getResolvedClasspathEntry().getOutputLocation();
                IPath outputPath = individualOutputLocation != null ? individualOutputLocation : defaultOutputLocation;
                IPath result = workspaceRoot.getFolder(outputPath).getLocation();
                return Optional.of(result);
            }
            assert (false) : "Not expected. Root '" + srcRoot.getElementName() + "' is not child of project '" + project.getElementName() + "'";
        }
        return Optional.empty();
    }

    public static boolean isSourceRootOfProject(IJavaProject project, IPackageFragmentRoot srcRoot) throws JavaModelException {
        return srcRoot.getResource() != null && srcRoot.getKind() == 1 && srcRoot.getParent().getElementName().equals(project.getElementName());
    }

    public static boolean isSonargraphResource(IResource resource) {
        assert (resource != null) : "Parameter 'resource' of method 'isSonargraphResource' must not be null";
        if (!resource.isAccessible()) {
            return false;
        }
        try {
            return resource.getSessionProperty(PluginConstants.SONARGRAPH_RESOURCE_QUALIFIED_NAME) != null;
        }
        catch (CoreException ex) {
            LOGGER.error("Failed to check for Sonargraph resource property on '" + String.valueOf(resource.getLocation()) + "'");
            return false;
        }
    }

    public static void clearSonargraphResourceProperties(IResource root) {
        assert (root != null) : "Parameter 'root' of method 'clearSonargraphResourceProperties' must not be null";
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource instanceof IProject) {
                    if (!EclipseWorkspaceUtils.isSonargraphResource(resource)) {
                        return false;
                    }
                    resource.setSessionProperty(PluginConstants.SONARGRAPH_RESOURCE_QUALIFIED_NAME, null);
                    resource.setSessionProperty(PluginConstants.SONARGRAPH_RESOURCE_MODULE_QUALIFIED_NAME, null);
                    return true;
                }
                if (resource instanceof IFolder) {
                    resource.setSessionProperty(PluginConstants.SONARGRAPH_RESOURCE_QUALIFIED_NAME, null);
                    return true;
                }
                return !(resource instanceof IFile);
            }
        };
        try {
            root.accept(visitor);
        }
        catch (CoreException ex) {
            LOGGER.error("Failed to clear Sonargraph resource session property", (Throwable)ex);
        }
    }

    public static void addSonargraphResourceProperty(SystemMappingInfo mappingInfo) {
        assert (mappingInfo != null) : "Parameter 'mappingInfo' of method 'addSonargraphResourceProperty' must not be null";
        for (ModuleMappingInfo next : mappingInfo.getModuleMappings()) {
            assert (next.getSonargraphModule().isPresent()) : "No Sonargraph module exists in mapping '" + next.toString() + "'";
            assert (next.getExternalProject().isPresent()) : "No Eclipse project exists in mapping '" + next.toString() + "'";
            String projectName = ((ModuleInfo)next.getExternalProject().get()).getName();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project.exists()) {
                EclipseWorkspaceUtils.addSonargraphResourceProperty((IResource)project);
                EclipseWorkspaceUtils.addSonargraphModuleNameProperty(project, ((ModuleInfo)next.getSonargraphModule().get()).getName());
                for (RootPathMappingInfo root : next.getRootPaths(r -> r.getStatus().containsAll(EnumSet.of(RootPathMappingInfo.MappingStatus.EXTERNAL, RootPathMappingInfo.MappingStatus.ACTIVE)))) {
                    String path = root.getRoot().getPath();
                    Optional<IFolder> folder = EclipseWorkspaceUtils.getLocationForDirectory(new TFile(path));
                    if (folder.isPresent() && folder.get().exists()) {
                        EclipseWorkspaceUtils.addSonargraphResourceProperty((IResource)folder.get());
                        continue;
                    }
                    LOGGER.error("Mapped root path '{}' does not exist in project '{}'.", (Object)path, (Object)project.getName());
                }
                continue;
            }
            LOGGER.error("Mapped project '{}' not found", (Object)projectName);
        }
    }

    private static void addSonargraphModuleNameProperty(IProject project, String moduleName) {
        assert (project != null) : "Parameter 'project' of method 'addSonargraphModuleNameProperty' must not be null";
        assert (moduleName != null && moduleName.length() > 0) : "Parameter 'moduleName' of method 'addSonargraphModuleNameProperty' must not be empty";
        try {
            project.setSessionProperty(PluginConstants.SONARGRAPH_RESOURCE_MODULE_QUALIFIED_NAME, (Object)moduleName);
        }
        catch (CoreException ex) {
            LOGGER.error("Failed to set resource session property (module name)", (Throwable)ex);
        }
    }

    public static Optional<IProject> getProjectForModule(String moduleName) {
        assert (moduleName != null && moduleName.length() > 0) : "Parameter 'moduleName' of method 'getProjectForModule' must not be empty";
        String unescapedModuleName = Element.unescapeSpecialCharacters((String)moduleName);
        for (IProject project : EclipseWorkspaceUtils.getActiveSonargraphProjects()) {
            try {
                Object projectModuleName = project.getSessionProperty(PluginConstants.SONARGRAPH_RESOURCE_MODULE_QUALIFIED_NAME);
                LOGGER.debug("Eclipse project {} is mapped to Sonargraph module {}", (Object)project.getName(), projectModuleName);
                if (!unescapedModuleName.equals(projectModuleName)) continue;
                return Optional.of(project);
            }
            catch (CoreException ex) {
                LOGGER.error("Failed to get resource session property (module name)", (Throwable)ex);
            }
        }
        return Optional.empty();
    }

    private static void addSonargraphResourceProperty(IResource resource) {
        assert (resource != null) : "Parameter 'resource' of method 'addSonargraphResourceProperty' must not be null";
        try {
            resource.setSessionProperty(PluginConstants.SONARGRAPH_RESOURCE_QUALIFIED_NAME, (Object)Boolean.TRUE);
        }
        catch (CoreException ex) {
            LOGGER.error("Failed to set resource session property", (Throwable)ex);
        }
    }

    public static IPackageFragment getPackage(String rootDirectoryFqName, String packageName) {
        assert (rootDirectoryFqName != null && rootDirectoryFqName.length() > 0) : "Parameter 'rootDirectoryFqName' of method 'getRootDirectory' must not be empty";
        assert (packageName != null) : "Parameter 'packageName' of method 'getRootDirectoryDestination' must not be null";
        IPackageFragmentRoot packageFragmentRoot = EclipseWorkspaceUtils.getRootDirectory(rootDirectoryFqName);
        if (packageFragmentRoot == null) {
            return null;
        }
        IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(packageName);
        LOGGER.debug("Returns IPackageFragment {}", (Object)packageFragment);
        return packageFragment;
    }

    public static IPackageFragmentRoot getRootDirectory(IPackageFragment packageFragment) {
        IJavaElement parent;
        assert (packageFragment != null) : "Parameter 'packageFragment' of method 'getRootDirectory' must not be null";
        IPackageFragment current = packageFragment;
        while ((current = (parent = current.getParent())) instanceof IPackageFragment && !(parent instanceof IPackageFragmentRoot)) {
        }
        if (parent instanceof IPackageFragmentRoot) {
            return (IPackageFragmentRoot)parent;
        }
        LOGGER.warn("Failed to determine Eclipse root directory for '{}'", (Object)packageFragment);
        return null;
    }

    public static IPackageFragmentRoot getRootDirectory(String rootDirectoryFqName) {
        assert (rootDirectoryFqName != null && rootDirectoryFqName.length() > 0) : "Parameter 'rootDirectoryFqName' of method 'getRootDirectory' must not be empty";
        LOGGER.debug("getRootDirectory() {}", (Object)rootDirectoryFqName);
        int firstColon = rootDirectoryFqName.indexOf(":");
        int lastColon = rootDirectoryFqName.lastIndexOf(":");
        LOGGER.debug("firstColon, second colon: {}, {}", (Object)firstColon, (Object)lastColon);
        if (firstColon == -1 || firstColon >= lastColon) {
            LOGGER.warn("Malformed rootDirectoryFqName: {}", (Object)rootDirectoryFqName);
            return null;
        }
        String moduleName = rootDirectoryFqName.substring(firstColon + 1, lastColon);
        String rootDirectoryPath = rootDirectoryFqName.substring(lastColon + 1);
        LOGGER.debug("Extracted project name and rootDirectoryPath: {}, {}", (Object)moduleName, (Object)rootDirectoryPath);
        Optional<IProject> eclipseProject = EclipseWorkspaceUtils.getProjectForModule(moduleName);
        if (!eclipseProject.isPresent()) {
            LOGGER.warn("Failed to determine Eclipse project for Sonargraph module '{}'", (Object)moduleName);
            return null;
        }
        LOGGER.debug("Eclipse project is {}", (Object)eclipseProject.get());
        IJavaProject javaProject = JavaCore.create((IProject)eclipseProject.get());
        LOGGER.debug("Eclipse java project is {}", (Object)javaProject);
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                LOGGER.debug("Checking eclipse IPackageFragmentRoot {}", (Object)packageFragmentRoot);
                IResource resource = packageFragmentRoot.getResource();
                if (resource != null) {
                    LOGGER.debug("Checking eclipse IResource {}", (Object)resource);
                    IPath projectRelativePath = resource.getProjectRelativePath();
                    if (projectRelativePath != null) {
                        LOGGER.debug("Checking eclipse projectRelativePath {}", (Object)projectRelativePath);
                        if (rootDirectoryPath.endsWith(projectRelativePath.toString())) {
                            LOGGER.debug("Found packageFragmentRoot {} for rootDirectoryFqName {}", (Object)packageFragmentRoot, (Object)rootDirectoryFqName);
                            return packageFragmentRoot;
                        }
                    }
                }
                ++n2;
            }
            LOGGER.warn("Failed to determine Eclipse root directory for {}", (Object)rootDirectoryFqName);
        }
        catch (JavaModelException e) {
            LOGGER.warn("Cannot get root directory destination", (Throwable)e);
        }
        return null;
    }

    public static List<IPackageFragment> getSubPackages(IPackageFragment packageFragment) throws JavaModelException {
        assert (packageFragment != null) : "Parameter 'packageFragment' of method 'getSubPackages' must not be null";
        assert (packageFragment.exists()) : "Parameter 'packageFragment' of method 'getSubPackages' must exist";
        if (!packageFragment.hasSubpackages()) {
            return Collections.emptyList();
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)packageFragment.getParent();
        String prefix = packageFragment.getElementName() + ".";
        ArrayList<IPackageFragment> subPackages = new ArrayList<IPackageFragment>();
        int prefixLength = prefix.length();
        IJavaElement[] iJavaElementArray = root.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement next = iJavaElementArray[n2];
            if (next instanceof IPackageFragment && next.getElementName().startsWith(prefix) && next.getElementName().lastIndexOf(46) == prefixLength - 1) {
                subPackages.add((IPackageFragment)next);
            }
            ++n2;
        }
        return subPackages;
    }

    public static List<IPackageFragment> getSubPackagesRecursively(IPackageFragment packageFragment) throws JavaModelException {
        assert (packageFragment != null) : "Parameter 'packageFragment' of method 'getSubPackagesRecursively' must not be null";
        if (!packageFragment.hasSubpackages()) {
            return Collections.emptyList();
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)packageFragment.getParent();
        String prefix = packageFragment.getElementName() + ".";
        ArrayList<IPackageFragment> subPackages = new ArrayList<IPackageFragment>();
        IJavaElement[] iJavaElementArray = root.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement next = iJavaElementArray[n2];
            if (next instanceof IPackageFragment && next.getElementName().startsWith(prefix)) {
                subPackages.add((IPackageFragment)next);
            }
            ++n2;
        }
        return subPackages;
    }

    public static IPackageFragment getExistingPackage(IPackageFragment packageFragment, String childName) throws JavaModelException {
        assert (packageFragment != null) : "Parameter 'packageFragment' of method 'getPackage' must not be null";
        assert (childName != null && childName.length() > 0) : "Parameter 'childName' of method 'getPackage' must not be empty";
        String targetName = packageFragment.getElementName() + "." + childName;
        for (IPackageFragment next : EclipseWorkspaceUtils.getSubPackages(packageFragment)) {
            if (!next.getElementName().equals(targetName)) continue;
            return next;
        }
        return null;
    }

    public static IPackageFragment getPackage(IPackageFragment parentPackage, String child) {
        assert (parentPackage != null) : "Parameter 'parentPackage' of method 'getPackage' must not be null";
        assert (child != null && child.length() > 0) : "Parameter 'child' of method 'getPackage' must not be empty";
        IJavaElement parentRoot = parentPackage.getParent();
        assert (parentRoot != null && parentRoot instanceof IPackageFragmentRoot) : "Unexpected class in method 'getPackage': " + String.valueOf(parentRoot);
        IPackageFragmentRoot root = (IPackageFragmentRoot)parentRoot;
        return EclipseWorkspaceUtils.getPackage(root, parentPackage.getElementName() + "." + child);
    }

    public static IPackageFragment getPackage(IPackageFragmentRoot root, String packageName) {
        assert (root != null) : "Parameter 'root' of method 'getPackage' must not be null";
        assert (packageName != null) : "Parameter 'packageName' of method 'getPackage' must not be null";
        return root.getPackageFragment(packageName);
    }

    public static String getLastPackageNamePart(IPackageFragment packageFragment) {
        assert (packageFragment != null) : "Parameter 'packageFragment' of method 'getLastPackageNamePart' must not be null";
        return EclipseWorkspaceUtils.getLastPackageNamePart(packageFragment.getElementName());
    }

    public static String getLastPackageNamePart(String packageName) {
        String[] parts = packageName.split("\\.");
        assert (parts.length > 0) : "packageFragment must contain at least one part";
        return parts[parts.length - 1];
    }

    public static boolean isTopLevelPackage(IPackageFragment packageFragment) {
        assert (packageFragment != null) : "Parameter 'packageFragment' of method 'isTopLevelPackage' must not be null";
        return packageFragment.getElementName() == "" || !packageFragment.getElementName().contains(".");
    }

    public static String getNameOfParentPackage(IPackageFragment packageFragment) {
        assert (packageFragment != null) : "Parameter 'packageFragment' of method 'getNameOfParentPackage' must not be null";
        if (EclipseWorkspaceUtils.isTopLevelPackage(packageFragment)) {
            return null;
        }
        int end = packageFragment.getElementName().lastIndexOf(".");
        return packageFragment.getElementName().substring(0, end);
    }

    private static String calculateRelativePath(String path, String basePath) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'calculateRelativePath' must not be empty";
        assert (basePath != null && basePath.length() > 0) : "Parameter 'basePath' of method 'calculateRelativePath' must not be empty";
        return FileUtility.calculateRelativePath((TFile)new TFile(path), (TFile)new TFile(basePath));
    }

    private static OperationResult addSystemNameToBuilder(IProject sonargraphProject, TFile systemDirectory, SystemMappingInfo mappingInfo) {
        assert (sonargraphProject != null) : "Parameter 'sonargraphProject' of method 'addSystemNameToBuilder' must not be null";
        assert (systemDirectory != null) : "Parameter 'systemDirectory' of method 'addSystemNameToBuilder' must not be null";
        assert (mappingInfo != null) : "Parameter 'mappingInfo' of method 'addSystemNameToBuilder' must not be null";
        OperationResult result = new OperationResult("Adjusting build configuration of Sonargraph refresh project");
        try {
            IProjectDescription projectDescription = sonargraphProject.getDescription();
            ICommand[] commands = projectDescription.getBuildSpec();
            ICommand builderCommand = null;
            ICommand[] iCommandArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand command = iCommandArray[n2];
                if (command.getBuilderName().equalsIgnoreCase("com.hello2morrow.sonargraph.ide.eclipse.builder")) {
                    builderCommand = command;
                    break;
                }
                ++n2;
            }
            if (builderCommand == null) {
                result.addWarning((OperationResult.IMessageCause)EclipsePluginMessageCause.MISSING_BUILDER, "No builder 'com.hello2morrow.sonargraph.ide.eclipse.builder' found for project '" + sonargraphProject.getName() + "'", new Object[0]);
                return result;
            }
            LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
            String relativePath = EclipseWorkspaceUtils.calculateRelativePath(systemDirectory.getNormalizedAbsolutePath(), sonargraphProject.getLocation().toFile().getAbsolutePath());
            if (!builderCommand.getArguments().containsKey(relativePath)) {
                args.put(relativePath, Iso8601DateFormat.formatDateAndTimeForUniversalTimezone((Date)new Date()));
                args.putAll(builderCommand.getArguments());
                builderCommand.setArguments(args);
                projectDescription.setBuildSpec(commands);
                sonargraphProject.setDescription(projectDescription, null);
            }
        }
        catch (CoreException ex) {
            result.addError((OperationResult.IMessageCause)EclipsePluginMessageCause.GENERIC, "Failed to process project's build configuration", new Object[]{ex});
        }
        return result;
    }

    public static List<String> getSonargraphSystemPaths() {
        List<IProject> javaProjects = EclipseWorkspaceUtils.getJavaProjects();
        List sonargraphProjects = javaProjects.stream().filter(p -> EclipseWorkspaceUtils.hasSonargraphNature(p)).collect(Collectors.toList());
        HashMap<String, String> systemPathsToDate = new HashMap<String, String>();
        for (IProject next : sonargraphProjects) {
            try {
                IProjectDescription projectDescription = next.getDescription();
                ICommand[] commands = projectDescription.getBuildSpec();
                ICommand builderCommand = null;
                ICommand[] iCommandArray = commands;
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    ICommand command = iCommandArray[n2];
                    if (command.getBuilderName().equals("com.hello2morrow.sonargraph.ide.eclipse.builder")) {
                        builderCommand = command;
                        break;
                    }
                    ++n2;
                }
                if (builderCommand != null) {
                    for (Map.Entry nextEntry : builderCommand.getArguments().entrySet()) {
                        TFile systemDirectory;
                        String path = (String)nextEntry.getKey();
                        String dateString = (String)nextEntry.getValue();
                        if (path == null || path.trim().isEmpty()) continue;
                        String existingDateString = (String)systemPathsToDate.get(path);
                        if (existingDateString == null) {
                            TFile systemDirectory2 = new TFile(next.getLocation().toFile(), path);
                            if (!systemDirectory2.exists() || !systemDirectory2.isDirectory()) continue;
                            systemPathsToDate.put(systemDirectory2.getNormalizedAbsolutePath(), dateString);
                            continue;
                        }
                        Date date = Iso8601DateFormat.parseDateAndTimeForUniversalTimezone((String)dateString);
                        Date existingDate = Iso8601DateFormat.parseDateAndTimeForUniversalTimezone((String)existingDateString);
                        if (date == null || existingDate == null || date.getTime() <= existingDate.getTime() || !(systemDirectory = new TFile(next.getLocation().toFile(), path)).exists() || !systemDirectory.isDirectory()) continue;
                        systemPathsToDate.put(systemDirectory.getNormalizedAbsolutePath(), dateString);
                    }
                    continue;
                }
                LOGGER.warn("No Sonargraph builder registered for project " + next.getName());
            }
            catch (CoreException ex) {
                LOGGER.error("Failed to process builder configs of Sonargraph projects", (Throwable)ex);
                return Collections.emptyList();
            }
        }
        TreeMap datesToSystemPaths = new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s2.compareTo(s1);
            }
        });
        systemPathsToDate.entrySet().stream().forEach(e -> {
            String string = datesToSystemPaths.put((String)e.getValue(), (String)e.getKey());
        });
        return new ArrayList<String>(datesToSystemPaths.values());
    }

    private static IStatus addSonargraphNature(IProject project) throws CoreException {
        assert (project != null) : "Parameter 'project' of method 'addSonargraphNature' must not be null";
        LOGGER.info("Adding Sonargraph nature to project {}", (Object)project);
        IProjectDescription description = project.getDescription();
        Object[] natures = description.getNatureIds();
        LOGGER.info("Existing natures are {}", (Object)Arrays.toString(natures));
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "com.hello2morrow.sonargraph.ide.eclipse.nature";
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateNatureSet(newNatures);
        if (status.getCode() == 0) {
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
        return status;
    }

    public static OperationResult addSonargraphNature(TFile systemDirectory, SystemMappingInfo systemMappingInfo) {
        assert (systemMappingInfo != null) : "Parameter 'systemMappingInfo' of method 'addSonargraphNatures' must not be null";
        OperationResult result = new OperationResult("Adding Sonargraph Nature and Builders to projects");
        ArrayList<IProject> projects = new ArrayList<IProject>();
        for (ModuleMappingInfo mapping : systemMappingInfo.getModuleMappings()) {
            if (!mapping.isMappingDefined()) continue;
            Optional projectInfoOpt = mapping.getExternalProject();
            assert (projectInfoOpt.isPresent()) : "Missing Eclipse project";
            String projectName = ((ModuleInfo)projectInfoOpt.get()).getName();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (!project.isAccessible()) {
                LOGGER.error("Project '{}' is not accessible", (Object)project.getName());
                continue;
            }
            try {
                if (!project.hasNature("com.hello2morrow.sonargraph.ide.eclipse.nature")) {
                    IStatus status = EclipseWorkspaceUtils.addSonargraphNature(project);
                    if (status.getCode() == 2) {
                        result.addWarning((OperationResult.IMessageCause)EclipsePluginMessageCause.FAILED_TO_ADD_NATURE, status.getMessage(), new Object[0]);
                    } else if (status.getCode() == 4) {
                        result.addError((OperationResult.IMessageCause)EclipsePluginMessageCause.FAILED_TO_ADD_NATURE, status.getMessage(), new Object[0]);
                    }
                }
                EclipseWorkspaceUtils.addSystemNameToBuilder(project, systemDirectory, systemMappingInfo);
                projects.add(project);
            }
            catch (CoreException ex) {
                result.addError((OperationResult.IMessageCause)EclipsePluginMessageCause.FAILED_TO_ADD_NATURE, (Throwable)ex, "Failed to add Sonargraph nature to project '" + project.getName() + "'", new Object[0]);
                return result;
            }
        }
        return result;
    }

    public static IPackageFragment getPackage(IFolder folder) {
        assert (folder != null) : "Parameter 'folder' of method 'getPackage' must not be null";
        IJavaElement element = JavaCore.create((IFolder)folder);
        if (element instanceof IPackageFragment) {
            return (IPackageFragment)element;
        }
        return null;
    }

    public static ICompilationUnit getCompilationUnit(IFile file) {
        assert (file != null) : "Parameter 'file' of method 'getCompilationUnit' must not be null";
        IJavaElement element = JavaCore.create((IFile)file);
        if (element instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }
}

