/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.model;

import com.hello2morrow.sonargraph.client.eclipse.application.EclipseRelease;
import org.junit.Assert;
import org.junit.Test;

public class EclipseReleaseTest {
    public static final String LUNA_2 = "4.4.2.v20150204-1700";
    public static final String MARS_2 = "4.5.2";
    public static final String NEON_3 = "4.6.3.v20170301-0400";
    public static final String OXYGEN_2 = "4.7.2.v20171130-0510";
    public static final String OXYGEN_3 = "4.7.3.v20180330-0640";
    public static final String PHOTON = "4.8.0.v20180611-0500";
    public static final String _201809 = "4.9.0.v20180906-0745";

    @Test
    public void testIsBefore() {
        Assert.assertTrue((String)"Old eclipse releases are before 4.7.3.v20180330-0640", (boolean)EclipseRelease.TOO_OLD.isBefore(EclipseRelease.OXYGEN_3));
        Assert.assertTrue((String)"Luna is before Mars", (boolean)EclipseRelease.LUNA.isBefore(EclipseRelease.MARS));
        Assert.assertTrue((String)"Mars is before Neon", (boolean)EclipseRelease.MARS.isBefore(EclipseRelease.NEON));
        Assert.assertTrue((String)"Neon is before Oxygen", (boolean)EclipseRelease.NEON.isBefore(EclipseRelease.OXYGEN_3));
        Assert.assertTrue((String)"Oxygen2 is before Oxygen3", (boolean)EclipseRelease.OXYGEN_2.isBefore(EclipseRelease.OXYGEN_3));
        Assert.assertTrue((String)"Oxygen is before Photon", (boolean)EclipseRelease.OXYGEN_3.isBefore(EclipseRelease.PHOTON));
        Assert.assertTrue((String)"Photon is before 2018-09", (boolean)EclipseRelease.PHOTON.isBefore(EclipseRelease._201809));
        Assert.assertTrue((String)"2018-09 is before next release", (boolean)EclipseRelease._201809.isBefore(EclipseRelease.NEXT_RELEASE));
        Assert.assertFalse((String)"Luna is not before old eclipse releases ", (boolean)EclipseRelease.OXYGEN_3.isBefore(EclipseRelease.TOO_OLD));
        Assert.assertFalse((String)"Mars is not before Luna", (boolean)EclipseRelease.MARS.isBefore(EclipseRelease.LUNA));
        Assert.assertFalse((String)"Neon is not before Mars", (boolean)EclipseRelease.NEON.isBefore(EclipseRelease.MARS));
        Assert.assertFalse((String)"Oxygen is not before Neon", (boolean)EclipseRelease.OXYGEN_3.isBefore(EclipseRelease.NEON));
        Assert.assertFalse((String)"Photon is not before Oxygen", (boolean)EclipseRelease.PHOTON.isBefore(EclipseRelease.OXYGEN_3));
        Assert.assertFalse((String)"2018-09 is not before Photon", (boolean)EclipseRelease._201809.isBefore(EclipseRelease.PHOTON));
        Assert.assertFalse((String)"Next release is not before 2018-09", (boolean)EclipseRelease.NEXT_RELEASE.isBefore(EclipseRelease._201809));
        Assert.assertFalse((boolean)EclipseRelease.TOO_OLD.isBefore(EclipseRelease.TOO_OLD));
        Assert.assertFalse((boolean)EclipseRelease.LUNA.isBefore(EclipseRelease.LUNA));
        Assert.assertFalse((boolean)EclipseRelease.MARS.isBefore(EclipseRelease.MARS));
        Assert.assertFalse((boolean)EclipseRelease.NEON.isBefore(EclipseRelease.NEON));
        Assert.assertFalse((boolean)EclipseRelease.OXYGEN_3.isBefore(EclipseRelease.OXYGEN_3));
        Assert.assertFalse((boolean)EclipseRelease.PHOTON.isBefore(EclipseRelease.PHOTON));
        Assert.assertFalse((boolean)EclipseRelease._201809.isBefore(EclipseRelease._201809));
        Assert.assertFalse((boolean)EclipseRelease.NEXT_RELEASE.isBefore(EclipseRelease.NEXT_RELEASE));
    }

    @Test
    public void testIsAfter() {
        Assert.assertTrue((String)"Luna is after old eclipse releases ", (boolean)EclipseRelease.OXYGEN_3.isAfter(EclipseRelease.TOO_OLD));
        Assert.assertTrue((String)"Mars is after Luna", (boolean)EclipseRelease.MARS.isAfter(EclipseRelease.LUNA));
        Assert.assertTrue((String)"Neon is after Mars", (boolean)EclipseRelease.NEON.isAfter(EclipseRelease.MARS));
        Assert.assertTrue((String)"Oxygen3 is after Oxygen2", (boolean)EclipseRelease.OXYGEN_3.isAfter(EclipseRelease.OXYGEN_2));
        Assert.assertTrue((String)"Oxygen is after Neon", (boolean)EclipseRelease.OXYGEN_3.isAfter(EclipseRelease.NEON));
        Assert.assertTrue((String)"Photon is after Oxygen", (boolean)EclipseRelease.PHOTON.isAfter(EclipseRelease.OXYGEN_3));
        Assert.assertTrue((String)"2018-09 is after Photon", (boolean)EclipseRelease._201809.isAfter(EclipseRelease.PHOTON));
        Assert.assertTrue((String)"Next release is after 2018-09", (boolean)EclipseRelease.NEXT_RELEASE.isAfter(EclipseRelease._201809));
        Assert.assertFalse((String)"Old eclipse releases are not after Luna", (boolean)EclipseRelease.TOO_OLD.isAfter(EclipseRelease.OXYGEN_2));
        Assert.assertFalse((String)"Luna is not after Mars", (boolean)EclipseRelease.LUNA.isAfter(EclipseRelease.MARS));
        Assert.assertFalse((String)"Mars is not after Neon", (boolean)EclipseRelease.MARS.isAfter(EclipseRelease.NEON));
        Assert.assertFalse((String)"Neon is not after Oxygen", (boolean)EclipseRelease.NEON.isAfter(EclipseRelease.OXYGEN_3));
        Assert.assertFalse((String)"Oxygen is not after Photon", (boolean)EclipseRelease.OXYGEN_3.isAfter(EclipseRelease.PHOTON));
        Assert.assertFalse((String)"Photon is not after 2018-09", (boolean)EclipseRelease.PHOTON.isAfter(EclipseRelease._201809));
        Assert.assertFalse((String)"2018-09 is not after next release", (boolean)EclipseRelease._201809.isAfter(EclipseRelease.NEXT_RELEASE));
        Assert.assertFalse((boolean)EclipseRelease.TOO_OLD.isAfter(EclipseRelease.TOO_OLD));
        Assert.assertFalse((boolean)EclipseRelease.LUNA.isAfter(EclipseRelease.LUNA));
        Assert.assertFalse((boolean)EclipseRelease.MARS.isAfter(EclipseRelease.MARS));
        Assert.assertFalse((boolean)EclipseRelease.NEON.isAfter(EclipseRelease.NEON));
        Assert.assertFalse((boolean)EclipseRelease.OXYGEN_3.isAfter(EclipseRelease.OXYGEN_3));
        Assert.assertFalse((boolean)EclipseRelease.PHOTON.isAfter(EclipseRelease.PHOTON));
        Assert.assertFalse((boolean)EclipseRelease._201809.isAfter(EclipseRelease._201809));
        Assert.assertFalse((boolean)EclipseRelease.NEXT_RELEASE.isAfter(EclipseRelease.NEXT_RELEASE));
    }

    @Test
    public void testIsPhotonOrLater() {
        Assert.assertFalse((String)"Old eclipse releases aren't Photon or later", (boolean)EclipseRelease.TOO_OLD.isPhotonOrLater());
        Assert.assertFalse((String)"Luna isn't Photon or later", (boolean)EclipseRelease.LUNA.isPhotonOrLater());
        Assert.assertFalse((String)"Mars isn't Photon or later", (boolean)EclipseRelease.MARS.isPhotonOrLater());
        Assert.assertFalse((String)"Neon isn't Photon or later", (boolean)EclipseRelease.NEON.isPhotonOrLater());
        Assert.assertFalse((String)"Oxygen isn't Photon or later", (boolean)EclipseRelease.OXYGEN_3.isPhotonOrLater());
        Assert.assertTrue((String)"Photon is Photon or later", (boolean)EclipseRelease.PHOTON.isPhotonOrLater());
        Assert.assertTrue((String)"201809 is Photon or later", (boolean)EclipseRelease._201809.isPhotonOrLater());
        Assert.assertTrue((String)"Next eclipse release will be Photon or later", (boolean)EclipseRelease.NEXT_RELEASE.isPhotonOrLater());
    }

    @Test
    public void testIsSupported() {
        Assert.assertFalse((String)"Old eclipse releases aren't supported", (boolean)EclipseRelease.TOO_OLD.isSupported());
        Assert.assertFalse((String)"Luna is not supported", (boolean)EclipseRelease.LUNA.isSupported());
        Assert.assertFalse((String)"Mars is not supported", (boolean)EclipseRelease.MARS.isSupported());
        Assert.assertFalse((String)"Neon is not supported", (boolean)EclipseRelease.NEON.isSupported());
        Assert.assertFalse((String)"Oxygen2 is not supported", (boolean)EclipseRelease.OXYGEN_2.isSupported());
        Assert.assertTrue((String)"Oxygen3 is supported", (boolean)EclipseRelease.OXYGEN_3.isSupported());
        Assert.assertTrue((String)"Photon is supported", (boolean)EclipseRelease.PHOTON.isSupported());
        Assert.assertTrue((String)"201809 is supported", (boolean)EclipseRelease._201809.isSupported());
        Assert.assertFalse((String)"Next eclipse release is not supported yet", (boolean)EclipseRelease.NEXT_RELEASE.isSupported());
    }

    @Test
    public void testParse() {
        Assert.assertEquals((Object)EclipseRelease.LUNA, (Object)EclipseRelease.parse((String)LUNA_2));
        Assert.assertEquals((Object)EclipseRelease.MARS, (Object)EclipseRelease.parse((String)MARS_2));
        Assert.assertEquals((Object)EclipseRelease.NEON, (Object)EclipseRelease.parse((String)NEON_3));
        Assert.assertEquals((Object)EclipseRelease.OXYGEN_2, (Object)EclipseRelease.parse((String)OXYGEN_2));
        Assert.assertEquals((Object)EclipseRelease.OXYGEN_3, (Object)EclipseRelease.parse((String)OXYGEN_3));
        Assert.assertEquals((Object)EclipseRelease.PHOTON, (Object)EclipseRelease.parse((String)PHOTON));
        Assert.assertEquals((Object)EclipseRelease._201809, (Object)EclipseRelease.parse((String)_201809));
    }
}

