/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs.marker;

import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.marker.AbstractCreateMarkerJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.marker.DeleteAllMarkersJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.IIssueToMarkerMap;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.ide.eclipse.model.status.ISonargraphStatusProvider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;

public final class FinishedAnalysisJob
extends AbstractSonargraphEclipseJob {
    private final IIssueToMarkerMap m_issueToMarkerMap;

    public FinishedAnalysisJob(IEventBroker eventBroker, ISoftwareSystemProvider provider, IIssueToMarkerMap issueToMarkerMap) {
        super(eventBroker, provider, "Finish Analysis Job", JobType.BACKGROUND, 50, AbstractSonargraphEclipseJob.Scheduling.SEQUENTIALLY);
        assert (issueToMarkerMap != null) : "Parameter 'issueToMarkerMap' of method 'FinishedAnalysisJob' must not be null";
        this.m_issueToMarkerMap = issueToMarkerMap;
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition getPrecondition() {
        return AbstractSonargraphEclipseJob.Precondition.OPENED_SOFTWARE_SYSTEM;
    }

    @Override
    protected List<Class<?>> getJobClassesThatMakeThisObsolete() {
        return Arrays.asList(AbstractCreateMarkerJob.class, DeleteAllMarkersJob.class);
    }

    @Override
    protected IStatus runInWorkspaceInternal(IProgressMonitor monitor) throws Exception {
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        int errorCount = this.m_issueToMarkerMap.getNumberOfErrors();
        int warningCount = this.m_issueToMarkerMap.getNumberOfWarnings();
        eventData.put(ISonargraphStatusProvider.Property.ERROR_WARNING_COUNT.name(), new StrictPair((Object)errorCount, (Object)warningCount));
        ISonargraphStatusProvider.SonargraphStatus status = errorCount == 0 && warningCount == 0 ? ISonargraphStatusProvider.SonargraphStatus.RESULTS_PRESENT_OK : ISonargraphStatusProvider.SonargraphStatus.RESULTS_PRESENT_WITH_ISSUES;
        this.postStatusEvent(status, eventData);
        return Status.OK_STATUS;
    }
}

