/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs.diff;

import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.diff.SetBaselineCommand;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.EclipseWorkerContext;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ISonargraphSetBaselineJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.JobsCommandResultConsumer;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;

public final class SetBaselineJob
extends AbstractSonargraphEclipseJob
implements ISonargraphSetBaselineJob {
    private final TFile m_baselineReport;
    private final BaselineType m_baselineType;
    private final ISonargraphEclipsePlugin m_plugin;

    public SetBaselineJob(IEventBroker eventBroker, ISonargraphEclipsePlugin plugin, TFile baselineReport, BaselineType baselineType) {
        super(eventBroker, plugin.getSoftwareSystemProvider(), "Create Baseline and Compute System Diff", JobType.PROVIDES_PROGESS, 40);
        assert (baselineReport != null) : "Parameter 'baselineReport' of method 'SetBaselineJob' must not be null";
        assert (baselineType != null) : "Parameter 'baselineType' of method 'SetBaselineJob' must not be null";
        this.m_baselineReport = baselineReport;
        this.m_baselineType = baselineType;
        this.m_plugin = plugin;
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition getPrecondition() {
        return AbstractSonargraphEclipseJob.Precondition.OPENED_SOFTWARE_SYSTEM;
    }

    @Override
    protected IStatus runInWorkspaceInternal(IProgressMonitor monitor) throws Exception {
        final OperationResultWithOutcome baselineResult = new OperationResultWithOutcome("Set new baseline");
        SetBaselineCommand setBaselineCommand = new SetBaselineCommand(this.getProvider(), new SetBaselineCommand.SetBaselineCommandInteraction(){

            public boolean collect(SetBaselineCommand.SetBaselineInteractionData data) {
                if (!$assertionsDisabled && data == null) {
                    throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                }
                data.setData(SetBaselineJob.this.m_baselineType, SetBaselineJob.this.m_baselineReport);
                return true;
            }

            public void processResult(OperationResult result) {
                baselineResult.addMessagesFrom(result);
            }
        });
        try {
            EclipseWorkerContext workerContext = new EclipseWorkerContext(monitor);
            JobsCommandResultConsumer consumer = new JobsCommandResultConsumer();
            setBaselineCommand.runSynchronouslyAndConsumeDirectly((IWorkerContext)workerContext, (CommandResultConsumer)consumer);
            if (consumer.getException().isPresent()) {
                throw consumer.getException().get();
            }
            if (baselineResult.isFailure()) {
                Status status = new Status(4, "com.hello2morrow.sonargraph.ide.eclipse", baselineResult.toString());
                return status;
            }
            Status status = new Status(0, "com.hello2morrow.sonargraph.ide.eclipse", "Successfully applied baseline report");
            return status;
        }
        finally {
            this.m_plugin.determineSystemDiffStatus();
        }
    }
}

