/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs.diff;

import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.diff.ComputeAndSetBaselineCommand;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.EclipseWorkerContext;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ISonargraphSetBaselineJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.JobsCommandResultConsumer;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;

public final class NewBaselineAndComputeSystemJob
extends AbstractSonargraphEclipseJob
implements ISonargraphSetBaselineJob {
    private final TFile m_baselineReportDirectory;
    private final String m_reportDescription;
    private final String m_fileName;
    private final ISonargraphEclipsePlugin m_plugin;

    public NewBaselineAndComputeSystemJob(IEventBroker eventBroker, ISonargraphEclipsePlugin plugin, TFile baselineReportDirectory, String fileName, String reportDescription) {
        super(eventBroker, plugin.getSoftwareSystemProvider(), "Create Baseline and Compute System Diff", JobType.PROVIDES_PROGESS, 40);
        assert (baselineReportDirectory != null) : "Parameter 'baselineReportDirectory' of method 'NewBaselineAndComputeSystemJob' must not be null";
        assert (fileName != null && fileName.length() > 0) : "Parameter 'fileName' of method 'NewBaselineAndComputeSystemJob' must not be empty";
        this.m_baselineReportDirectory = baselineReportDirectory;
        this.m_reportDescription = reportDescription;
        this.m_fileName = fileName;
        this.m_plugin = plugin;
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition getPrecondition() {
        return AbstractSonargraphEclipseJob.Precondition.OPENED_SOFTWARE_SYSTEM;
    }

    @Override
    protected IStatus runInWorkspaceInternal(IProgressMonitor monitor) throws Exception {
        final OperationResultWithOutcome baselineResult = new OperationResultWithOutcome("Create and set new baseline");
        ComputeAndSetBaselineCommand systemDiff = new ComputeAndSetBaselineCommand(this.getProvider(), new ComputeAndSetBaselineCommand.ComputeBaselineCommandInteraction(){

            public boolean collect(ComputeAndSetBaselineCommand.BaselineInteractionData data) {
                data.setBaselineFileName(NewBaselineAndComputeSystemJob.this.m_fileName);
                data.setBaselineReportDirectory(NewBaselineAndComputeSystemJob.this.m_baselineReportDirectory);
                if (NewBaselineAndComputeSystemJob.this.m_reportDescription != null) {
                    data.setReportDescription(NewBaselineAndComputeSystemJob.this.m_reportDescription);
                }
                data.setBaselineType(BaselineType.LOCAL);
                return true;
            }

            public void processResult(OperationResultWithOutcome<TFile> result) {
                baselineResult.addMessagesFrom(result);
                baselineResult.setOutcome((Object)((TFile)result.getOutcome()));
            }
        });
        try {
            EclipseWorkerContext workerContext = new EclipseWorkerContext(monitor);
            JobsCommandResultConsumer consumer = new JobsCommandResultConsumer();
            systemDiff.runSynchronouslyAndConsumeDirectly((IWorkerContext)workerContext, (CommandResultConsumer)consumer);
            if (consumer.getException().isPresent()) {
                throw consumer.getException().get();
            }
            if (baselineResult.isFailure()) {
                Status status = new Status(4, "com.hello2morrow.sonargraph.ide.eclipse", baselineResult.toString());
                return status;
            }
            Status status = new Status(0, "com.hello2morrow.sonargraph.ide.eclipse", "Successfully created baseline report and computed system diff");
            return status;
        }
        finally {
            this.m_plugin.determineSystemDiffStatus();
        }
    }
}

