/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs.diff;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IIssueFilter;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionFilter;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.core.model.system.IIssueProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CycleGroupIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.CyclicElementDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockOccurrenceDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IssuesDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.ResolutionDefinitionDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.ResolutionsDiff;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ISonargraphCompleteMarkerJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.SonargraphToEclipseResourceConverter;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.diff.DeactivateBaselineJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.marker.AbstractCreateMarkerJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.IIssueToMarkerMap;
import com.hello2morrow.sonargraph.ide.eclipse.model.ResourceInfo;
import com.hello2morrow.sonargraph.ide.eclipse.model.status.ISonargraphStatusProvider;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.AbstractIssueDiffDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.AbstractIssueDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.CycleGroupIssueDiffDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.DuplicateCodeBlockOccurrenceDiffDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.DuplicateCodeBlockOccurrenceDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.DuplicateIssueDiffDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.ResolutionDto;
import com.hello2morrow.sonargraph.ide.eclipse.model.wrapper.StandardIssueDiffDto;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.JavaIssueId;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateAllMarkersForSystemDiffJob
extends AbstractCreateMarkerJob
implements ISonargraphCompleteMarkerJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateAllMarkersForSystemDiffJob.class);

    public CreateAllMarkersForSystemDiffJob(IEventBroker eventBroker, ISoftwareSystemProvider provider, IIssueToMarkerMap cache) {
        super(eventBroker, provider, "Create Markers for Sonargraph Diff Issues", cache);
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition getPrecondition() {
        return AbstractSonargraphEclipseJob.Precondition.OPENED_SOFTWARE_SYSTEM;
    }

    @Override
    protected List<Class<?>> getJobClassesThatMakeThisObsolete() {
        ArrayList clazzes = new ArrayList(super.getJobClassesThatMakeThisObsolete());
        clazzes.add(DeactivateBaselineJob.class);
        return clazzes;
    }

    @Override
    protected void postFinishedEvent(Map<String, Object> eventData, int numberOfErrors, int numberOfWarnings) {
        ISonargraphStatusProvider.SonargraphStatus status = numberOfErrors == 0 && numberOfWarnings == 0 ? ISonargraphStatusProvider.SonargraphStatus.RESULTS_PRESENT_OK_BASELINE : ISonargraphStatusProvider.SonargraphStatus.RESULTS_PRESENT_WITH_ISSUES_BASELINE;
        this.postStatusEvent(status, eventData);
    }

    @Override
    protected boolean excludeIssueFromCount(AbstractIssueDto issueDto) {
        assert (issueDto != null) : "Parameter 'issueDto' of method 'excludeIssueFromCount' must not be null";
        return issueDto.getId().getCategory() == IssueCategory.QUALITY_GATE;
    }

    @Override
    protected List<AbstractIssueDto> convertIssues(Collection<Issue> issues, IProgressMonitor monitor) {
        assert (monitor != null) : "Parameter 'monitor' of method 'convertIssues' must not be null";
        SoftwareSystem softwareSystem = this.getProvider().getSoftwareSystem();
        SoftwareSystemDiff diff = this.getSoftwareSystemDiff(softwareSystem);
        if (diff == null) {
            return Collections.emptyList();
        }
        IssuesDiff issuesDiff = (IssuesDiff)diff.getUniqueChild(IssuesDiff.class);
        if (issuesDiff == null || issuesDiff.getChildren().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IIssueDiff> issueDiffs = new ArrayList<IIssueDiff>();
        EnumSet<JavaIssueId> ignoredIssueIds = EnumSet.of(JavaIssueId.JAVA_FILE_UNPARSEABLE, JavaIssueId.JAVA_FILE_PARSE_ERROR, JavaIssueId.JAVA_FILE_UNPARSEABLE, JavaIssueId.JAVA_FILE_DUPLICATE, JavaIssueId.JAVA_FILE_TYPE_MATCHING_INCONSISTENT);
        for (IIssueDiff next : issuesDiff.getChildren(IIssueDiff.class)) {
            Issue issue;
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            if (next.getChange() == IDiffElement.Change.REMOVED || next.getChange() == IDiffElement.Change.RESOLUTION_ADDED || (issue = next.getCurrent()).getResolution() != null || ignoredIssueIds.contains(issue.getId())) continue;
            issueDiffs.add(next);
        }
        IIssueProvider issueProvider = (IIssueProvider)softwareSystem.getExtension(IIssueProvider.class);
        ArrayList<AbstractIssueDto> issueDtos = new ArrayList<AbstractIssueDto>();
        for (IIssueDiff issueDiff : issueDiffs) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            AbstractIssueDiffDto dto = this.convertIssueDiff(issueProvider, issueDiff);
            if (dto == null || !dto.isValid()) continue;
            issueDtos.add(dto);
        }
        List qualityGateIssues = softwareSystem.getCurrentModel().getIssueList((IIssueFilter)new IssueFilter((IStandardEnumeration[])new IssueCategory[]{IssueCategory.QUALITY_GATE})).getIssues();
        for (Issue nextQualityGateIssue : qualityGateIssues) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            AbstractIssueDto dto = this.convertIssue(issueProvider, nextQualityGateIssue);
            if (dto == null || !dto.isValid()) continue;
            issueDtos.add(dto);
        }
        return issueDtos;
    }

    public SoftwareSystemDiff getSoftwareSystemDiff(SoftwareSystem softwareSystem) {
        return ((ISystemDiffProvider)softwareSystem.getExtension(ISystemDiffProvider.class)).getSoftwareSystemDiff();
    }

    private AbstractIssueDiffDto convertIssueDiff(IIssueProvider issueProvider, IIssueDiff issueDiff) {
        AbstractIssueDiffDto dto;
        assert (issueProvider != null) : "Parameter 'issueProvider' of method 'convertIssue' must not be null";
        assert (issueDiff != null) : "Parameter 'issueDiff' of method 'convertIssue' must not be null";
        Issue currentIssue = issueDiff.getCurrent();
        IssueCategory issueCategory = currentIssue.getId().getCategory();
        if (CreateAllMarkersForSystemDiffJob.isIssueToBeIgnored(currentIssue)) {
            LOGGER.debug("Ignoring issue with id '{}' of category '{}'.", (Object)currentIssue.getId().getStandardName(), (Object)issueCategory.getStandardName());
            return null;
        }
        if (issueCategory == IssueCategory.CYCLE_GROUP) {
            AnalyzerCycleGroup cycleGroup = (AnalyzerCycleGroup)currentIssue.getAffectedElement();
            NamedElement scope = cycleGroup.getScope();
            if (scope == null) {
                return null;
            }
            ResourceInfo temp = SonargraphToEclipseResourceConverter.convert((Element)scope);
            ResourceInfo info = new ResourceInfo(temp.getResource(), cycleGroup.getName(), false, temp.isPartOfActiveWorkspace());
            if (currentIssue.getId() == CoreIssueId.COMPONENT_CYCLE_GROUP) {
                String description = this.createDescriptionForProblem(currentIssue, cycleGroup.getName(), false);
                Map<TFile, Pair<IDiffElement.Change, String>> filesAndDescriptionOfCycleGroup = this.getSourceFilesAndDescriptionOfCycleGroup(issueProvider, (CycleGroupIssueDiff)issueDiff);
                dto = new CycleGroupIssueDiffDto((CycleGroupIssue)currentIssue, info, description, filesAndDescriptionOfCycleGroup, issueDiff.getChange(), issueDiff.getChangeDescription());
            } else {
                dto = new CycleGroupIssueDiffDto((CycleGroupIssue)currentIssue, info, this.createDescriptionForProblem(currentIssue, cycleGroup.getName(), false), Collections.emptyMap(), issueDiff.getChange(), issueDiff.getChangeDescription());
            }
        } else if (currentIssue.getId() == CoreIssueId.DUPLICATE_CODE_BLOCK) {
            assert (issueDiff instanceof DuplicateCodeBlockIssueDiff) : "Parameter 'issueDiff' of method 'convertIssueDiff' must not be null";
            DuplicateCodeBlockIssueDiff duplicateDiff = (DuplicateCodeBlockIssueDiff)issueDiff;
            ArrayList<DuplicateCodeBlockOccurrenceDto> occurrences = new ArrayList<DuplicateCodeBlockOccurrenceDto>();
            ResourceInfo info = SonargraphToEclipseResourceConverter.convert((Element)((DuplicateCodeBlockIssue)duplicateDiff.getCurrent()).getAffectedElement());
            for (DuplicateCodeBlockOccurrenceDiff nextOccurrenceDiff : duplicateDiff.getChildren(DuplicateCodeBlockOccurrenceDiff.class)) {
                DuplicateCodeBlockOccurrence current = (DuplicateCodeBlockOccurrence)nextOccurrenceDiff.getCurrent();
                if (current == null) continue;
                DuplicateCodeBlockOccurrenceDiffDto occurrenceDto = new DuplicateCodeBlockOccurrenceDiffDto(info, current.getSourceFile().getFile(), current.getBlockBegin(), current.getBlockEnd(), current.getBlockSize(), current.getToleranceAsInt(), nextOccurrenceDiff.getChange(), nextOccurrenceDiff.getChangeDescription());
                occurrences.add(occurrenceDto);
            }
            String description = this.createDescriptionForProblem(currentIssue, info.getSonargraphElementName(), info.isResourceTrueElement());
            dto = new DuplicateIssueDiffDto((DuplicateCodeBlockIssue)duplicateDiff.getCurrent(), info, description, occurrences, issueDiff.getChange(), issueDiff.getChangeDescription());
        } else {
            Element affectedElement = currentIssue.getAffectedElement();
            if (affectedElement.isExternal()) {
                LOGGER.trace("Omitting issue for external element '{}'", (Object)affectedElement.getName());
                dto = null;
            } else if (affectedElement.isExcluded()) {
                LOGGER.trace("Omitting issue for excluded element '{}'", (Object)affectedElement.getName());
                dto = null;
            } else {
                ResourceInfo info = affectedElement instanceof ElementWithIssues ? SonargraphToEclipseResourceConverter.convert((Element)((ElementWithIssues)affectedElement).getOriginal()) : SonargraphToEclipseResourceConverter.convert(affectedElement);
                String description = this.createDescriptionForProblem(currentIssue, info.getSonargraphElementName(), info.isResourceTrueElement());
                dto = new StandardIssueDiffDto(currentIssue, info, description, this.getSourceFiles(issueProvider, issueDiff), issueDiff.getChange(), issueDiff.getChangeDescription());
            }
        }
        return dto;
    }

    private Map<TFile, Pair<IDiffElement.Change, String>> getSourceFilesAndDescriptionOfCycleGroup(IIssueProvider issueProvider, CycleGroupIssueDiff cycleGroupDiff) {
        assert (issueProvider != null) : "Parameter 'issueProvider' of method 'getSourceFiles' must not be null";
        HashMap<TFile, Pair<IDiffElement.Change, String>> result = new HashMap<TFile, Pair<IDiffElement.Change, String>>();
        for (CyclicElementDiff nextCyclicDiff : cycleGroupDiff.getChildren(CyclicElementDiff.class)) {
            NamedElement cyclic;
            if (nextCyclicDiff.getCurrent() == null || (cyclic = nextCyclicDiff.getCurrentElement()) == null) continue;
            assert (cyclic instanceof SourceFile) : "Not a source file: " + String.valueOf(cyclic);
            FilePath physicalFilePath = ((SourceFile)cyclic).getPhysicalFilePath();
            if (physicalFilePath == null) continue;
            TFile file = physicalFilePath.getFile();
            result.put(file, (Pair<IDiffElement.Change, String>)new Pair((Object)nextCyclicDiff.getChange(), (Object)nextCyclicDiff.getChangeDescription()));
        }
        return result;
    }

    @Override
    protected List<ResolutionDto> convertResolutions(Collection<Issue> issues, IProgressMonitor monitor) {
        SoftwareSystem softwareSystem = this.getProvider().getSoftwareSystem();
        IIssueProvider issueProvider = (IIssueProvider)softwareSystem.getExtension(IIssueProvider.class);
        ArrayList<ResolutionDto> resolutionDtos = new ArrayList<ResolutionDto>();
        ResolutionFilter filter = new ResolutionFilter();
        filter.add((IStandardEnumeration)ResolutionKind.FIX);
        filter.add((IStandardEnumeration)ResolutionKind.TODO);
        filter.add((IStandardEnumeration)ResolutionKind.REFACTORING);
        SoftwareSystemDiff softwareSystemDiff = this.getSoftwareSystemDiff(softwareSystem);
        if (softwareSystemDiff == null) {
            return resolutionDtos;
        }
        ResolutionsDiff resolutionsDiff = (ResolutionsDiff)softwareSystemDiff.getUniqueChild(ResolutionsDiff.class);
        ArrayList<ResolutionDefinitionDiff> resolutionDiffs = new ArrayList<ResolutionDefinitionDiff>();
        for (ResolutionDefinitionDiff next : resolutionsDiff.getChildren(ResolutionDefinitionDiff.class)) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            if (next.getChange() == IDiffElement.Change.REMOVED || !filter.accept((Resolution)next.getCurrent())) continue;
            resolutionDiffs.add(next);
        }
        resolutionDiffs.sort(new Comparator<ResolutionDefinitionDiff<?, ?>>(){

            @Override
            public int compare(ResolutionDefinitionDiff<?, ?> r1, ResolutionDefinitionDiff<?, ?> r2) {
                Date timestamp1 = ((Resolution)r1.getCurrent()).getDate();
                Date timestamp2 = ((Resolution)r2.getCurrent()).getDate();
                return timestamp1.compareTo(timestamp2);
            }
        });
        for (ResolutionDefinitionDiff resolutionDiff : resolutionDiffs) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            ResolutionDto dto = this.convertResolutionDiff(issueProvider, resolutionDiff);
            if (dto == null) continue;
            resolutionDtos.add(dto);
        }
        return resolutionDtos;
    }

    private ResolutionDto convertResolutionDiff(IIssueProvider issueProvider, ResolutionDefinitionDiff<?, ?> resolutionDiff) {
        assert (issueProvider != null) : "Parameter 'issueProvider' of method 'convertResolution' must not be null";
        assert (resolutionDiff != null) : "Parameter 'resolutionDiff' of method 'convertResolution' must not be null";
        ResolutionDto resolutionDto = this.convertResolution(issueProvider, (Resolution)resolutionDiff.getCurrent());
        if (resolutionDto == null) {
            return null;
        }
        resolutionDto.setChangeInfo(resolutionDiff.getChange(), resolutionDiff.getChangeDescription());
        return resolutionDto;
    }

    private List<TFile> getSourceFiles(IIssueProvider issueProvider, IIssueDiff issueDiff) {
        assert (issueProvider != null) : "Parameter 'issueProvider' of method 'getSourceFiles' must not be null";
        assert (issueDiff != null) : "Parameter 'issueDiff' of method 'getSourceFiles' must not be null";
        List affectedPhysicalSourceFiles = issueProvider.getAffectedPhysicalSourceFiles(issueDiff.getCurrent());
        if (affectedPhysicalSourceFiles.size() == 1) {
            return Collections.singletonList(((FilePath)affectedPhysicalSourceFiles.get(0)).getFile());
        }
        ArrayList<TFile> result = new ArrayList<TFile>(affectedPhysicalSourceFiles.size());
        for (FilePath next : affectedPhysicalSourceFiles) {
            result.add(next.getFile());
        }
        return result;
    }
}

