/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.RefreshCommand;
import com.hello2morrow.sonargraph.core.command.system.RefreshSoftwareSystemFilesCommand;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.EclipseWorkerContext;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ISonargraphCompleteModelModifyingJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.JobsCommandResultConsumer;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.ide.eclipse.model.status.ISonargraphStatusProvider;
import com.hello2morrow.sonargraph.ide.eclipse.view.EclipsePreferenceUtils;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RefreshSystemFilesJob
extends AbstractSonargraphEclipseJob
implements ISonargraphCompleteModelModifyingJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshSystemFilesJob.class);
    private static final String FAMILY = "com.hello2morrow.sonargraph.ide.eclipse.jobs.refresh";
    private OperationResult m_refreshResult;
    private PrepareRefreshResult.SoftwareSystemFileModification m_refreshModification;
    private ModifiableFileDelta m_systemFilesDelta;
    private final ISonargraphEclipsePlugin m_plugin;

    public RefreshSystemFilesJob(IEventBroker eventBroker, ISoftwareSystemProvider provider, ISonargraphEclipsePlugin plugin) {
        super(eventBroker, provider, "Refresh Software System Files", JobType.PROVIDES_PROGESS, 40);
        this.m_plugin = plugin;
    }

    @Override
    protected ISonargraphStatusProvider.SonargraphStatus getJobStartedStatus() {
        return null;
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition getPrecondition() {
        return AbstractSonargraphEclipseJob.Precondition.OPENED_SOFTWARE_SYSTEM;
    }

    @Override
    protected final IStatus runInWorkspaceInternal(IProgressMonitor monitor) throws CommandException {
        ModifiableFileDelta delta;
        assert (monitor != null) : "Parameter 'monitor' of method 'runInWorkspace' must not be null";
        RefreshSoftwareSystemFilesCommand refresh = new RefreshSoftwareSystemFilesCommand(this.getProvider(), (RefreshCommand.IRefreshInteraction)new RefreshSoftwareSystemFilesCommand.RefreshSoftwareSystemFilesInteraction(this.getProvider().getSoftwareSystem()){

            public Map<IModifiableFile, IModificationOnSave> aboutToSave(SoftwareSystem system, List<IModifiableFile> toBeSaved) {
                if (!$assertionsDisabled && system == null) {
                    throw new AssertionError((Object)"Parameter 'system' of method 'aboutToSave' must not be null");
                }
                if (!$assertionsDisabled && toBeSaved == null) {
                    throw new AssertionError((Object)"Parameter 'toBeSaved' of method 'aboutToSave' must not be null");
                }
                return Collections.emptyMap();
            }

            public RefreshCommand.IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse confirmPreRefreshSoftwareSystemFileModification(PrepareRefreshResult.SoftwareSystemFileModification modification) {
                RefreshSystemFilesJob.this.m_refreshModification = modification;
                return RefreshCommand.IRefreshInteraction.PreRefreshSoftwareSystemFileModificationResponse.CONTINUE;
            }

            public boolean confirmPreRefreshActions(PrepareRefreshResult result) {
                RefreshSystemFilesJob.this.m_systemFilesDelta = result.getSystemFilesDelta();
                return true;
            }

            public void processPrepareRefreshResult(PrepareRefreshResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processRefreshPrepareResult' must not be null");
                }
                RefreshSystemFilesJob.this.m_refreshResult = result;
            }

            public void processRefreshResult(OperationResult result) {
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError((Object)"Parameter 'result' of method 'processRefreshResult' must not be null");
                }
                RefreshSystemFilesJob.this.m_refreshResult = result;
            }
        });
        JobsCommandResultConsumer consumer = new JobsCommandResultConsumer();
        refresh.runSynchronouslyAndConsumeDirectly((IWorkerContext)new EclipseWorkerContext(monitor), (CommandResultConsumer)consumer);
        if (consumer.getException().isPresent()) {
            throw consumer.getException().get();
        }
        Optional<OperationResult> resultOpt = this.getRefreshResult();
        if (!resultOpt.isPresent()) {
            String msg = "Fatal error occured while refreshing system files.";
            LOGGER.error("Fatal error occured while refreshing system files.");
            return new Status(4, "com.hello2morrow.sonargraph.ide.eclipse", "Fatal error occured while refreshing system files.\nPlease try again.");
        }
        OperationResult result = resultOpt.get();
        if (result.isFailure()) {
            UserInterfaceAdapter.getInstance().displayUiElementAsync(() -> UserInterfaceAdapter.getInstance().process(result));
            return new Status(4, "com.hello2morrow.sonargraph.ide.eclipse", result.getErrorMessages().toString());
        }
        if (this.getRefreshModification().isPresent()) {
            PrepareRefreshResult.SoftwareSystemFileModification modification = this.getRefreshModification().get();
            if (modification == PrepareRefreshResult.SoftwareSystemFileModification.DELETED) {
                EclipsePreferenceUtils.storeLastUsedSystemInPreferences(null);
                EclipseWorkspaceUtils.clearSonargraphResourceProperties((IResource)ResourcesPlugin.getWorkspace().getRoot());
                this.m_plugin.updateSonargraphAnalysisStatus(ISonargraphEclipsePlugin.AnalysisStatus.SUSPENDED);
                return new Status(2, "com.hello2morrow.sonargraph.ide.eclipse", "Software System Deleted: The system definition no longer exists.");
            }
            if (modification == PrepareRefreshResult.SoftwareSystemFileModification.MODIFIED) {
                this.m_plugin.resetSonargraphAnalysisStatus();
                LOGGER.info("After UserInterfaceAdapter.getInstance().information");
                return new Status(2, "com.hello2morrow.sonargraph.ide.eclipse", "Software System Modified: The system definition has been modified. The system will be reloaded and refreshed.");
            }
        }
        if (this.getSystemFilesDelta().isPresent() && (delta = this.getSystemFilesDelta().get()).getNumberOfModifiedFiles() > 0) {
            return new Status(0, "com.hello2morrow.sonargraph.ide.eclipse", "Refreshed " + delta.getNumberOfModifiedFiles() + " system files.");
        }
        return new Status(0, "com.hello2morrow.sonargraph.ide.eclipse", "No changes detected in system files.");
    }

    @Override
    protected final boolean hasResult() {
        return true;
    }

    public Optional<PrepareRefreshResult.SoftwareSystemFileModification> getRefreshModification() {
        return Optional.ofNullable(this.m_refreshModification);
    }

    public Optional<OperationResult> getRefreshResult() {
        return Optional.ofNullable(this.m_refreshResult);
    }

    public Optional<ModifiableFileDelta> getSystemFilesDelta() {
        return Optional.ofNullable(this.m_systemFilesDelta);
    }

    public static boolean isRunning() {
        return Job.getJobManager().find((Object)FAMILY).length > 0;
    }

    @Override
    public boolean belongsTo(Object family) {
        return family instanceof RefreshSystemFilesJob || super.belongsTo(family) || family == FAMILY;
    }
}

