/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.IModule;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphDeltaVisitor;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import de.schlichtherle.truezip.file.TFile;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EclipseProjectFilesVisitor
extends AbstractSonargraphDeltaVisitor
implements IResourceVisitor {
    static final Logger LOGGER = LoggerFactory.getLogger(EclipseProjectFilesVisitor.class);
    private final IProgressMonitor m_monitor;
    private Map<String, FilePath> m_sonargraphFiles;
    private String m_currentRootAbsolutePath;

    public EclipseProjectFilesVisitor(ISoftwareSystemProvider systemProvider, JavaModule module, IProgressMonitor monitor) {
        super(systemProvider, module);
        assert (monitor != null) : "Parameter 'monitor' of method 'EclipseProjectFilesVisitor' must not be null";
        this.m_monitor = monitor;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (this.m_monitor.isCanceled()) {
            return false;
        }
        if (resource.getType() == 4) {
            this.m_sonargraphFiles = new HashMap<String, FilePath>();
            this.getProvider().visitPresentFilePaths(new IFilePathListener(){

                public void filePathPresent(IModule module, FilePath filePath) {
                    if (!$assertionsDisabled && module == null) {
                        throw new AssertionError((Object)"Parameter 'module' of method 'filePathPresent' must not be null");
                    }
                    if (!$assertionsDisabled && filePath == null) {
                        throw new AssertionError((Object)"Parameter 'filePath' of method 'filePathPresent' must not be null");
                    }
                    TFile file = filePath.getFile();
                    if (!$assertionsDisabled && file == null) {
                        throw new AssertionError((Object)"'file' of method 'filePathPresent' must not be null");
                    }
                    String identifyingPath = FileUtility.getIdentifyingPath((TFile)file);
                    EclipseProjectFilesVisitor.this.m_sonargraphFiles.put(identifyingPath, filePath);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("File path present: " + identifyingPath);
                    }
                }
            }, new IModule[]{this.getModule()});
            return true;
        }
        if (resource.getType() == 2) {
            Optional<TFile> fileOpt = EclipseWorkspaceUtils.getFileOfResource(resource);
            if (!fileOpt.isPresent()) {
                LOGGER.debug("No file present for folder resource {}", (Object)resource);
                return false;
            }
            String absolutePath = FileUtility.getIdentifyingPath((TFile)fileOpt.get());
            this.m_currentRootAbsolutePath = this.isRoot(absolutePath) ? absolutePath : null;
            return this.m_currentRootAbsolutePath != null || this.isParentOfRoots(absolutePath);
        }
        if (resource.getType() == 1) {
            if (this.m_currentRootAbsolutePath == null) {
                return false;
            }
            assert (this.m_sonargraphFiles != null) : "'m_sonargraphFiles' of method 'visit' must not be null. Have you called visit() on IProject?";
            Optional<JavaFileType> fileType = this.getFileType(resource);
            if (!fileType.isPresent()) {
                return false;
            }
            Optional<TFile> fileOpt = EclipseWorkspaceUtils.getFileOfResource(resource);
            if (!fileOpt.isPresent()) {
                LOGGER.debug("No file present for file resource {}", (Object)resource);
                return false;
            }
            TFile file = fileOpt.get();
            String absolutePath = FileUtility.getIdentifyingPath((TFile)file);
            FilePath sonargraphFile = this.m_sonargraphFiles.remove(absolutePath);
            if (file.exists()) {
                if (sonargraphFile != null) {
                    if (sonargraphFile.getTimestamp() < file.lastModified()) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("Modified file: {}", (Object)absolutePath);
                        }
                        if (sonargraphFile.isValid()) {
                            this.getDelta().modified(sonargraphFile);
                        } else {
                            LOGGER.warn("Modified file not valid: " + absolutePath);
                        }
                    }
                } else {
                    RootDirectoryPath currentRoot;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Added file: {}", (Object)absolutePath);
                    }
                    if ((currentRoot = this.determineCurrentRoot(this.m_currentRootAbsolutePath, fileType.get())) != null) {
                        this.getDelta().added(currentRoot, (IFileType)fileType.get(), new TFile(absolutePath));
                    } else {
                        LOGGER.error("No sonargraph root directory found for: " + absolutePath);
                    }
                }
            } else if (sonargraphFile != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Deleted file: {}", (Object)absolutePath);
                }
                if (sonargraphFile.isValid()) {
                    this.getDelta().deleted(sonargraphFile);
                } else {
                    LOGGER.warn("Deleted file not valid: " + absolutePath);
                }
            }
        }
        return false;
    }

    @Override
    public ModuleDelta finishDeltaCreation() {
        assert (this.m_sonargraphFiles != null) : "'m_sonargraphFiles' of method 'finishDeltaCreation' must not be null. Method can only be called once!";
        ModuleDelta delta = this.getDelta();
        for (Map.Entry<String, FilePath> nextEntry : this.m_sonargraphFiles.entrySet()) {
            FilePath nextFilePath = nextEntry.getValue();
            if (nextFilePath != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Deleted file: {}", (Object)nextFilePath.getFile().getAbsolutePath());
                }
                if (nextFilePath.isValid()) {
                    delta.deleted(nextFilePath);
                    continue;
                }
                LOGGER.warn("Deleted file not valid: " + nextFilePath.getFile().getAbsolutePath());
                continue;
            }
            LOGGER.warn("No file path for: " + nextEntry.getKey());
        }
        this.m_sonargraphFiles = null;
        delta.finishCreation();
        return delta;
    }
}

