/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.RefreshSoftwareSystemTask;
import com.hello2morrow.sonargraph.ide.eclipse.model.FileRegistry;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;

public final class DeltaRefreshSoftwareSystemJob
extends AbstractSonargraphEclipseJob {
    private final List<ModuleDelta> m_deltas;
    private final FileRegistry m_fileRegistry;

    public DeltaRefreshSoftwareSystemJob(IEventBroker eventBroker, ISoftwareSystemProvider provider, FileRegistry fileRegistry, List<ModuleDelta> deltas) {
        super(eventBroker, provider, "Delta refresh of Sonargraph workspace", JobType.PROVIDES_PROGESS, 40);
        assert (fileRegistry != null) : "Parameter 'fileRegistry' of method 'DeltaRefreshSoftwareSystemJob' must not be null";
        assert (deltas != null && deltas.size() > 0) : "Parameter 'm_deltas' of method 'DeltaRefreshSoftwareSystemJob' must not be empty";
        this.m_fileRegistry = fileRegistry;
        this.m_deltas = deltas;
    }

    @Override
    protected IStatus runInWorkspaceInternal(IProgressMonitor monitor) throws Exception {
        if (!this.getProvider().hasSoftwareSystem()) {
            return Status.CANCEL_STATUS;
        }
        RefreshSoftwareSystemTask refreshTask = new RefreshSoftwareSystemTask(this.getProvider(), this.m_fileRegistry, this.m_deltas);
        refreshTask.execute(monitor);
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition getPrecondition() {
        return AbstractSonargraphEclipseJob.Precondition.OPENED_SOFTWARE_SYSTEM;
    }
}

