/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.system.CreateReportCommand;
import com.hello2morrow.sonargraph.core.model.report.CreateReportResult;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ide.eclipse.foundation.common.EclipseWorkerContext;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.JobsCommandResultConsumer;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import de.schlichtherle.truezip.file.TFile;
import java.util.HashSet;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateHtmlReportJob
extends AbstractSonargraphEclipseJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateHtmlReportJob.class);
    private final TFile m_targetDirectory;
    private final IReport.Format m_format;

    public CreateHtmlReportJob(ISoftwareSystemProvider provider, TFile targetDirectory, IReport.Format format) {
        super(provider, "Create System HTML Report", JobType.PROVIDES_PROGESS, 10);
        assert (targetDirectory != null) : "Parameter 'targetDirectory' of method 'CreateHtmlReportJob' must not be null";
        assert (format != null) : "Parameter 'format' of method 'CreateHtmlReportJob' must not be null";
        this.m_targetDirectory = targetDirectory;
        this.m_format = format;
    }

    @Override
    protected AbstractSonargraphEclipseJob.Precondition getPrecondition() {
        return AbstractSonargraphEclipseJob.Precondition.OPENED_SOFTWARE_SYSTEM;
    }

    @Override
    protected IStatus runInWorkspaceInternal(IProgressMonitor monitor) throws Exception {
        CreateReportCommand reportCommand = new CreateReportCommand(this.getProvider(), new CreateReportCommand.IReportInteraction(){

            public void handleResult(OperationResultWithOutcome<CreateReportResult> createReportResult) {
                if (createReportResult.isSuccess()) {
                    UserInterfaceAdapter.getInstance().displayUiElementAsync(() -> CreateHtmlReportJob.this.showFileInView(((CreateReportResult)createReportResult.getOutcome()).getTargetFile(CreateHtmlReportJob.this.m_format)));
                }
            }

            public boolean collect(CreateReportCommand.ReportInteractionData data) {
                data.setReportDirectory(CreateHtmlReportJob.this.m_targetDirectory);
                HashSet<IReport.Format> reportFormats = new HashSet<IReport.Format>();
                reportFormats.add(CreateHtmlReportJob.this.m_format);
                data.setReportFormats(reportFormats);
                return true;
            }
        });
        EclipseWorkerContext workerContext = new EclipseWorkerContext(monitor);
        JobsCommandResultConsumer consumer = new JobsCommandResultConsumer();
        reportCommand.runSynchronously((IWorkerContext)workerContext, (CommandResultConsumer)consumer);
        if (consumer.getException().isPresent()) {
            throw consumer.getException().get();
        }
        return new Status(0, "com.hello2morrow.sonargraph.ide.eclipse", "Successfully created HTML report");
    }

    private void showFileInView(TFile fileToOpen) {
        assert (fileToOpen != null) : "Parameter 'fileToOpen' of method 'showFileInView' must not be null";
        assert (fileToOpen.exists() && fileToOpen.isFile()) : "fileToOpen is not an existing file: " + String.valueOf(fileToOpen);
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
        }
        catch (PartInitException e) {
            LOGGER.error("Failed to show HTML report '" + fileToOpen.getAbsolutePath() + "' in default editor", (Throwable)e);
            UserInterfaceAdapter.getInstance().error("Failed to Open System Diff Report", "Failed to show HTML report '" + fileToOpen.getNormalizedAbsolutePath() + "' in default workbench editor:\n" + e.getMessage());
        }
    }
}

