/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.jobs;

import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleMappingInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemInfoMessageCause;
import com.hello2morrow.sonargraph.core.model.system.dynamic.SystemMappingInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.AbstractSonargraphEclipseJob;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.EclipseProjectFilesVisitor;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.OpenSoftwareSystemTask;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.RefreshSoftwareSystemTask;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.ReparseSystemJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.EclipseWorkspaceUtils;
import com.hello2morrow.sonargraph.ide.eclipse.model.FileRegistry;
import com.hello2morrow.sonargraph.ide.eclipse.model.JobType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractOpenSoftwareSystemJob
extends AbstractSonargraphEclipseJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOpenSoftwareSystemJob.class);

    protected AbstractOpenSoftwareSystemJob(IEventBroker eventBroker, ISoftwareSystemProvider provider, String name, JobType jobType, int priority) {
        super(eventBroker, provider, name, jobType, priority);
    }

    protected final IStatus openSoftwareSystem(IProgressMonitor monitor, TFile systemDirectory, FileRegistry fileRegistry, DynamicSystemInfo dynamicSystem, SystemMappingInfo systemMappingInfo) throws CommandException, Exception, CoreException {
        OperationResult mappingResult = new OperationResult("Open software system");
        if (dynamicSystem.getModules().isEmpty()) {
            mappingResult.addError((OperationResult.IMessageCause)SystemInfoMessageCause.NO_MATCHING_MODULE_FOUND, "No mappings for system found", new Object[0]);
            UserInterfaceAdapter.getInstance().displayUiElement(() -> UserInterfaceAdapter.getInstance().process(mappingResult));
            return Status.CANCEL_STATUS;
        }
        OpenSoftwareSystemTask task = new OpenSoftwareSystemTask(this.getProvider(), fileRegistry, systemDirectory, dynamicSystem, systemMappingInfo);
        OperationResult openResult = task.execute(monitor);
        if (monitor.isCanceled()) {
            EclipseWorkspaceUtils.clearSonargraphResourceProperties((IResource)ResourcesPlugin.getWorkspace().getRoot());
            return Status.CANCEL_STATUS;
        }
        if (openResult.isFailure()) {
            LOGGER.error("Failed to open system '{}'", (Object)systemDirectory.getAbsolutePath());
            EclipseWorkspaceUtils.clearSonargraphResourceProperties((IResource)ResourcesPlugin.getWorkspace().getRoot());
            return new Status(4, "com.hello2morrow.sonargraph.ide.eclipse", openResult.toString());
        }
        if (openResult.containsWarning() || openResult.containsError()) {
            UserInterfaceAdapter.getInstance().process(openResult);
        }
        assert (this.getProvider().hasSoftwareSystem()) : "No software system available";
        SoftwareSystem softwareSystem = this.getProvider().getSoftwareSystem();
        if (softwareSystem.getState() == SoftwareSystemState.OPENED) {
            UserInterfaceAdapter.getInstance().information("Reparse Required", "Executing a full reparse for system '" + systemDirectory.getName() + "'");
            LOGGER.debug("No snapshot available on system open or snapshot could not be applied. Executing a full reparse for system '{}'", (Object)systemDirectory.getAbsolutePath());
            IStatus result = ReparseSystemJob.executeFullRefresh(this.getProvider(), fileRegistry, monitor);
            return result.isOK() ? this.getOkStatus() : result;
        }
        LOGGER.debug("Successfully opened system '{}' from snapshot", (Object)systemDirectory.getAbsolutePath());
        this.executeDeltaRefresh(softwareSystem, systemMappingInfo, fileRegistry, monitor);
        return monitor.isCanceled() ? Status.CANCEL_STATUS : this.getOkStatus();
    }

    private Status getOkStatus() {
        return new Status(0, "com.hello2morrow.sonargraph.ide.eclipse", "OK Software system opened successfully.");
    }

    private void executeDeltaRefresh(SoftwareSystem softwareSystem, SystemMappingInfo mappingInfo, FileRegistry fileRegistry, IProgressMonitor monitor) throws CoreException {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'executeDeltaRefresh' must not be null";
        assert (monitor != null) : "Parameter 'monitor' of method 'executeDeltaRefresh' must not be null";
        ArrayList<ModuleDelta> deltas = new ArrayList<ModuleDelta>();
        for (ModuleMappingInfo nextMapping : mappingInfo.getModuleMappings().stream().filter(m -> m.isMappingDefined()).collect(Collectors.toList())) {
            if (monitor.isCanceled()) {
                return;
            }
            String moduleName = ((ModuleInfo)nextMapping.getSonargraphModule().get()).getName();
            JavaModule nextModule = (JavaModule)((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueChild((NamedElement.IFilter)new ShortNameFilter(moduleName), JavaModule.class);
            Optional<IProject> projectOpt = EclipseWorkspaceUtils.getProjectForModule(nextModule.getName());
            if (!projectOpt.isPresent()) {
                LOGGER.debug("Failed to determine project for module '{}'", (Object)nextModule.getName());
                continue;
            }
            IProject project = projectOpt.get();
            EclipseProjectFilesVisitor visitor = new EclipseProjectFilesVisitor(this.getProvider(), nextModule, monitor);
            ModuleDelta moduleDelta = null;
            try {
                project.accept((IResourceVisitor)visitor);
                if (monitor.isCanceled()) {
                    return;
                }
                moduleDelta = visitor.finishDeltaCreation();
            }
            catch (CoreException ex) {
                LOGGER.error("Failed to determine files of project '{}'", (Object)project.getName(), (Object)ex);
            }
            if (moduleDelta == null || moduleDelta.isEmpty()) continue;
            deltas.add(moduleDelta);
        }
        if (deltas.isEmpty()) {
            LOGGER.debug("No module deltas determined");
            return;
        }
        RefreshSoftwareSystemTask refreshTask = new RefreshSoftwareSystemTask(this.getProvider(), fileRegistry, deltas);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            LOGGER.debug("Executing delta refresh after system open with {} module deltas", (Object)deltas.size());
            refreshTask.execute(monitor);
        }
        catch (CommandException ex) {
            throw new CoreException((IStatus)new Status(4, "com.hello2morrow.sonargraph.ide.eclipse", "Delta refresh failed after system open", (Throwable)ex));
        }
    }
}

