/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.e3;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class E3EditorPart {
    private static final Logger LOGGER = LoggerFactory.getLogger(E3EditorPart.class);

    private E3EditorPart() {
    }

    public static void selectAndRevealLine(Element selection, IJavaElement eclipseJavaElement) {
        assert (eclipseJavaElement != null) : "Parameter 'eclipseJavaElement' of method 'selectAndRevealLine' must not be null";
        try {
            LOGGER.info("Trying to open {} in Editor", (Object)eclipseJavaElement);
            IEditorPart part = JavaUI.openInEditor((IJavaElement)eclipseJavaElement);
            if (selection instanceof IIssue) {
                int lineNumber = ((IIssue)selection).getLineNumber();
                E3EditorPart.goToLine(part, lineNumber);
            }
        }
        catch (JavaModelException | PartInitException e) {
            LOGGER.warn("Could not open {} in Editor", (Object)eclipseJavaElement);
        }
    }

    public static void selectAndRevealPackage(IJavaElement eclipseJavaElement) {
        assert (eclipseJavaElement != null) : "Parameter 'eclipseJavaElement' of method 'selectAndRevealPackage' must not be null";
        PackageExplorerPart part = PackageExplorerPart.getFromActivePerspective();
        if (part == null) {
            part = PackageExplorerPart.openInActivePerspective();
        }
        if (part != null) {
            part.selectAndReveal((Object)eclipseJavaElement);
        } else {
            LOGGER.warn("Could not open {} in Package View", (Object)eclipseJavaElement);
        }
    }

    private static void goToLine(IEditorPart editorPart, int lineNumber) {
        IDocument document;
        if (!(editorPart instanceof ITextEditor) || lineNumber <= 0) {
            return;
        }
        ITextEditor editor = (ITextEditor)editorPart;
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider != null && (document = documentProvider.getDocument((Object)editor.getEditorInput())) != null) {
            try {
                IRegion lineInfo = document.getLineInformation(lineNumber - 1);
                if (lineInfo != null) {
                    editor.selectAndReveal(lineInfo.getOffset(), lineInfo.getLength());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

