/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.commandhandler.remoting;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.remoting.ConfigureRemoteSelectionCommand;
import com.hello2morrow.sonargraph.core.model.remoting.IRemoteSelectionProvider;
import com.hello2morrow.sonargraph.core.model.remoting.RemoteConfiguration;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ide.eclipse.model.PreferredViewForRevealingRemoteSelection;
import com.hello2morrow.sonargraph.ide.eclipse.view.RemoteSelectionConfigurationDialog;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import jakarta.inject.Named;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.swt.widgets.Shell;

public final class ConfigureRemoteSelectionHandler
extends CommandHandlerWithCorrespondingCommand {
    private static final PreferredViewForRevealingRemoteSelection DEFAULT_VIEW = PreferredViewForRevealingRemoteSelection.PACKAGE_EXPLORER;
    private static final String PRERENCES_KEY = "remoteSelection";
    private static final String PREFERRED_VIEW_KEY = "preferredView";

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.CONFIGURE_REMOTE_SELECTION;
    }

    @Execute
    public Object execute(ISonargraphEclipsePlugin plugin, @Named(value="activeShell") Shell shell) {
        assert (plugin != null) : "Parameter 'plugin' of method 'execute' must not be null";
        assert (shell != null) : "Parameter 'shell' of method 'execute' must not be null";
        IRemoteSelectionProvider remoteSelectionProvider = (IRemoteSelectionProvider)WorkbenchRegistry.getInstance().getInstallation().getExtension(IRemoteSelectionProvider.class);
        OperationResultWithOutcome readConfigResult = remoteSelectionProvider.getConfiguration();
        if (readConfigResult.isFailure()) {
            UserInterfaceAdapter.getInstance().process((OperationResult)readConfigResult);
            return null;
        }
        PreferredViewForRevealingRemoteSelection preferredView = ConfigureRemoteSelectionHandler.getPreferredView();
        RemoteSelectionConfigurationDialog dialog = new RemoteSelectionConfigurationDialog(shell, (RemoteConfiguration)readConfigResult.getOutcome(), preferredView, remoteSelectionProvider.getDefaultConfiguration());
        if (dialog.open() == 0) {
            ConfigureRemoteSelectionHandler.savePreferredView(dialog.getPreferredView());
            final RemoteConfiguration modifiedConfiguration = dialog.getModifiedConfiguration();
            ConfigureRemoteSelectionCommand command = new ConfigureRemoteSelectionCommand(WorkbenchRegistry.getInstance().getProvider(), new ConfigureRemoteSelectionCommand.IInteraction(){

                public boolean collect(ConfigureRemoteSelectionCommand.RemoteSelectionConfigurationData data) {
                    data.setModifiedConfiguration(modifiedConfiguration);
                    return true;
                }

                public void processResult(OperationResult result) {
                    UserInterfaceAdapter.getInstance().process(result);
                }
            });
            UserInterfaceAdapter.getInstance().run((Command)command);
        }
        return null;
    }

    static PreferredViewForRevealingRemoteSelection getPreferredView() {
        IEclipsePreferences preferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.ide.eclipse", (String)PRERENCES_KEY);
        String preferredViewName = preferences.get(PREFERRED_VIEW_KEY, DEFAULT_VIEW.getStandardName());
        PreferredViewForRevealingRemoteSelection preferredView = PreferredViewForRevealingRemoteSelection.fromStandardName(preferredViewName);
        if (preferredView == null) {
            preferredView = DEFAULT_VIEW;
        }
        return preferredView;
    }

    static void savePreferredView(PreferredViewForRevealingRemoteSelection preferred) {
        assert (preferred != null) : "Parameter 'preferred' of method 'savePreferredView' must not be null";
        IEclipsePreferences preferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.ide.eclipse", (String)PRERENCES_KEY);
        preferences.put(PREFERRED_VIEW_KEY, preferred.getStandardName());
        PreferencesUtility.save((IEclipsePreferences)preferences);
    }

    @CanExecute
    public boolean canExecute(@Optional ISonargraphEclipsePlugin plugin, @Optional MToolItem toolItem) {
        return plugin != null && plugin.isInitialized() && !plugin.isStopping();
    }
}

