/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.commandhandler.diff;

import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.SystemDiffConfiguration;
import com.hello2morrow.sonargraph.ide.eclipse.commandhandler.diff.AbstractSystemDiffHandler;
import com.hello2morrow.sonargraph.ide.eclipse.jobs.diff.SetBaselineJob;
import com.hello2morrow.sonargraph.ide.eclipse.model.IMarkerProvider;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Shell;

public final class ActivateSystemBaselineHandler
extends AbstractSystemDiffHandler {
    @Execute
    public Object execute(IEventBroker eventBroker, ISonargraphEclipsePlugin plugin, IMarkerProvider markerProvider, @Named(value="activeShell") Shell shell) {
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'execute' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'execute' must not be null";
        assert (shell != null) : "Parameter 'shell' of method 'execute' must not be null";
        SystemDiffConfiguration configuration = this.getDiffConfiguration(plugin);
        SetBaselineJob job = new SetBaselineJob(eventBroker, plugin, configuration.getSystemBaseline(), BaselineType.SYSTEM);
        job.schedule();
        return null;
    }

    @Override
    @CanExecute
    public boolean canExecute(@Optional ISonargraphEclipsePlugin plugin, @Optional SonargraphLicenseHandler licenseHandler) {
        boolean isLicensedAndHasSystem = super.canExecute(plugin, licenseHandler);
        if (!isLicensedAndHasSystem) {
            return false;
        }
        SystemDiffConfiguration configuration = this.getDiffConfiguration(plugin);
        return (configuration.getBaselineType() == null || configuration.getBaselineType() != BaselineType.SYSTEM) && configuration.getSystemBaseline() != null;
    }

    private SystemDiffConfiguration getDiffConfiguration(ISonargraphEclipsePlugin plugin) {
        SoftwareSystem softwareSystem = plugin.getSoftwareSystemProvider().getSoftwareSystem();
        ISystemDiffProvider systemDiffProvider = (ISystemDiffProvider)softwareSystem.getExtension(ISystemDiffProvider.class);
        SystemDiffConfiguration configuration = systemDiffProvider.getSystemDiffConfiguration();
        return configuration;
    }
}

