/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ide.eclipse.commandhandler;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.ide.eclipse.e3.E3EditorPart;
import com.hello2morrow.sonargraph.ide.eclipse.model.ElementMapper;
import com.hello2morrow.sonargraph.ide.eclipse.model.ISonargraphEclipsePlugin;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;

public class ShowInViewHandler
extends CommandHandler {
    @Execute
    public void execute(ISonargraphEclipsePlugin plugin, @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection activeSelection) {
        if (activeSelection.getElements().size() == 1) {
            Element selection = (Element)activeSelection.getElements().get(0);
            IJavaElement eclipseJavaElement = ElementMapper.getEclipseElementFromSelection(selection);
            if (eclipseJavaElement instanceof IPackageFragment) {
                E3EditorPart.selectAndRevealPackage(eclipseJavaElement);
            } else if (eclipseJavaElement != null) {
                E3EditorPart.selectAndRevealLine(selection, eclipseJavaElement);
            }
        }
    }

    @CanExecute
    public boolean canExecute(@Optional ISonargraphEclipsePlugin plugin) {
        if (plugin == null) {
            return false;
        }
        return plugin.isInitialized() && plugin.getSoftwareSystemProvider().hasSoftwareSystem();
    }

    public IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> currentSelection) {
                if (currentSelection.size() == 1) {
                    Element selection = currentSelection.get(0);
                    IJavaElement eclipseJavaElement = ElementMapper.getEclipseElementFromSelection(selection);
                    return eclipseJavaElement != null;
                }
                return false;
            }
        };
    }
}

